/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.Formatter;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.tools.DataFactory;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.ToolsUI;
import ucar.nc2.ui.op.StationRadialViewer;
import ucar.ui.widget.BAMutil;
import ucar.util.prefs.PreferencesExt;

public class StationRadialPanel
extends OpPanel {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private StationRadialViewer radialViewer;
    private JSplitPane split;
    private FeatureDataset radarCollectionDataset;

    public StationRadialPanel(PreferencesExt dbPrefs) {
        super(dbPrefs, "dataset:", true, false);
        this.radialViewer = new StationRadialViewer(dbPrefs);
        this.add((Component)this.radialViewer, "Center");
        AbstractButton infoButton = BAMutil.makeButtcon("Information", "Dataset Info", false);
        infoButton.addActionListener(e -> {
            if (this.radarCollectionDataset != null) {
                Formatter info = new Formatter();
                this.radarCollectionDataset.getDetailInfo(info);
                this.detailTA.setText(info.toString());
                this.detailTA.gotoTop();
                this.detailWindow.show();
            }
        });
        this.buttPanel.add(infoButton);
    }

    @Override
    public boolean process(Object o) {
        String location = (String)o;
        return this.setStationRadialDataset(location);
    }

    @Override
    public void closeOpenFiles() throws IOException {
        if (this.radarCollectionDataset != null) {
            this.radarCollectionDataset.close();
        }
        this.radarCollectionDataset = null;
    }

    @Override
    public void save() {
        super.save();
        this.radialViewer.save();
    }

    public boolean setStationRadialDataset(String location) {
        if (location == null) {
            return false;
        }
        try {
            if (this.radarCollectionDataset != null) {
                this.radarCollectionDataset.close();
            }
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        DataFactory.Result result = null;
        try {
            result = ToolsUI.getThreddsDataFactory().openFeatureDataset(FeatureType.STATION_RADIAL, location, null);
            if (result.fatalError) {
                JOptionPane.showMessageDialog(null, "Can't open " + location + ": " + result.errLog);
                result.close();
                return false;
            }
            this.setStationRadialDataset(result.featureDataset);
            return true;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            JOptionPane.showMessageDialog(this, e.getMessage());
            if (result != null) {
                try {
                    result.close();
                }
                catch (IOException ioe2) {
                    JOptionPane.showMessageDialog(null, "Can't open " + location + ": " + ioe2.getMessage());
                }
            }
            return false;
        }
    }

    public boolean setStationRadialDataset(FeatureDataset dataset) {
        if (dataset == null) {
            return false;
        }
        try {
            if (this.radarCollectionDataset != null) {
                this.radarCollectionDataset.close();
            }
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        this.radarCollectionDataset = dataset;
        this.radialViewer.setDataset(this.radarCollectionDataset);
        this.setSelectedItem(this.radarCollectionDataset.getLocation());
        return true;
    }
}

