/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.RootPaneContainer;
import org.apache.http.Header;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;
import ucar.nc2.util.IO;
import ucar.ui.event.ActionValueEvent;
import ucar.ui.event.ActionValueListener;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.SuperComboBox;
import ucar.unidata.util.StringUtil2;
import ucar.util.prefs.PreferencesExt;

public class WmsViewer
extends JPanel {
    private Namespace wmsNamespace = Namespace.getNamespace("http://www.opengis.net/wms");
    private PreferencesExt prefs;
    private JPanel imagePanel;
    private SuperComboBox crsChooser;
    private SuperComboBox formatChooser;
    private SuperComboBox styleChooser;
    private SuperComboBox timeChooser;
    private SuperComboBox levelChooser;
    private BeanTable ftTable;
    private JSplitPane split;
    private Formatter info = new Formatter();
    private String version;
    private String endpoint;
    private BufferedImage currImage;

    public WmsViewer(PreferencesExt prefs, RootPaneContainer root) {
        this.prefs = prefs;
        JPanel chooserPanel = new JPanel();
        chooserPanel.setLayout(new FlowLayout(0, 0, 0));
        this.crsChooser = new SuperComboBox(root, "crs", false, null);
        chooserPanel.add(new JLabel("CRS:"));
        chooserPanel.add(this.crsChooser);
        this.formatChooser = new SuperComboBox(root, "format", false, null);
        chooserPanel.add(new JLabel("format:"));
        chooserPanel.add(this.formatChooser);
        this.styleChooser = new SuperComboBox(root, "style", false, null);
        chooserPanel.add(new JLabel("Style:"));
        chooserPanel.add(this.styleChooser);
        this.timeChooser = new SuperComboBox(root, "time", false, null);
        chooserPanel.add(new JLabel("Time:"));
        chooserPanel.add(this.timeChooser);
        this.levelChooser = new SuperComboBox(root, "level", false, null);
        chooserPanel.add(new JLabel("Level:"));
        chooserPanel.add(this.levelChooser);
        this.timeChooser.addActionValueListener(new ActionValueListener(){

            @Override
            public void actionPerformed(ActionValueEvent e) {
                if (null == WmsViewer.this.timeChooser.getSelectedObject()) {
                    return;
                }
                LayerBean ftb = (LayerBean)WmsViewer.this.ftTable.getSelectedBean();
                WmsViewer.this.getMap(ftb);
            }
        });
        AbstractButton mapButton = BAMutil.makeButtcon("nj22/WorldDetailMap", "getMap", false);
        mapButton.addActionListener(e -> {
            LayerBean ftb = (LayerBean)this.ftTable.getSelectedBean();
            this.getMap(ftb);
        });
        chooserPanel.add(mapButton);
        AbstractButton redrawButton = BAMutil.makeButtcon("alien", "redraw image", false);
        redrawButton.addActionListener(e -> this.showImage(this.currImage));
        chooserPanel.add(redrawButton);
        this.imagePanel = new JPanel();
        this.ftTable = new BeanTable<LayerBean>(LayerBean.class, (PreferencesExt)prefs.node("LayerBeans"), false);
        this.ftTable.addListSelectionListener(e -> {
            LayerBean ftb = (LayerBean)this.ftTable.getSelectedBean();
            this.styleChooser.setCollection(ftb.styles.iterator());
            this.timeChooser.setCollection(ftb.times.iterator());
            this.levelChooser.setCollection(ftb.levels.iterator());
        });
        this.ftTable.setBeans(new ArrayList());
        this.split = new JSplitPane(1, false, this.ftTable, this.imagePanel);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)chooserPanel, "North");
        this.add((Component)this.split, "Center");
    }

    public boolean setDataset(String version, String endpoint) {
        this.version = version;
        this.endpoint = endpoint;
        return this.getCapabilities();
    }

    public String getDetailInfo() {
        return this.info.toString();
    }

    public void save() {
        this.ftTable.saveState(false);
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
    }

    private void showImage(BufferedImage img) {
        if (img != null) {
            Graphics g2 = this.imagePanel.getGraphics();
            g2.drawImage(img, 0, 0, null);
            g2.dispose();
            this.currImage = img;
        } else {
            Graphics2D g3 = (Graphics2D)this.imagePanel.getGraphics();
            g3.clearRect(0, 0, this.getWidth(), this.getHeight());
            g3.dispose();
            this.currImage = null;
        }
    }

    private boolean getCapabilities() {
        Formatter f = new Formatter();
        if (this.endpoint.indexOf("?") > 0) {
            f.format("%s&request=GetCapabilities&service=WMS&version=%s", this.endpoint, this.version);
        } else {
            f.format("%s?request=GetCapabilities&service=WMS&version=%s", this.endpoint, this.version);
        }
        System.out.printf("getCapabilities request = '%s'%n", f);
        String url = f.toString();
        this.info = new Formatter();
        this.info.format("%s%n", url);
        try (HTTPSession session = HTTPFactory.newSession(url);
             HTTPMethod method = HTTPFactory.Get(session, url);){
            int statusCode = method.execute();
            this.info.format(" Status = %d %s%n", method.getStatusCode(), method.getStatusText());
            this.info.format(" Status Line = %s%n", method.getStatusLine());
            this.printHeaders(" Response Headers", method.getResponseHeaders());
            this.info.format("GetCapabilities:%n%n", new Object[0]);
            if (statusCode == 404) {
                throw new FileNotFoundException(method.getPath() + " " + method.getStatusLine());
            }
            if (statusCode >= 300) {
                throw new IOException(method.getPath() + " " + method.getStatusLine());
            }
            SAXBuilder builder = new SAXBuilder();
            Document tdoc = builder.build(method.getResponseAsStream());
            Element root = tdoc.getRootElement();
            this.parseGetCapabilities(root);
        }
        catch (Exception e) {
            this.info.format("%s%n", e.getMessage());
            JOptionPane.showMessageDialog(this, "Failed " + e.getMessage());
            return false;
        }
        return true;
    }

    private void parseGetCapabilities(Element root) {
        Element capElem = root.getChild("Capability", this.wmsNamespace);
        Element layer1Elem = capElem.getChild("Layer", this.wmsNamespace);
        ArrayList<String> crsList = new ArrayList<String>(100);
        List<Element> crs = layer1Elem.getChildren("CRS", this.wmsNamespace);
        for (Element crsElem : crs) {
            crsList.add(crsElem.getText());
        }
        this.crsChooser.setCollection(crsList.iterator());
        Element reqElem = capElem.getChild("Request", this.wmsNamespace);
        Element mapElem = reqElem.getChild("GetMap", this.wmsNamespace);
        ArrayList<String> formatList = new ArrayList<String>(100);
        List<Element> formats = mapElem.getChildren("Format", this.wmsNamespace);
        for (Element formatElem : formats) {
            formatList.add(formatElem.getText());
        }
        this.formatChooser.setCollection(formatList.iterator());
        ArrayList<LayerBean> beans = new ArrayList<LayerBean>(100);
        Element layer2Elem = layer1Elem.getChild("Layer", this.wmsNamespace);
        List<Element> layers = layer2Elem.getChildren("Layer", this.wmsNamespace);
        for (Element layer3Elem : layers) {
            beans.add(new LayerBean(layer3Elem));
        }
        this.ftTable.setBeans(beans);
        this.ftTable.refresh();
    }

    private boolean getMap(LayerBean layer) {
        block55: {
            Formatter f = new Formatter();
            f.format("%s?request=GetMap&service=WMS&version=%s&", this.endpoint, this.version);
            f.format("layers=%s&CRS=%s&", layer.getName(), layer.getCRS());
            f.format("bbox=%s,%s,%s,%s&", layer.getMinx(), layer.getMiny(), layer.getMaxx(), layer.getMaxy());
            f.format("width=500&height=500&", new Object[0]);
            f.format("styles=%s&", this.styleChooser.getSelectedObject());
            f.format("format=%s&", this.formatChooser.getSelectedObject());
            if (layer.hasTime) {
                f.format("time=%s&", this.timeChooser.getSelectedObject());
            }
            if (layer.hasLevel) {
                f.format("elevation=%s&", this.levelChooser.getSelectedObject());
            }
            String url = f.toString();
            this.info.format("%s%n", url);
            try (HTTPMethod method = HTTPFactory.Get(url);){
                int statusCode = method.execute();
                this.info.format(" Status = %d %s%n", method.getStatusCode(), method.getStatusText());
                this.info.format(" Status Line = %s%n", method.getStatusLine());
                this.printHeaders(" Response Headers", method.getResponseHeaders());
                if (statusCode == 404) {
                    throw new FileNotFoundException(method.getPath() + " " + method.getStatusLine());
                }
                if (statusCode >= 300) {
                    throw new IOException(method.getPath() + " " + method.getStatusLine());
                }
                Header h2 = method.getResponseHeader("Content-Type");
                String mimeType = h2 == null ? "" : h2.getValue();
                this.info.format(" mimeType = %s%n", mimeType);
                try (InputStream isFromHttp = method.getResponseBodyAsStream();){
                    byte[] contents = IO.readContentsToByteArray(isFromHttp);
                    this.info.format(" content len = %s%n", contents.length);
                    ByteArrayInputStream is = new ByteArrayInputStream(contents);
                    BufferedImage img = ImageIO.read(is);
                    this.showImage(img);
                    if (img != null) break block55;
                    this.info.format("getMap:%n%n", new Object[0]);
                    if (mimeType.equals("application/vnd.google-earth.kmz")) {
                        File temp = File.createTempFile("Temp", ".kmz");
                        IO.writeToFile(contents, temp);
                        contents = null;
                        try (ZipFile zfile = new ZipFile(temp);){
                            Enumeration<? extends ZipEntry> entries = zfile.entries();
                            while (entries.hasMoreElements()) {
                                ZipEntry entry = entries.nextElement();
                                this.info.format(" entry= %s%n", entry);
                                if (!entry.getName().endsWith(".kml")) continue;
                                InputStream kml = zfile.getInputStream(entry);
                                Throwable throwable = null;
                                try {
                                    contents = IO.readContentsToByteArray(kml);
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (kml == null) continue;
                                    if (throwable != null) {
                                        try {
                                            kml.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    kml.close();
                                }
                            }
                        }
                    }
                    if (contents != null) {
                        this.info.format("%s%n", new String(contents, StandardCharsets.UTF_8));
                    }
                }
            }
            catch (IOException e) {
                this.info.format("%s%n", e.getMessage());
                JOptionPane.showMessageDialog(this, "Failed " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    private void printHeaders(String title, Header[] heads) {
        this.info.format("%s%n", title);
        for (Header head : heads) {
            this.info.format("%s ", head.toString());
        }
        this.info.format("%n", new Object[0]);
    }

    public class LayerBean {
        String name;
        String title;
        String CRS;
        String minx;
        String maxx;
        String miny;
        String maxy;
        boolean hasTime;
        boolean hasLevel;
        List<String> styles = new ArrayList<String>();
        List<String> levels = new ArrayList<String>();
        List<String> times = new ArrayList<String>();

        public LayerBean() {
        }

        LayerBean(Element layer3Elem) {
            this.name = this.getVal(layer3Elem, "Name");
            this.title = this.getVal(layer3Elem, "Title");
            Element bbElem = layer3Elem.getChild("BoundingBox", WmsViewer.this.wmsNamespace);
            this.CRS = bbElem.getAttributeValue("CRS");
            this.minx = bbElem.getAttributeValue("minx");
            this.maxx = bbElem.getAttributeValue("maxx");
            this.miny = bbElem.getAttributeValue("miny");
            this.maxy = bbElem.getAttributeValue("maxy");
            for (Element elem : layer3Elem.getChildren("Style", WmsViewer.this.wmsNamespace)) {
                Element nameElem = elem.getChild("Name", WmsViewer.this.wmsNamespace);
                this.styles.add(nameElem.getText());
            }
            for (Element elem : layer3Elem.getChildren("Dimension", WmsViewer.this.wmsNamespace)) {
                String[] st;
                String name = elem.getAttributeValue("name");
                if (name.equals("time")) {
                    for (String s2 : st = elem.getText().split(",")) {
                        this.times.add(StringUtil2.removeWhitespace(s2));
                    }
                    boolean bl = this.hasTime = !this.times.isEmpty();
                }
                if (!name.equals("elevation")) continue;
                for (String s2 : st = elem.getText().split(",")) {
                    this.levels.add(StringUtil2.removeWhitespace(s2));
                }
                this.hasLevel = !this.levels.isEmpty();
            }
        }

        String getVal(Element parent, String name) {
            Element elem = parent.getChild(name, WmsViewer.this.wmsNamespace);
            return name == null ? "" : elem.getText();
        }

        List<String> getVals(Element parent, String name) {
            ArrayList<String> result = new ArrayList<String>(10);
            for (Element elem : parent.getChildren(name, WmsViewer.this.wmsNamespace)) {
                result.add(elem.getText());
            }
            return result;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public String getCRS() {
            return this.CRS;
        }

        public String getMinx() {
            return this.minx;
        }

        public String getMaxx() {
            return this.maxx;
        }

        public String getMiny() {
            return this.miny;
        }

        public String getMaxy() {
            return this.maxy;
        }
    }
}

