/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.point;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ui.util.Renderer;
import ucar.ui.widget.FontUtil;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;

public class PointRenderer
implements Renderer {
    private List<ObservationUI> obsUIlist = new ArrayList<ObservationUI>();
    private ProjectionImpl project;
    private Color color = Color.black;
    private Color selectedColor = Color.magenta;
    private int circleRadius = 3;
    private Rectangle2D circleBB = new Rectangle2D.Double(-this.circleRadius, -this.circleRadius, 2 * this.circleRadius, 2 * this.circleRadius);
    private FontUtil.StandardFont textFont = FontUtil.getStandardFont(10);
    private boolean drawConnectingLine;
    private ObservationUI selected;
    private boolean declutter = true;
    private boolean posWasCalc;

    public void incrFontSize() {
        this.textFont.incrFontSize();
    }

    public void decrFontSize() {
        this.textFont.decrFontSize();
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public LatLonRect getPreferredArea() {
        return null;
    }

    public void setPointFeatures(List<PointFeature> obs) throws IOException {
        this.obsUIlist = new ArrayList<ObservationUI>(obs.size());
        for (PointFeature ob : obs) {
            ObservationUI sui = new ObservationUI(ob);
            this.obsUIlist.add(sui);
        }
        this.posWasCalc = false;
        this.calcWorldPos();
        this.selected = null;
    }

    public void setDrawConnectingLine(boolean drawConnectingLine) {
        this.drawConnectingLine = drawConnectingLine;
    }

    public void setSelected(PointFeature obs) {
        this.selected = null;
        for (ObservationUI observationUI : this.obsUIlist) {
            ObservationUI s2 = observationUI;
            if (!this.testPointObsDatatype(s2.obs, obs)) continue;
            this.selected = s2;
            break;
        }
    }

    private boolean testPointObsDatatype(PointFeature obs1, PointFeature obs2) {
        if (obs1.getObservationTime() != obs2.getObservationTime()) {
            return false;
        }
        EarthLocation loc1 = obs1.getLocation();
        EarthLocation loc2 = obs2.getLocation();
        if (loc1.getLatitude() != loc2.getLatitude()) {
            return false;
        }
        return loc1.getLongitude() == loc2.getLongitude();
    }

    public void setDeclutter(boolean declut) {
        this.declutter = declut;
    }

    public boolean getDeclutter() {
        return this.declutter;
    }

    @Override
    public void setProjection(ProjectionImpl project) {
        this.project = project;
        this.calcWorldPos();
    }

    private void calcWorldPos() {
        if (this.project == null) {
            return;
        }
        Iterator<ObservationUI> iterator = this.obsUIlist.iterator();
        while (iterator.hasNext()) {
            ObservationUI observationUI;
            ObservationUI s2 = observationUI = iterator.next();
            s2.worldPos.setLocation(this.project.latLonToProj(s2.latlonPos));
        }
        this.posWasCalc = true;
    }

    @Override
    public void draw(Graphics2D g2, AffineTransform normal2Device) {
        AffineTransform world2Normal;
        if (this.project == null || !this.posWasCalc) {
            return;
        }
        AffineTransform world2Device = g2.getTransform();
        g2.setTransform(normal2Device);
        try {
            world2Normal = normal2Device.createInverse();
            world2Normal.concatenate(world2Device);
        }
        catch (NoninvertibleTransformException e) {
            System.out.println(" RendSurfObs: NoninvertibleTransformException on " + normal2Device);
            return;
        }
        Object saveHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setFont(this.textFont.getFont());
        g2.setColor(this.color);
        int count = 0;
        int npts = this.obsUIlist.size();
        GeneralPath path = new GeneralPath(0, npts);
        Iterator<ObservationUI> iterator = this.obsUIlist.iterator();
        while (iterator.hasNext()) {
            ObservationUI observationUI;
            ObservationUI s2 = observationUI = iterator.next();
            s2.calcPos(world2Normal);
            s2.draw(g2);
            if (Double.isNaN(s2.screenPos.getX())) {
                System.out.println("screenPos=" + s2.screenPos + " world = " + s2.worldPos);
                continue;
            }
            if (count == 0) {
                path.moveTo((float)s2.screenPos.getX(), (float)s2.screenPos.getY());
            } else {
                path.lineTo((float)s2.screenPos.getX(), (float)s2.screenPos.getY());
            }
            ++count;
        }
        g2.setColor(this.color);
        if (this.drawConnectingLine) {
            g2.draw(path);
        }
        if (this.selected != null) {
            this.selected.draw(g2);
        }
        g2.setTransform(world2Device);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, saveHint);
    }

    public class ObservationUI {
        private PointFeature obs;
        private LatLonPointImpl latlonPos = new LatLonPointImpl();
        private ProjectionPointImpl worldPos = new ProjectionPointImpl();
        private Point2D.Double screenPos = new Point2D.Double();
        private Rectangle2D bb;
        private Rectangle2D bbPos = new Rectangle2D.Double();

        ObservationUI(PointFeature obs) {
            this.obs = obs;
            this.latlonPos.setLatitude(obs.getLocation().getLatitude());
            this.latlonPos.setLongitude(obs.getLocation().getLongitude());
            Dimension t = PointRenderer.this.textFont.getBoundingBox("O");
            this.bb = new Rectangle2D.Double(-PointRenderer.this.circleRadius, (double)(-PointRenderer.this.circleRadius) - t.getHeight(), t.getWidth(), t.getHeight());
            this.bb.add(PointRenderer.this.circleBB);
        }

        public PointFeature getObservation() {
            return this.obs;
        }

        public LatLonPoint getLatLon() {
            return this.latlonPos;
        }

        public ProjectionPointImpl getLocation() {
            return this.worldPos;
        }

        public Rectangle2D getBB() {
            return this.bbPos;
        }

        boolean contains(Point p) {
            return this.bbPos.contains(p);
        }

        void calcPos(AffineTransform w2n) {
            w2n.transform(new Point2D.Double(this.worldPos.getX(), this.worldPos.getY()), this.screenPos);
            this.bbPos.setRect(this.screenPos.getX() + this.bb.getX(), this.screenPos.getY() + this.bb.getY(), this.bb.getWidth(), this.bb.getHeight());
        }

        void draw(Graphics2D g2) {
            if (this == PointRenderer.this.selected) {
                g2.setColor(PointRenderer.this.selectedColor);
                this.fillCircle(g2, this.screenPos);
                g2.setColor(PointRenderer.this.color);
            } else {
                this.drawCircle(g2, this.screenPos);
            }
        }

        private void drawCircle(Graphics2D g2, Point2D loc) {
            int x = (int)(loc.getX() - (double)PointRenderer.this.circleRadius);
            int y = (int)(loc.getY() - (double)PointRenderer.this.circleRadius);
            g2.drawOval(x, y, 2 * PointRenderer.this.circleRadius, 2 * PointRenderer.this.circleRadius);
        }

        private void fillCircle(Graphics2D g2, Point2D loc) {
            int x = (int)(loc.getX() - (double)PointRenderer.this.circleRadius);
            int y = (int)(loc.getY() - (double)PointRenderer.this.circleRadius);
            g2.fillOval(x, y, 2 * PointRenderer.this.circleRadius, 2 * PointRenderer.this.circleRadius);
        }
    }
}

