/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.AnimationControl;
import visad.CellImpl;
import visad.CommonUnit;
import visad.ConstantMap;
import visad.Control;
import visad.ControlEvent;
import visad.ControlListener;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DateTime;
import visad.DelaunayCustom;
import visad.Display;
import visad.DisplayRealType;
import visad.EarthVectorType;
import visad.FieldImpl;
import visad.FlatField;
import visad.FlowControl;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.ProjectionControl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.SetType;
import visad.Tuple;
import visad.TupleType;
import visad.UnionSet;
import visad.VisADException;
import visad.VisADRay;
import visad.bom.BarbManipulationRendererJ3D;
import visad.bom.BarbRenderer;
import visad.bom.BarbRendererJ3D;
import visad.bom.CBMKeyboardBehaviorJ3D;
import visad.bom.CollectiveBarbException;
import visad.bom.CurveManipulationRendererJ3D;
import visad.bom.DiscoverableZoom;
import visad.bom.EndManipCBM;
import visad.bom.PointManipulationRendererJ3D;
import visad.bom.SwellManipulationRendererJ3D;
import visad.bom.SwellRendererJ3D;
import visad.bom.WindPolarCoordinateSystem;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.AnimationWidget;
import visad.util.Util;
import visad.util.VisADSlider;

public class CollectiveBarbManipulation {
    private FunctionType wind_field_type = null;
    private TupleType wind_type = null;
    private RealType station_index = null;
    private FunctionType wind_station_type = null;
    private RealType time = null;
    private int nindex = 0;
    private int[] ntimes;
    private Tuple[][] tuples;
    private Tuple[][] tuples2;
    private FlatField[] wind_stations;
    private Set[] time_sets;
    private double[][] times;
    private int which_time = -1;
    private int[] which_times;
    private Set time_set = null;
    private int global_ntimes = 0;
    private double[] global_times;
    private int[][] global_to_station;
    private int[][] station_to_global;
    private float[] lats;
    private float[] lons;
    private DataReferenceImpl stations_ref;
    private DataReferenceImpl[] station_refs;
    private DataRenderer barb_renderer;
    private DataRenderer[] barb_manipulation_renderers;
    private BarbMonitor[] barb_monitors;
    private WindMonitor wind_monitor = null;
    private AnimationControl acontrol = null;
    private ProjectionControl pcontrol = null;
    private DisplayImplJ3D display1;
    private DisplayImplJ3D display2;
    private FieldImpl wind_field;
    private boolean absolute;
    private float inner_distance;
    private float outer_distance;
    private double inner_time;
    private double outer_time;
    private DataReference curve_ref = null;
    private boolean barbs;
    private boolean force_station;
    private boolean knots;
    private ConstantMap[] cmaps;
    private int azimuth_index;
    private int radial_index;
    private int azimuth_index2;
    private int radial_index2;
    private int lat_index;
    private int lon_index;
    private int last_sta = -1;
    private int last_time = -1;
    private int last_display = -1;
    private boolean last_curve = true;
    private float[][] azimuths;
    private float[][] radials;
    private float[][] old_azimuths;
    private float[][] old_radials;
    private int station = -1;
    private DataReferenceImpl[] time_refs = null;
    private DataRenderer[] barb_manipulation_renderers2 = null;
    private BarbMonitor2[] barb_monitors2 = null;
    private Object data_lock = new Object();
    private boolean ended = false;
    private int time_dir = 0;
    private static final int NCIRCLE = 24;
    private DataRenderer[] circle_renderer = null;
    private DataReferenceImpl[] circle_ref = null;
    private boolean circle_enable = false;
    private Releaser releaser = null;
    private DataReferenceImpl releaser_ref = null;
    private Stepper stepper = null;
    private DataReferenceImpl stepper_ref = null;
    private boolean dzoom = false;
    private DiscoverableZoom pcl = null;
    private boolean afirst = true;
    private boolean afirst_real = true;
    private static final float DEGREE_EPS = 0.1f;
    private static final float MPS_EPS = 0.01f;
    private RealTupleType circle_type = null;
    private int current_index = 0;
    private static final double five_knots = 5.0;
    private static final int NSTAS = 5;
    private static final int NTIMES = 10;

    public CollectiveBarbManipulation(FieldImpl wf, DisplayImplJ3D d1, DisplayImplJ3D d2, ConstantMap[] cms, boolean abs, float id, float od, float it, float ot, int sta, boolean need_monitor, boolean brbs, boolean fs, boolean kts, boolean dz, double[] inner_circle_color, int inner_circle_width, double[] outer_circle_color, int outer_circle_width) throws VisADException, RemoteException {
        ConstantMap[] color_maps;
        DisplayRealType dreal;
        ScalarMap map;
        Enumeration en;
        RealType real;
        int i;
        Vector scalar_map_vector;
        this.wind_field = wf;
        this.display1 = d1;
        this.display2 = d2;
        this.cmaps = cms;
        this.absolute = abs;
        this.inner_distance = id;
        this.outer_distance = od;
        this.inner_time = it;
        this.outer_time = ot;
        this.curve_ref = null;
        this.barbs = brbs;
        this.force_station = fs;
        this.knots = kts;
        this.dzoom = dz;
        if (this.display1 == null && this.display2 == null) {
            throw new CollectiveBarbException("display1 and display2 cannot both be null");
        }
        this.wind_field_type = (FunctionType)this.wind_field.getType();
        this.wind_type = null;
        this.station_index = null;
        try {
            this.station_index = (RealType)this.wind_field_type.getDomain().getComponent(0);
            if (RealType.Time.equals(this.station_index)) {
                throw new CollectiveBarbException("wind_field bad MathType: " + this.station_index + " cannot be RealType.Time");
            }
            this.wind_station_type = (FunctionType)this.wind_field_type.getRange();
            this.time = (RealType)this.wind_station_type.getDomain().getComponent(0);
            if (!RealType.Time.equals(this.time)) {
                throw new CollectiveBarbException("wind_field bad MathType: " + this.time + " must be RealType.Time");
            }
            this.wind_type = (TupleType)this.wind_station_type.getRange();
            if (!this.wind_type.getFlat()) {
                throw new CollectiveBarbException("wind_field bad MathType: " + this.wind_type + " must be flat");
            }
        }
        catch (ClassCastException e) {
            throw new CollectiveBarbException("wind_field bad MathType: " + this.wind_field_type);
        }
        this.lat_index = -1;
        this.lon_index = -1;
        RealType[] real_types = this.wind_type.getRealComponents();
        int tuple_dim = real_types.length;
        for (int i2 = 0; i2 < tuple_dim; ++i2) {
            RealType real2 = real_types[i2];
            if (RealType.Latitude.equals(real2)) {
                this.lat_index = i2;
                continue;
            }
            if (!RealType.Longitude.equals(real2)) continue;
            this.lon_index = i2;
        }
        if (this.lat_index < 0 || this.lon_index < 0) {
            throw new CollectiveBarbException("wind data must include Latitude and Longitude " + this.lat_index + " " + this.lon_index);
        }
        this.azimuth_index = -1;
        this.radial_index = -1;
        int azimuth12 = -1;
        int radial12 = -2;
        if (this.display1 != null) {
            scalar_map_vector = this.display1.getMapVector();
            for (i = 0; i < tuple_dim; ++i) {
                real = real_types[i];
                en = scalar_map_vector.elements();
                while (en.hasMoreElements()) {
                    map = (ScalarMap)en.nextElement();
                    if (!real.equals(map.getScalar())) continue;
                    dreal = map.getDisplayScalar();
                    if (Display.Flow1Azimuth.equals(dreal)) {
                        this.azimuth_index = i;
                        azimuth12 = 1;
                        continue;
                    }
                    if (Display.Flow2Azimuth.equals(dreal)) {
                        this.azimuth_index = i;
                        azimuth12 = 2;
                        continue;
                    }
                    if (Display.Flow1Radial.equals(dreal)) {
                        this.radial_index = i;
                        radial12 = 1;
                        continue;
                    }
                    if (!Display.Flow2Radial.equals(dreal)) continue;
                    this.radial_index = i;
                    radial12 = 2;
                }
            }
            if (this.azimuth_index < 0 || this.radial_index < 0 || azimuth12 != radial12) {
                throw new CollectiveBarbException("wind data must include two RealTypes mapped to Flow1Azimuth and Flow1Radial, or to Flow2Azimuth and Flow2Radial, in display1 " + this.azimuth_index + " " + this.radial_index);
            }
        }
        this.azimuth_index2 = -1;
        this.radial_index2 = -1;
        azimuth12 = -1;
        radial12 = -2;
        if (this.display2 != null) {
            scalar_map_vector = this.display2.getMapVector();
            for (i = 0; i < tuple_dim; ++i) {
                real = real_types[i];
                en = scalar_map_vector.elements();
                while (en.hasMoreElements()) {
                    map = (ScalarMap)en.nextElement();
                    if (!real.equals(map.getScalar())) continue;
                    dreal = map.getDisplayScalar();
                    if (Display.Flow1Azimuth.equals(dreal)) {
                        this.azimuth_index2 = i;
                        azimuth12 = 1;
                        continue;
                    }
                    if (Display.Flow2Azimuth.equals(dreal)) {
                        this.azimuth_index2 = i;
                        azimuth12 = 2;
                        continue;
                    }
                    if (Display.Flow1Radial.equals(dreal)) {
                        this.radial_index2 = i;
                        radial12 = 1;
                        continue;
                    }
                    if (!Display.Flow2Radial.equals(dreal)) continue;
                    this.radial_index2 = i;
                    radial12 = 2;
                }
            }
            if (this.azimuth_index2 < 0 || this.radial_index2 < 0 || azimuth12 != radial12) {
                throw new CollectiveBarbException("wind data must include two RealTypes mapped to Flow1Azimuth and Flow1Radial, or to Flow2Azimuth and Flow2Radial, in display2 " + this.azimuth_index2 + " " + this.radial_index2);
            }
            if (this.display1 != null) {
                if (this.azimuth_index2 != this.azimuth_index) {
                    throw new CollectiveBarbException("same RealTypes must be mapped to Flow1Azimuth in display1 and display2 " + real_types[this.azimuth_index] + " " + real_types[this.azimuth_index2]);
                }
                if (this.radial_index2 != this.radial_index) {
                    throw new CollectiveBarbException("same RealTypes must be mapped to Flow1Radial in display1 and display2 " + real_types[this.radial_index] + " " + real_types[this.radial_index2]);
                }
            } else {
                this.azimuth_index = this.azimuth_index2;
                this.radial_index = this.radial_index2;
            }
        }
        if (this.inner_time < 0.0 || this.outer_time < this.inner_time) {
            throw new CollectiveBarbException("outer_time must be greater than inner_time");
        }
        if ((double)this.inner_distance < 0.0 || this.outer_distance < this.inner_distance) {
            throw new CollectiveBarbException("outer_distance must be greater than distance_time");
        }
        this.setupData();
        if (this.display1 != null) {
            this.pcontrol = this.display1.getProjectionControl();
            if (this.dzoom) {
                this.pcl = new DiscoverableZoom();
                this.pcontrol.addControlListener(this.pcl);
            }
            this.setupStations();
        }
        this.stepper_ref = new DataReferenceImpl("stepper");
        this.stepper = new Stepper();
        this.stepper.addReference(this.stepper_ref);
        if (this.display1 != null) {
            this.acontrol = (AnimationControl)((Object)this.display1.getControl(AnimationControl.class));
            if (this.acontrol == null) {
                throw new CollectiveBarbException("display must include ScalarMap to Animation");
            }
            Vector tmap = this.display1.getMapVector();
            for (i = 0; i < tmap.size(); ++i) {
                ScalarMap map2 = (ScalarMap)tmap.elementAt(i);
                Control c = map2.getControl();
                if (!this.acontrol.equals(c) || RealType.Time.equals(map2.getScalar())) continue;
                throw new CollectiveBarbException("must be Time mapped to Animation " + map2.getScalar());
            }
            AnimationControlListener acl = new AnimationControlListener();
            this.acontrol.addControlListener(acl);
            this.stations_ref = new DataReferenceImpl("stations_ref");
            this.stations_ref.setData(this.wind_field);
            this.barb_renderer = this.barbs ? new BarbRendererJ3D() : new SwellRendererJ3D();
            ((BarbRenderer)((Object)this.barb_renderer)).setKnotsConvert(this.knots);
            this.display1.addReferences(this.barb_renderer, this.stations_ref, this.constantMaps());
            if (need_monitor) {
                this.wind_monitor = new WindMonitor();
                this.wind_monitor.addReference(this.stations_ref);
            }
            this.acontrol.setCurrent(0);
        }
        if (this.display2 != null) {
            this.setStation(sta);
        }
        this.time_dir = 0;
        this.circle_ref = new DataReferenceImpl[]{null, null};
        this.circle_renderer = new DefaultRendererJ3D[]{null, null};
        if (this.display1 != null && inner_circle_color != null) {
            double cw = inner_circle_width > 0 ? (double)inner_circle_width : 1.0;
            color_maps = new ConstantMap[]{new ConstantMap(inner_circle_color[0], Display.Red), new ConstantMap(inner_circle_color[1], Display.Green), new ConstantMap(inner_circle_color[2], Display.Blue), new ConstantMap(cw, Display.LineWidth)};
            this.circle_ref[0] = new DataReferenceImpl("inner_circle");
            this.circle_ref[0].setData(null);
            this.circle_renderer[0] = new DefaultRendererJ3D();
            this.display1.addReferences(this.circle_renderer[0], this.circle_ref[0], color_maps);
            this.circle_renderer[0].toggle(false);
            this.circle_renderer[0].suppressExceptions(true);
        }
        if (this.display1 != null && outer_circle_color != null) {
            double cw = outer_circle_width > 0 ? (double)outer_circle_width : 1.0;
            color_maps = new ConstantMap[]{new ConstantMap(outer_circle_color[0], Display.Red), new ConstantMap(outer_circle_color[1], Display.Green), new ConstantMap(outer_circle_color[2], Display.Blue), new ConstantMap(cw, Display.LineWidth)};
            this.circle_ref[1] = new DataReferenceImpl("outer_circle");
            this.circle_ref[1].setData(null);
            this.circle_renderer[1] = new DefaultRendererJ3D();
            this.display1.addReferences(this.circle_renderer[1], this.circle_ref[1], color_maps);
            this.circle_renderer[1].toggle(false);
            this.circle_renderer[1].suppressExceptions(true);
        }
        this.releaser_ref = new DataReferenceImpl("releaser");
        this.releaser = new Releaser();
        this.releaser.addReference(this.releaser_ref);
    }

    private void setupData() throws VisADException, RemoteException {
        int i;
        int i2;
        try {
            this.nindex = this.wind_field.getLength();
            this.ntimes = new int[this.nindex];
            this.tuples = new Tuple[this.nindex][];
            this.tuples2 = new Tuple[this.nindex][];
            this.which_times = new int[this.nindex];
            this.wind_stations = new FlatField[this.nindex];
            this.time_sets = new Set[this.nindex];
            this.times = new double[this.nindex][];
            this.azimuths = new float[this.nindex][];
            this.radials = new float[this.nindex][];
            this.old_azimuths = new float[this.nindex][];
            this.old_radials = new float[this.nindex][];
            for (i2 = 0; i2 < this.nindex; ++i2) {
                this.wind_stations[i2] = (FlatField)this.wind_field.getSample(i2);
                this.ntimes[i2] = this.wind_stations[i2].getLength();
                this.time_sets[i2] = this.wind_stations[i2].getDomainSet();
                double[][] dummy = Set.floatToDouble(this.time_sets[i2].getSamples());
                this.times[i2] = dummy[0];
                this.time_set = i2 == 0 ? this.time_sets[i2] : this.time_set.merge1DSets(this.time_sets[i2]);
                this.tuples[i2] = new Tuple[this.ntimes[i2]];
                this.tuples2[i2] = new Tuple[this.ntimes[i2]];
                this.azimuths[i2] = new float[this.ntimes[i2]];
                this.radials[i2] = new float[this.ntimes[i2]];
                this.old_azimuths[i2] = new float[this.ntimes[i2]];
                this.old_radials[i2] = new float[this.ntimes[i2]];
                Enumeration e = this.wind_stations[i2].domainEnumeration();
                for (int j = 0; j < this.ntimes[i2]; ++j) {
                    this.tuples[i2][j] = (Tuple)this.wind_stations[i2].getSample(j);
                    int n = this.tuples[i2][j].getDimension();
                    Data[] components = new Data[n + 1];
                    for (int k = 0; k < n; ++k) {
                        components[k] = this.tuples[i2][j].getComponent(k);
                    }
                    components[n] = ((RealTuple)e.nextElement()).getComponent(0);
                    this.tuples2[i2][j] = new Tuple(components);
                }
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new CollectiveBarbException("wind_field bad MathType: " + this.wind_field_type);
        }
        this.global_ntimes = this.time_set.getLength();
        this.global_times = new double[this.global_ntimes];
        this.global_to_station = new int[this.nindex][this.global_ntimes];
        this.station_to_global = new int[this.nindex][];
        for (i2 = 0; i2 < this.nindex; ++i2) {
            this.station_to_global[i2] = new int[this.ntimes[i2]];
            for (int j = 0; j < this.ntimes[i2]; ++j) {
                this.station_to_global[i2][j] = -1;
            }
        }
        RealTupleType in = ((SetType)this.time_set.getType()).getDomain();
        for (int j = 0; j < this.global_ntimes; ++j) {
            int[] indices = new int[]{j};
            double[][] fvalues = this.time_set.indexToDouble(indices);
            this.global_times[j] = fvalues[0][0];
            for (int i3 = 0; i3 < this.nindex; ++i3) {
                RealTupleType out = ((SetType)this.time_sets[i3].getType()).getDomain();
                double[][] values = CoordinateSystem.transformCoordinates(out, this.time_sets[i3].getCoordinateSystem(), this.time_sets[i3].getSetUnits(), null, in, this.time_set.getCoordinateSystem(), this.time_set.getSetUnits(), null, fvalues);
                indices = this.time_sets[i3].getLength() == 1 ? new int[]{0} : this.time_sets[i3].doubleToIndex(values);
                this.global_to_station[i3][j] = indices[0];
                this.station_to_global[i3][indices[0]] = j;
            }
        }
        this.lats = new float[this.nindex];
        this.lons = new float[this.nindex];
        for (i = 0; i < this.nindex; ++i) {
            float[][] values = this.wind_stations[i].getFloats(false);
            this.lats[i] = values[this.lat_index][0];
            this.lons[i] = values[this.lon_index][0];
        }
        for (i = 0; i < this.nindex; ++i) {
            for (int j = 0; j < this.ntimes[i]; ++j) {
                Real[] reals = this.tuples[i][j].getRealComponents();
                this.azimuths[i][j] = (float)reals[this.azimuth_index].getValue();
                this.radials[i][j] = (float)reals[this.radial_index].getValue();
                this.old_azimuths[i][j] = this.azimuths[i][j];
                this.old_radials[i][j] = this.radials[i][j];
            }
        }
    }

    private void setupStations() throws VisADException, RemoteException {
        int i;
        if (this.station_refs != null) {
            for (i = 0; i < this.station_refs.length; ++i) {
                this.display1.removeReference(this.station_refs[i]);
                this.barb_monitors[i].removeReference(this.station_refs[i]);
                this.barb_monitors[i].stop();
            }
        }
        this.which_time = -1;
        this.station_refs = new DataReferenceImpl[this.nindex];
        this.barb_manipulation_renderers = new DataRenderer[this.nindex];
        this.barb_monitors = new BarbMonitor[this.nindex];
        for (i = 0; i < this.nindex; ++i) {
            this.station_refs[i] = new DataReferenceImpl("station_ref" + i);
            this.station_refs[i].setData(this.tuples[i][0]);
            this.which_times[i] = -1;
            this.barb_manipulation_renderers[i] = this.barbs ? new CBarbManipulationRendererJ3D(this, i) : new CSwellManipulationRendererJ3D(this, i);
            ((BarbRenderer)((Object)this.barb_manipulation_renderers[i])).setKnotsConvert(this.knots);
            this.display1.addReferences(this.barb_manipulation_renderers[i], this.station_refs[i], this.constantMaps());
            this.barb_monitors[i] = new BarbMonitor(this.station_refs[i], i);
            this.barb_monitors[i].addReference(this.station_refs[i]);
        }
        if (this.pcl != null) {
            this.pcl.setRenderers(this.barb_manipulation_renderers, 0.2f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStation(float lat, float lon) throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            FlatField station = new FlatField(this.wind_station_type, this.time_set);
            int n = this.time_set.getLength();
            int dim = this.wind_type.getNumberOfRealComponents();
            float[][] values = new float[dim][n];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < dim; ++j) {
                    values[j][i] = 0.0f;
                }
                values[this.lat_index][i] = lat;
                values[this.lon_index][i] = lon;
            }
            station.setSamples(values, false);
            this.addStation(station);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStation(FlatField station) throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            FunctionType ftype = (FunctionType)station.getType();
            if (!this.wind_station_type.equals(ftype)) {
                throw new CollectiveBarbException("station type doesn't match");
            }
            int len = this.wind_field.getLength();
            int new_len = len + 1;
            Integer1DSet new_set = new Integer1DSet(new_len);
            FieldImpl new_wind_field = new FieldImpl(this.wind_field_type, new_set);
            for (int i = 0; i < len; ++i) {
                new_wind_field.setSample(i, this.wind_field.getSample(i), false);
            }
            new_wind_field.setSample(len, (Data)station, false);
            this.wind_field = new_wind_field;
            this.stations_ref.setData(this.wind_field);
            try {
                this.setupData();
                this.setupStations();
            }
            catch (VisADException e) {
                throw e;
            }
            catch (RemoteException e) {
                throw e;
            }
        }
        this.stepper.doAction();
    }

    public void setCollectiveParameters(boolean abs, float id, float od, float it, float ot) throws VisADException, RemoteException {
        this.absolute = abs;
        if ((double)it < 0.0 || ot < it) {
            throw new CollectiveBarbException("outer_time must be greater than inner_time");
        }
        if ((double)id < 0.0 || od < id) {
            throw new CollectiveBarbException("outer_distance must be greater than distance_time");
        }
        this.inner_distance = id;
        this.outer_distance = od;
        this.curve_ref = null;
        this.inner_time = it;
        this.outer_time = ot;
    }

    public void setCollectiveTimeParameters(boolean abs, float it, float ot) throws VisADException, RemoteException {
        this.absolute = abs;
        if ((double)it < 0.0 || ot < it) {
            throw new CollectiveBarbException("outer_time must be greater than inner_time");
        }
        this.inner_time = it;
        this.outer_time = ot;
    }

    public void setTimeDir(int dir) {
        this.time_dir = dir;
    }

    public void setCollectiveCurve(boolean abs, DataReference r, float it, float ot) throws VisADException, RemoteException {
        this.absolute = abs;
        if ((double)it < 0.0 || ot < it) {
            throw new CollectiveBarbException("outer_time must be greater than inner_time");
        }
        this.curve_ref = r;
        this.inner_time = it;
        this.outer_time = ot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStation(int sta) throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            int i;
            int n;
            if (this.display2 == null) {
                throw new CollectiveBarbException("display2 cannot be null");
            }
            if (sta < 0 || sta >= this.nindex) {
                throw new CollectiveBarbException("bad station index " + sta);
            }
            if (sta == this.station) {
                return;
            }
            this.station = sta;
            if (this.time_refs != null && this.time_refs.length != this.ntimes[this.station]) {
                n = this.time_refs.length;
                for (i = 0; i < n; ++i) {
                    this.display2.removeReference(this.time_refs[i]);
                    this.barb_monitors2[i].removeReference(this.time_refs[i]);
                    this.barb_monitors2[i].stop();
                }
                this.time_refs = null;
            }
            if (this.time_refs == null) {
                n = this.ntimes[this.station];
                this.time_refs = new DataReferenceImpl[n];
                this.barb_manipulation_renderers2 = new DataRenderer[n];
                this.barb_monitors2 = new BarbMonitor2[n];
                for (i = 0; i < n; ++i) {
                    this.time_refs[i] = new DataReferenceImpl("time_ref" + i);
                    this.time_refs[i].setData(this.tuples2[this.station][i]);
                    this.barb_manipulation_renderers2[i] = this.ended ? (this.barbs ? new BarbRendererJ3D() : new SwellRendererJ3D()) : (this.barbs ? new BarbManipulationRendererJ3D() : new SwellManipulationRendererJ3D());
                    ((BarbRenderer)((Object)this.barb_manipulation_renderers2[i])).setKnotsConvert(this.knots);
                    this.display2.addReferences(this.barb_manipulation_renderers2[i], this.time_refs[i], this.constantMaps());
                    this.barb_monitors2[i] = new BarbMonitor2(this.time_refs[i], i);
                    this.barb_monitors2[i].addReference(this.time_refs[i]);
                }
            } else {
                n = this.ntimes[this.station];
                for (i = 0; i < n; ++i) {
                    this.time_refs[i].setData(this.tuples2[this.station][i]);
                }
            }
        }
    }

    public DataRenderer[] getManipulationRenderers() {
        return this.barb_manipulation_renderers;
    }

    public DataRenderer[] getManipulationRenderers2() {
        return this.barb_manipulation_renderers2;
    }

    private ConstantMap[] constantMaps() {
        if (this.cmaps == null || this.cmaps.length == 0) {
            return null;
        }
        int n = this.cmaps.length;
        ConstantMap[] cms = new ConstantMap[n];
        for (int i = 0; i < n; ++i) {
            cms[i] = (ConstantMap)this.cmaps[i].clone();
        }
        return cms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldImpl endManipulation() throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            this.ended = true;
            if (this.display1 != null) {
                for (int i = 0; i < this.nindex; ++i) {
                    this.display1.removeReference(this.station_refs[i]);
                    this.barb_monitors[i].removeReference(this.station_refs[i]);
                    this.barb_monitors[i].stop();
                }
                this.barb_renderer = this.barbs ? new BarbRendererJ3D() : new SwellRendererJ3D();
                ((BarbRenderer)((Object)this.barb_renderer)).setKnotsConvert(this.knots);
                this.display1.addReferences(this.barb_renderer, this.stations_ref, this.constantMaps());
            }
            if (this.display2 != null && this.time_refs != null) {
                int n = this.time_refs.length;
                for (int i = 0; i < n; ++i) {
                    this.display2.removeReference(this.time_refs[i]);
                    this.barb_monitors2[i].removeReference(this.time_refs[i]);
                    this.barb_monitors2[i].stop();
                }
                this.time_refs = null;
                this.setStation(this.station);
            }
            return this.wind_field;
        }
    }

    private Tuple modifyWind(Tuple old_wind, double azimuth, double radial) throws VisADException, RemoteException {
        Tuple wind = null;
        Real[] reals = null;
        if (old_wind instanceof RealTuple) {
            reals = old_wind.getRealComponents();
            reals[this.azimuth_index] = reals[this.azimuth_index].cloneButValue(azimuth);
            reals[this.radial_index] = reals[this.radial_index].cloneButValue(radial);
            wind = new RealTuple((RealTupleType)old_wind.getType(), reals, ((RealTuple)old_wind).getCoordinateSystem());
        } else {
            int n = old_wind.getDimension();
            int k = 0;
            Data[] components = new Data[n];
            for (int c = 0; c < n; ++c) {
                components[c] = old_wind.getComponent(c);
                if (components[c] instanceof Real) {
                    if (k == this.azimuth_index) {
                        components[c] = ((Real)components[c]).cloneButValue(azimuth);
                    }
                    if (k == this.radial_index) {
                        components[c] = ((Real)components[c]).cloneButValue(radial);
                    }
                    ++k;
                    continue;
                }
                int m3 = ((RealTuple)components[c]).getDimension();
                if (k <= this.azimuth_index && this.azimuth_index < k + m3 || k <= this.radial_index && this.radial_index < k + m3) {
                    reals = ((RealTuple)components[c]).getRealComponents();
                    if (k <= this.azimuth_index && this.azimuth_index < k + m3) {
                        reals[this.azimuth_index - k] = reals[this.azimuth_index - k].cloneButValue(azimuth);
                    }
                    if (k <= this.radial_index && this.radial_index < k + m3) {
                        reals[this.radial_index - k] = reals[this.radial_index - k].cloneButValue(radial);
                    }
                    components[c] = new RealTuple((RealTupleType)components[c].getType(), reals, ((RealTuple)components[c]).getCoordinateSystem());
                }
                k += m3;
            }
            wind = new Tuple((TupleType)old_wind.getType(), components, false);
        }
        return wind;
    }

    private void collectiveAdjust(int sta_index, int time_index, DataReferenceImpl ref, int display_index) throws VisADException, RemoteException {
        boolean curve;
        Tuple new_wind = (Tuple)ref.getData();
        Real[] reals = new_wind.getRealComponents();
        float new_azimuth = (float)reals[this.azimuth_index].getValue();
        float new_radial = (float)reals[this.radial_index].getValue();
        if (Util.isApproximatelyEqual(new_azimuth, this.azimuths[sta_index][time_index], 0.1f) && Util.isApproximatelyEqual(new_radial, this.radials[sta_index][time_index], 0.01f)) {
            return;
        }
        if (display_index == 1 && this.curve_ref == null) {
            this.makeCircles(sta_index);
        }
        boolean bl = curve = this.curve_ref != null;
        if (this.last_sta != sta_index || this.last_time != time_index || this.last_display != display_index || this.last_curve != curve) {
            if (this.force_station && sta_index != this.station) {
                this.setStation(sta_index);
            }
            this.last_sta = sta_index;
            this.last_time = time_index;
            this.last_display = display_index;
            this.last_curve = curve;
            for (int i = 0; i < this.nindex; ++i) {
                for (int j = 0; j < this.ntimes[i]; ++j) {
                    this.old_azimuths[i][j] = this.azimuths[i][j];
                    this.old_radials[i][j] = this.radials[i][j];
                }
            }
        }
        if (this.wind_monitor != null) {
            this.wind_monitor.disableAction();
        }
        boolean display1_was = true;
        boolean display2_was = true;
        float diff_azimuth = new_azimuth - this.old_azimuths[sta_index][time_index];
        float diff_radial = new_radial - this.old_radials[sta_index][time_index];
        float lat = this.lats[sta_index];
        float lon = this.lons[sta_index];
        double time = this.times[sta_index][time_index];
        for (int i = 0; i < this.nindex; ++i) {
            double dist_mult = 0.0;
            if (this.curve_ref != null) {
                try {
                    float[][] samples;
                    UnionSet us;
                    SampledSet[] sets;
                    Data data = this.curve_ref.getData();
                    Gridded2DSet set = null;
                    if (data instanceof Gridded2DSet) {
                        set = (Gridded2DSet)data;
                    } else if (data instanceof UnionSet && (sets = (us = (UnionSet)this.curve_ref.getData()).getSets()).length > 0 && sets[sets.length - 1] instanceof Gridded2DSet) {
                        set = (Gridded2DSet)sets[sets.length - 1];
                    }
                    if (set != null && DelaunayCustom.inside(samples = set.getSamples(), lat, lon) && DelaunayCustom.inside(samples, this.lats[i], this.lons[i])) {
                        dist_mult = 1.0;
                    }
                }
                catch (VisADException ex) {
                    dist_mult = 0.0;
                }
            } else {
                double lat_diff = Math.abs(lat - this.lats[i]);
                double mid_lat = 0.5 * (double)(lat + this.lats[i]);
                double coslat = Math.cos(Math.PI / 180 * mid_lat);
                double lon_diff = (double)Math.abs(lon - this.lons[i]) * coslat;
                double dist = 111137.0 * Math.sqrt(lon_diff * lon_diff + lat_diff * lat_diff);
                if (dist > (double)this.outer_distance) continue;
                dist_mult = dist <= (double)this.inner_distance ? 1.0 : ((double)this.outer_distance - dist) / (double)(this.outer_distance - this.inner_distance);
            }
            for (int j = 0; j < this.ntimes[i]; ++j) {
                double time_mult;
                int ix = this.station_to_global[i][j];
                double time_diff = Math.abs(time - this.times[i][j]);
                if (time_diff > this.outer_time) continue;
                double d = time_mult = time_diff <= this.inner_time ? 1.0 : (this.outer_time - time_diff) / (this.outer_time - this.inner_time);
                if (this.time_dir > 0 && this.times[i][j] < time || this.time_dir < 0 && time < this.times[i][j]) continue;
                double mult = dist_mult * time_mult;
                if (i == sta_index && j == time_index) {
                    mult = 1.0;
                }
                double azimuth_diff = 0.0;
                double radial_diff = 0.0;
                if (this.absolute) {
                    azimuth_diff = new_azimuth - this.old_azimuths[i][j];
                    radial_diff = new_radial - this.old_radials[i][j];
                } else {
                    azimuth_diff = new_azimuth - this.old_azimuths[sta_index][time_index];
                    radial_diff = new_radial - this.old_radials[sta_index][time_index];
                }
                if (azimuth_diff < -180.0) {
                    azimuth_diff += 360.0;
                }
                if (azimuth_diff > 180.0) {
                    azimuth_diff -= 360.0;
                }
                double azimuth = (double)this.old_azimuths[i][j] + mult * azimuth_diff;
                double radial = (double)this.old_radials[i][j] + mult * radial_diff;
                if (radial < 0.0) {
                    radial = 0.0;
                }
                Tuple wind = this.modifyWind(this.tuples[i][j], azimuth, radial);
                Tuple wind2 = this.modifyWind(this.tuples2[i][j], azimuth, radial);
                this.azimuths[i][j] = (float)azimuth;
                this.radials[i][j] = (float)radial;
                this.wind_stations[i].setSample(j, (Data)wind);
                this.tuples[i][j] = wind;
                if (this.station_refs != null && j == this.which_times[i]) {
                    this.station_refs[i].setData(this.tuples[i][j]);
                }
                this.tuples2[i][j] = wind2;
                if (this.time_refs == null || i != this.station) continue;
                this.time_refs[j].setData(this.tuples2[i][j]);
            }
        }
        if (this.wind_monitor != null) {
            this.wind_monitor.enableAction();
        }
    }

    private void makeCircles(int sta_index) {
        if (this.circle_ref[0] == null && this.circle_ref[1] == null || !this.circle_enable) {
            return;
        }
        try {
            if (this.circle_type == null) {
                this.circle_type = new RealTupleType(RealType.Latitude, RealType.Longitude);
            }
            float lat = this.lats[sta_index];
            float lon = this.lons[sta_index];
            float[] dists = new float[]{this.inner_distance / 111137.0f, this.outer_distance / 111137.0f};
            float[][] circle = new float[2][25];
            float coslat = (float)Math.cos(Math.PI / 180 * (double)lat);
            for (int io = 0; io < 2; ++io) {
                if (this.circle_ref[io] == null) continue;
                for (int i = 0; i <= 24; ++i) {
                    double angle = Math.PI * 2 * (double)i / 24.0;
                    float cos = (float)Math.cos(angle);
                    float sin = (float)Math.sin(angle);
                    circle[0][i] = lat + dists[io] * cos;
                    circle[1][i] = lon + dists[io] * sin / coslat;
                }
                Gridded2DSet set = new Gridded2DSet((MathType)this.circle_type, circle, 25);
                this.circle_renderer[io].toggle(true);
                this.circle_ref[io].setData(set);
            }
        }
        catch (VisADException e) {
            System.out.println("makeCircles " + e);
        }
        catch (RemoteException e) {
            System.out.println("makeCircles " + e);
        }
    }

    void circleEnable() {
        this.circle_enable = true;
    }

    public void release() {
        this.circle_enable = false;
        try {
            this.releaser_ref.setData(null);
        }
        catch (VisADException e) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void plusAngle() throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            int time_index = this.which_times[this.current_index];
            Tuple wind = this.tuples[this.current_index][time_index];
            double azimuth = this.azimuths[this.current_index][time_index];
            double radial = this.radials[this.current_index][time_index];
            azimuth += 10.0;
            if (azimuth > 360.0) {
                azimuth -= 360.0;
            }
            Tuple new_wind = this.modifyWind(wind, azimuth, radial);
            this.wind_stations[this.current_index].setSample(time_index, (Data)new_wind);
            this.tuples[this.current_index][time_index] = new_wind;
            if (this.station_refs != null) {
                this.station_refs[this.current_index].setData(this.tuples[this.current_index][time_index]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void minusAngle() throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            int time_index = this.which_times[this.current_index];
            Tuple wind = this.tuples[this.current_index][time_index];
            double azimuth = this.azimuths[this.current_index][time_index];
            double radial = this.radials[this.current_index][time_index];
            azimuth -= 10.0;
            if (azimuth < 0.0) {
                azimuth += 360.0;
            }
            Tuple new_wind = this.modifyWind(wind, azimuth, radial);
            this.wind_stations[this.current_index].setSample(time_index, (Data)new_wind);
            this.tuples[this.current_index][time_index] = new_wind;
            if (this.station_refs != null) {
                this.station_refs[this.current_index].setData(this.tuples[this.current_index][time_index]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void plusSpeed() throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            int time_index = this.which_times[this.current_index];
            Tuple wind = this.tuples[this.current_index][time_index];
            double azimuth = this.azimuths[this.current_index][time_index];
            double radial = this.radials[this.current_index][time_index];
            Tuple new_wind = this.modifyWind(wind, azimuth, radial += 5.0);
            this.wind_stations[this.current_index].setSample(time_index, (Data)new_wind);
            this.tuples[this.current_index][time_index] = new_wind;
            if (this.station_refs != null) {
                this.station_refs[this.current_index].setData(this.tuples[this.current_index][time_index]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void minusSpeed() throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            int time_index = this.which_times[this.current_index];
            Tuple wind = this.tuples[this.current_index][time_index];
            double azimuth = this.azimuths[this.current_index][time_index];
            double radial = this.radials[this.current_index][time_index];
            radial -= 5.0;
            if (radial < 0.0) {
                radial = 0.0;
            }
            Tuple new_wind = this.modifyWind(wind, azimuth, radial);
            this.wind_stations[this.current_index].setSample(time_index, (Data)new_wind);
            this.tuples[this.current_index][time_index] = new_wind;
            if (this.station_refs != null) {
                this.station_refs[this.current_index].setData(this.tuples[this.current_index][time_index]);
            }
        }
    }

    void nextWind() {
        int n = this.nindex;
        this.current_index = this.current_index < 0 ? 0 : (this.current_index + 1) % n;
    }

    void previousWind() {
        int n = this.nindex;
        this.current_index = this.current_index < 0 ? n - 1 : (this.current_index + (n - 1)) % n;
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        CollectiveBarbManipulation[] collectiveBarbManipulationArray;
        CollectiveBarbManipulation cbm2;
        RealType lat = RealType.Latitude;
        RealType lon = RealType.Longitude;
        RealTupleType earth = new RealTupleType(lat, lon);
        RealType windx = RealType.getRealType("windx", CommonUnit.meterPerSecond);
        RealType windy = RealType.getRealType("windy", CommonUnit.meterPerSecond);
        RealType red = RealType.getRealType("red");
        RealType green = RealType.getRealType("green");
        EarthVectorType windxy = new EarthVectorType(windx, windy);
        RealType wind_dir = RealType.getRealType("wind_dir", CommonUnit.degree);
        RealType wind_speed = RealType.getRealType("wind_speed", CommonUnit.meterPerSecond);
        RealTupleType windds = null;
        windds = new RealTupleType(new RealType[]{wind_dir, wind_speed}, (CoordinateSystem)new WindPolarCoordinateSystem(windxy), null);
        RealType stn = RealType.getRealType("station");
        Integer1DSet stn_set = new Integer1DSet((MathType)stn, 25);
        RealType time = RealType.Time;
        double start = new DateTime(1999, 122, 57060.0).getValue();
        Linear1DSet time_set = new Linear1DSet((MathType)time, start, start + 2700.0, 10);
        Linear1DSet time_set2 = new Linear1DSet((MathType)time, start + 150.0, start + 2850.0, 10);
        TupleType tuple_type = null;
        tuple_type = new TupleType(new MathType[]{lon, lat, windds, red, green});
        FunctionType station_type = new FunctionType(time, tuple_type);
        FunctionType stations_type = new FunctionType(stn, station_type);
        int image_size = 128;
        RealType value = RealType.getRealType("value");
        FunctionType image_type = new FunctionType(earth, value);
        Linear2DSet image_set = new Linear2DSet((MathType)earth, -50.0, -30.0, image_size, -10.0, 10.0, image_size);
        FlatField image = new FlatField(image_type, image_set);
        float[][] image_values = new float[1][image_size * image_size];
        for (int i = 0; i < image_size * image_size; ++i) {
            image_values[0][i] = 947 * i % 677;
        }
        image_values[0][0] = 5101.0f;
        image.setSamples(image_values);
        DisplayImplJ3D display1 = new DisplayImplJ3D("display1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap lonmap = new ScalarMap(lon, Display.XAxis);
        display1.addMap(lonmap);
        lonmap.setRange(-10.0, 10.0);
        ScalarMap latmap = new ScalarMap(lat, Display.YAxis);
        display1.addMap(latmap);
        latmap.setRange(-50.0, -30.0);
        ScalarMap winds_map = new ScalarMap(wind_speed, Display.Flow1Radial);
        display1.addMap(winds_map);
        winds_map.setRange(0.0, 1.0);
        ScalarMap windd_map = new ScalarMap(wind_dir, Display.Flow1Azimuth);
        display1.addMap(windd_map);
        windd_map.setRange(0.0, 360.0);
        FlowControl flow_control = (FlowControl)windd_map.getControl();
        flow_control.setFlowScale(0.15f);
        ScalarMap amap = new ScalarMap(time, Display.Animation);
        display1.addMap(amap);
        AnimationControl acontrol = (AnimationControl)((Object)amap.getControl());
        acontrol.setStep(1000);
        display1.addMap(new ScalarMap(value, Display.RGB));
        DataReferenceImpl image_ref = new DataReferenceImpl("image");
        image_ref.setData(image);
        DisplayImplJ3D display2 = new DisplayImplJ3D("display2", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap winds_map2 = new ScalarMap(wind_speed, Display.Flow1Radial);
        display2.addMap(winds_map2);
        winds_map2.setRange(0.0, 1.0);
        ScalarMap windd_map2 = new ScalarMap(wind_dir, Display.Flow1Azimuth);
        display2.addMap(windd_map2);
        windd_map2.setRange(0.0, 360.0);
        FlowControl flow_control2 = (FlowControl)windd_map2.getControl();
        flow_control2.setFlowScale(0.15f);
        ScalarMap tmap = new ScalarMap(time, Display.XAxis);
        display2.addMap(tmap);
        tmap.setRange(start, start + 3000.0);
        FieldImpl field = new FieldImpl(stations_type, stn_set);
        FieldImpl field2 = new FieldImpl(stations_type, stn_set);
        FieldImpl field3 = new FieldImpl(stations_type, stn_set);
        int m3 = 0;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                FlatField ff = new FlatField(station_type, time_set);
                FlatField ff2 = new FlatField(station_type, time_set2);
                FlatField ff3 = new FlatField(station_type, time_set2);
                double[][] values = new double[6][10];
                double[][] values2 = new double[6][10];
                double[][] values3 = new double[6][10];
                for (int k = 0; k < 10; ++k) {
                    double u = 2.0 * (double)i / 4.0 - 1.0;
                    double v = 2.0 * (double)j / 4.0 - 1.0;
                    values[0][k] = 10.0 * u;
                    values[1][k] = 10.0 * v - 40.0;
                    double fx = 30.0 * u;
                    double fy = 30.0 * v;
                    double fd = 57.29577951308232 * Math.atan2(-fx, -fy) + (double)k * 15.0;
                    double fs = Math.sqrt(fx * fx + fy * fy);
                    values[2][k] = fd;
                    values[3][k] = fs;
                    values[4][k] = u;
                    values[5][k] = v;
                    values2[0][k] = 10.0 * u + 2.5;
                    values2[1][k] = 10.0 * v - 40.0 + 2.5;
                    values2[2][k] = fd;
                    values2[3][k] = fs;
                    values2[4][k] = u;
                    values2[5][k] = v;
                    values3[0][k] = 10.0 * u + 2.5;
                    values3[1][k] = 10.0 * v - 40.0 - 2.5;
                    values3[2][k] = fd;
                    values3[3][k] = fs;
                    values3[4][k] = u;
                    values3[5][k] = v;
                }
                ff.setSamples(values);
                field.setSample(m3, (Data)ff);
                ff2.setSamples(values2);
                field2.setSample(m3, (Data)ff2);
                ff3.setSamples(values3);
                field3.setSample(m3, (Data)ff3);
                ++m3;
            }
        }
        DataReferenceImpl barb_ref = new DataReferenceImpl("barb");
        barb_ref.setData(field3);
        BarbRendererJ3D barb_renderer = new BarbRendererJ3D();
        display1.addReferences((DataRenderer)barb_renderer, barb_ref);
        ConstantMap[] cmaps = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(0.0, Display.Blue)};
        final CollectiveBarbManipulation cbm = new CollectiveBarbManipulation(field, display1, display2, cmaps, false, 500000.0f, 1000000.0f, 0.0f, 1000.0f, 0, false, true, true, false, true, new double[]{0.0, 0.5, 0.5}, 1, new double[]{0.5, 0.5, 0.0}, 2);
        ConstantMap[] cmaps2 = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(0.0, Display.Blue)};
        CollectiveBarbManipulation collectiveBarbManipulation = cbm2 = args.length > 0 ? new CollectiveBarbManipulation(field2, display1, display2, cmaps2, false, 500000.0f, 1000000.0f, 0.0f, 1000.0f, 0, false, false, true, false, true, new double[]{0.0, 0.5, 0.5}, 1, new double[]{0.5, 0.5, 0.0}, 2) : null;
        if (cbm2 == null) {
            CollectiveBarbManipulation[] collectiveBarbManipulationArray2 = new CollectiveBarbManipulation[1];
            collectiveBarbManipulationArray = collectiveBarbManipulationArray2;
            collectiveBarbManipulationArray2[0] = cbm;
        } else {
            CollectiveBarbManipulation[] collectiveBarbManipulationArray3 = new CollectiveBarbManipulation[2];
            collectiveBarbManipulationArray3[0] = cbm;
            collectiveBarbManipulationArray = collectiveBarbManipulationArray3;
            collectiveBarbManipulationArray3[1] = cbm2;
        }
        CollectiveBarbManipulation[] cbms = collectiveBarbManipulationArray;
        DisplayRendererJ3D dr = (DisplayRendererJ3D)display1.getDisplayRenderer();
        CBMKeyboardBehaviorJ3D kbd = new CBMKeyboardBehaviorJ3D(dr);
        dr.addKeyboardBehavior(kbd);
        kbd.setWhichCBM(cbm);
        Gridded2DSet set1 = new Gridded2DSet((MathType)earth, (float[][])new float[][]{{0.0f}, {0.0f}}, 1);
        SampledSet[] sets = new Gridded2DSet[]{set1};
        UnionSet set = new UnionSet((MathType)earth, sets);
        final DataReferenceImpl set_ref = new DataReferenceImpl("set_ref");
        set_ref.setData(set);
        int mask = 3;
        final CurveManipulationRendererJ3D cmr = new CurveManipulationRendererJ3D(mask, mask, true);
        display1.addReferences((DataRenderer)cmr, set_ref);
        RealTuple rt = new RealTuple(earth, new double[]{Double.NaN, Double.NaN});
        final DataReferenceImpl point_ref = new DataReferenceImpl("point_ref");
        point_ref.setData(rt);
        final PointManipulationRendererJ3D pmr = new PointManipulationRendererJ3D(lat, lon, mask, mask);
        display1.addReferences((DataRenderer)pmr, point_ref);
        pmr.toggle(false);
        JFrame frame = new JFrame("test CollectiveBarbManipulation");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JPanel display_panel = new JPanel();
        display_panel.setLayout(new BoxLayout(display_panel, 1));
        JPanel panel1 = (JPanel)display1.getComponent();
        JPanel panel2 = (JPanel)display2.getComponent();
        CompoundBorder etchedBorder5 = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));
        panel1.setBorder(etchedBorder5);
        panel2.setBorder(etchedBorder5);
        display_panel.add(panel1);
        display_panel.add(panel2);
        display_panel.setMaximumSize(new Dimension(400, 800));
        JPanel widget_panel = new JPanel();
        widget_panel.setLayout(new BoxLayout(widget_panel, 1));
        widget_panel.add(new AnimationWidget(amap));
        final DataReferenceImpl station_select_ref = new DataReferenceImpl("station_select_ref");
        VisADSlider station_select_slider = new VisADSlider("station", 0, 24, 0, 1.0, station_select_ref, RealType.Generic);
        widget_panel.add(station_select_slider);
        CellImpl cell = new CellImpl(){

            public void doAction() throws VisADException, RemoteException {
                int sta = (int)((Real)station_select_ref.getData()).getValue();
                if (0 <= sta && sta < 25) {
                    cbm.setStation(sta);
                }
                if (0 <= sta && sta < 25 && cbm2 != null) {
                    cbm2.setStation(sta);
                }
            }
        };
        cell.addReference(station_select_ref);
        CellImpl cell2 = new CellImpl(){

            public void doAction() throws VisADException, RemoteException {
                float[][] samples;
                UnionSet cset = (UnionSet)set_ref.getData();
                SampledSet[] csets = cset.getSets();
                if (csets.length > 0 && (samples = csets[csets.length - 1].getSamples()) != null && samples[0].length > 2) {
                    cbm.setCollectiveCurve(false, set_ref, 0.0f, 1000.0f);
                    if (cbm2 != null) {
                        cbm2.setCollectiveCurve(false, set_ref, 0.0f, 1000.0f);
                    }
                }
            }
        };
        cell2.addReference(set_ref);
        final JButton add = new JButton("add");
        CellImpl cell3 = new CellImpl(){

            public void doAction() throws VisADException, RemoteException {
                RealTuple rt3 = (RealTuple)point_ref.getData();
                float lat3 = (float)((Real)rt3.getComponent(0)).getValue();
                float lon3 = (float)((Real)rt3.getComponent(1)).getValue();
                if (lat3 == lat3 && lon3 == lon3) {
                    cbm.addStation(lat3, lon3);
                    cmr.toggle(true);
                    pmr.toggle(false);
                    add.setText("add");
                }
            }
        };
        cell3.addReference(point_ref);
        JPanel button_panel = new JPanel();
        button_panel.setLayout(new BoxLayout(button_panel, 0));
        button_panel.setAlignmentY(0.0f);
        button_panel.setAlignmentX(0.0f);
        EndManipCBM emc = new EndManipCBM(cbm, cbm2, set_ref, add, cmr, pmr);
        JButton end = new JButton("end manip");
        end.addActionListener(emc);
        end.setActionCommand("end");
        button_panel.add(end);
        JButton del = new JButton("delete curve");
        del.addActionListener(emc);
        del.setActionCommand("del");
        button_panel.add(del);
        add.addActionListener(emc);
        add.setActionCommand("add");
        button_panel.add(add);
        JButton dir = new JButton("time dir");
        dir.addActionListener(emc);
        dir.setActionCommand("dir");
        button_panel.add(dir);
        widget_panel.add(button_panel);
        widget_panel.setMaximumSize(new Dimension(400, 800));
        panel.add(display_panel);
        panel.add(widget_panel);
        frame.getContentPane().add(panel);
        frame.setSize(800, 800);
        frame.setVisible(true);
    }

    class CSwellManipulationRendererJ3D
    extends SwellManipulationRendererJ3D {
        CollectiveBarbManipulation cbm;
        int index;

        CSwellManipulationRendererJ3D(CollectiveBarbManipulation c, int i) {
            this.cbm = c;
            this.index = i;
        }

        public void release_direct() {
            this.cbm.release();
        }

        public void drag_direct(VisADRay ray, boolean first, int mouseModifiers) {
            if (first) {
                this.cbm.circleEnable();
                CollectiveBarbManipulation.this.current_index = this.index;
            }
            super.drag_direct(ray, first, mouseModifiers);
        }
    }

    class CBarbManipulationRendererJ3D
    extends BarbManipulationRendererJ3D {
        CollectiveBarbManipulation cbm;
        int index;

        CBarbManipulationRendererJ3D(CollectiveBarbManipulation c, int i) {
            this.cbm = c;
            this.index = i;
        }

        public void release_direct() {
            this.cbm.release();
        }

        public void drag_direct(VisADRay ray, boolean first, int mouseModifiers) {
            if (first) {
                this.cbm.circleEnable();
                CollectiveBarbManipulation.this.current_index = this.index;
            }
            super.drag_direct(ray, first, mouseModifiers);
        }
    }

    class BarbMonitor2
    extends CellImpl {
        DataReferenceImpl ref;
        int time_index;

        public BarbMonitor2(DataReferenceImpl r, int index) {
            this.ref = r;
            this.time_index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doAction() throws VisADException, RemoteException {
            Object object = CollectiveBarbManipulation.this.data_lock;
            synchronized (object) {
                int sta_index = CollectiveBarbManipulation.this.station;
                if (sta_index < 0) {
                    return;
                }
                CollectiveBarbManipulation.this.collectiveAdjust(sta_index, this.time_index, this.ref, 2);
            }
        }
    }

    class BarbMonitor
    extends CellImpl {
        DataReferenceImpl ref;
        int sta_index;

        public BarbMonitor(DataReferenceImpl r, int index) {
            this.ref = r;
            this.sta_index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doAction() throws VisADException, RemoteException {
            Object object = CollectiveBarbManipulation.this.data_lock;
            synchronized (object) {
                int time_index = CollectiveBarbManipulation.this.which_times[this.sta_index];
                if (time_index < 0) {
                    return;
                }
                CollectiveBarbManipulation.this.collectiveAdjust(this.sta_index, time_index, this.ref, 1);
            }
        }
    }

    class Releaser
    extends CellImpl {
        Releaser() {
        }

        public void doAction() throws VisADException, RemoteException {
            for (int io = 0; io < 2; ++io) {
                if (CollectiveBarbManipulation.this.circle_ref[io] == null) continue;
                CollectiveBarbManipulation.this.circle_renderer[io].toggle(false);
                CollectiveBarbManipulation.this.circle_ref[io].setData(null);
            }
        }
    }

    class WindMonitor
    extends CellImpl {
        WindMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doAction() throws VisADException, RemoteException {
            Object object = CollectiveBarbManipulation.this.data_lock;
            synchronized (object) {
                if (CollectiveBarbManipulation.this.nindex != CollectiveBarbManipulation.this.wind_field.getLength()) {
                    throw new CollectiveBarbException("number of stations changed");
                }
                for (int i = 0; i < CollectiveBarbManipulation.this.nindex; ++i) {
                    FlatField ff = (FlatField)CollectiveBarbManipulation.this.wind_field.getSample(i);
                    if (CollectiveBarbManipulation.this.ntimes[i] != ff.getLength()) {
                        throw new CollectiveBarbException("number of times changed");
                    }
                    Enumeration e = ff.domainEnumeration();
                    for (int j = 0; j < CollectiveBarbManipulation.this.ntimes[i]; ++j) {
                        Tuple tuple = (Tuple)ff.getSample(j);
                        Real[] reals = tuple.getRealComponents();
                        float new_azimuth = (float)reals[CollectiveBarbManipulation.this.azimuth_index].getValue();
                        float new_radial = (float)reals[CollectiveBarbManipulation.this.radial_index].getValue();
                        if (Util.isApproximatelyEqual(new_azimuth, CollectiveBarbManipulation.this.azimuths[i][j], 0.1f) && Util.isApproximatelyEqual(new_radial, CollectiveBarbManipulation.this.radials[i][j], 0.01f)) continue;
                        ((CollectiveBarbManipulation)CollectiveBarbManipulation.this).azimuths[i][j] = new_azimuth;
                        ((CollectiveBarbManipulation)CollectiveBarbManipulation.this).radials[i][j] = new_radial;
                        ((CollectiveBarbManipulation)CollectiveBarbManipulation.this).tuples[i][j] = tuple;
                        if (CollectiveBarbManipulation.this.station_refs != null && j == CollectiveBarbManipulation.this.which_times[i]) {
                            CollectiveBarbManipulation.this.station_refs[i].setData(CollectiveBarbManipulation.this.tuples[i][j]);
                        }
                        int n = tuple.getDimension();
                        Data[] components = new Data[n + 1];
                        for (int k = 0; k < n; ++k) {
                            components[k] = tuple.getComponent(k);
                        }
                        components[n] = ((RealTuple)e.nextElement()).getComponent(0);
                        ((CollectiveBarbManipulation)CollectiveBarbManipulation.this).tuples2[i][j] = new Tuple(components);
                        if (CollectiveBarbManipulation.this.time_refs == null || i != CollectiveBarbManipulation.this.station) continue;
                        CollectiveBarbManipulation.this.time_refs[j].setData(CollectiveBarbManipulation.this.tuples2[i][j]);
                    }
                }
            }
        }
    }

    class Stepper
    extends CellImpl {
        int old_current = -1;

        Stepper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doAction() throws VisADException, RemoteException {
            if (CollectiveBarbManipulation.this.afirst || CollectiveBarbManipulation.this.acontrol == null) {
                return;
            }
            Object object = CollectiveBarbManipulation.this.data_lock;
            synchronized (object) {
                int i;
                CollectiveBarbManipulation.this.which_time = -1;
                int current = CollectiveBarbManipulation.this.acontrol.getCurrent();
                if (current < 0) {
                    return;
                }
                CollectiveBarbManipulation.this.which_time = current;
                if (current != this.old_current) {
                    if (CollectiveBarbManipulation.this.barb_manipulation_renderers == null) {
                        return;
                    }
                    for (i = 0; i < CollectiveBarbManipulation.this.nindex; ++i) {
                        ((CollectiveBarbManipulation)CollectiveBarbManipulation.this).which_times[i] = -1;
                        if (CollectiveBarbManipulation.this.barb_manipulation_renderers[i] == null) continue;
                        CollectiveBarbManipulation.this.barb_manipulation_renderers[i].stop_direct();
                    }
                }
                if (current != this.old_current) {
                    for (i = 0; i < CollectiveBarbManipulation.this.nindex; ++i) {
                        int index = CollectiveBarbManipulation.this.global_to_station[i][current];
                        if (index >= CollectiveBarbManipulation.this.tuples[i].length || CollectiveBarbManipulation.this.station_refs[i] == null) continue;
                        CollectiveBarbManipulation.this.station_refs[i].setData(CollectiveBarbManipulation.this.tuples[i][index]);
                        ((CollectiveBarbManipulation)CollectiveBarbManipulation.this).which_times[i] = index;
                    }
                }
                this.old_current = current;
                if (CollectiveBarbManipulation.this.afirst_real) {
                    CollectiveBarbManipulation.this.afirst_real = false;
                    CollectiveBarbManipulation.this.display1.removeReference(CollectiveBarbManipulation.this.stations_ref);
                }
            }
        }
    }

    class AnimationControlListener
    implements ControlListener {
        AnimationControlListener() {
        }

        public void controlChanged(ControlEvent e) throws VisADException, RemoteException {
            if (CollectiveBarbManipulation.this.afirst) {
                CollectiveBarbManipulation.this.afirst = false;
            }
            if (CollectiveBarbManipulation.this.stepper_ref != null) {
                CollectiveBarbManipulation.this.stepper_ref.setData(null);
            }
        }
    }
}

