/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdm;

import dap4.cdm.CDMTypeFcns;
import dap4.core.data.DataCursor;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapType;
import dap4.core.dmr.TypeSort;
import dap4.core.util.DapException;
import dap4.core.util.Index;
import dap4.core.util.Slice;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.CDMNode;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;

public abstract class CDMUtil {
    static final String hexchars = "0123456789abcdef";

    public static List<Slice> createSlices(List<Range> rangelist) throws DapException {
        ArrayList<Slice> slices = new ArrayList<Slice>(rangelist.size());
        for (int i = 0; i < rangelist.size(); ++i) {
            Range r = rangelist.get(i);
            int stride = r.stride();
            int first = r.first();
            int n = r.length();
            int stop = first + n * stride;
            Slice cer = new Slice(first, stop - 1, stride);
            slices.add(cer);
        }
        return slices;
    }

    public static boolean isWhole(List<Range> rangelist, List<DapDimension> dimset, int start, int stop) throws DapException {
        int rsize;
        int n = rsize = rangelist == null ? 0 : rangelist.size();
        if (rsize != dimset.size()) {
            throw new DapException("range/dimset rank mismatch");
        }
        if (rsize == 0) {
            return true;
        }
        if (start < 0 || stop < start || stop > rsize) {
            throw new DapException("Invalid start/stop indices");
        }
        for (int i = start; i < stop; ++i) {
            Range r = rangelist.get(i);
            DapDimension d = dimset.get(i);
            if (r.stride() == 1 && r.first() == 0 && (long)r.length() == d.getSize()) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhole(List<Range> rangelist, List<Slice> slices) throws DapException {
        if (rangelist.size() != slices.size()) {
            return false;
        }
        for (int i = 0; i < rangelist.size(); ++i) {
            Range r = rangelist.get(i);
            Slice slice = slices.get(i);
            if (r.stride() == 1 && r.first() == 0 && (long)r.length() == slice.getCount()) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhole(List<Range> rangelist, Variable var) throws DapException {
        List<Dimension> dimset = var.getDimensions();
        if (rangelist.size() != dimset.size()) {
            return false;
        }
        for (int i = 0; i < rangelist.size(); ++i) {
            Range r = rangelist.get(i);
            Dimension dim = dimset.get(i);
            if (r.stride() == 1 && r.first() == 0 && r.length() == dim.getLength()) continue;
            return false;
        }
        return true;
    }

    public static List<Range> createCDMRanges(List<Slice> slices) throws DapException {
        ArrayList<Range> cdmranges = new ArrayList<Range>();
        for (int i = 0; i < slices.size(); ++i) {
            Slice r = slices.get(i);
            try {
                Range cmdr = new Range((int)r.getFirst(), (int)r.getLast(), (int)r.getStride());
                cdmranges.add(cmdr);
                continue;
            }
            catch (InvalidRangeException ire) {
                throw new DapException(ire);
            }
        }
        return cdmranges;
    }

    public static Variable unwrap(Variable var) {
        return (Variable)CDMNode.unwrap(var);
    }

    public static NetcdfFile unwrapfile(NetcdfFile file) {
        NetcdfDataset ds;
        while (file instanceof NetcdfDataset && (file = (ds = (NetcdfDataset)file).getReferencedFile()) != null) {
        }
        return file;
    }

    public static boolean hasVLEN(List<Range> ranges) {
        if (ranges == null || ranges.size() == 0) {
            return false;
        }
        return ranges.get(ranges.size() - 1) == Range.VLEN;
    }

    public static boolean hasVLEN(Variable v) {
        return CDMUtil.containsVLEN(v.getDimensions());
    }

    public static boolean containsVLEN(List<Dimension> dimset) {
        if (dimset == null) {
            return false;
        }
        for (Dimension dim : dimset) {
            if (!dim.isVariableLength()) continue;
            return true;
        }
        return false;
    }

    public static int[] computeEffectiveShape(List<DapDimension> dimset) {
        if (dimset == null || dimset.size() == 0) {
            return new int[0];
        }
        int effectiverank = dimset.size();
        int[] shape = new int[effectiverank];
        for (int i = 0; i < effectiverank; ++i) {
            shape[i] = (int)dimset.get(i).getSize();
        }
        return shape;
    }

    public static long extractLongValue(TypeSort atomtype, DataCursor dataset, Index index) throws DapException {
        Object result = dataset.read(index);
        long lvalue = CDMTypeFcns.extract(atomtype, result);
        return lvalue;
    }

    public static double extractDoubleValue(TypeSort atomtype, DataCursor dataset, Index index) throws DapException {
        Object result = dataset.read(index);
        double dvalue = 0.0;
        if (atomtype.isIntegerType() || atomtype.isEnumType()) {
            long lvalue = CDMUtil.extractLongValue(atomtype, dataset, index);
            dvalue = lvalue;
        } else if (atomtype == TypeSort.Float32) {
            dvalue = ((Float)result).floatValue();
        } else if (atomtype == TypeSort.Float64) {
            dvalue = (Double)result;
        } else {
            throw new ForbiddenConversionException();
        }
        return dvalue;
    }

    public static Object convertVector(DapType dsttype, DapType srctype, Object src) {
        TypeSort dstatomtype;
        TypeSort srcatomtype = srctype.getAtomicType();
        if (srcatomtype == (dstatomtype = dsttype.getAtomicType())) {
            return src;
        }
        if (srcatomtype.isIntegerType() && TypeSort.getSignedVersion(srcatomtype) == TypeSort.getSignedVersion(dstatomtype)) {
            return src;
        }
        Object result = CDMTypeFcns.convert(dstatomtype, srcatomtype, src);
        if (result == null) {
            throw new ForbiddenConversionException();
        }
        return result;
    }

    public static String getChecksumString(byte[] checksum) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < checksum.length; ++i) {
            byte b = checksum[i];
            buf.append(hexchars.charAt(b >> 4));
            buf.append(hexchars.charAt(b & 0xF));
        }
        return buf.toString();
    }

    public static List<Range> dimsetToRanges(List<DapDimension> dimset) throws DapException {
        if (dimset == null) {
            return null;
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (int i = 0; i < dimset.size(); ++i) {
            DapDimension dim = dimset.get(i);
            try {
                Range r = new Range(dim.getShortName(), 0, (int)dim.getSize() - 1, 1);
                ranges.add(r);
                continue;
            }
            catch (InvalidRangeException ire) {
                throw new DapException(ire);
            }
        }
        return ranges;
    }

    public static List<Slice> shapeToSlices(int[] shape) throws DapException {
        if (shape == null) {
            return null;
        }
        ArrayList<Slice> slices = new ArrayList<Slice>(shape.length);
        for (int i = 0; i < shape.length; ++i) {
            Slice sl = new Slice(0L, shape[i] - 1, 1L);
            slices.add(sl);
        }
        return slices;
    }

    public static Index cdmIndexToIndex(ucar.ma2.Index cdmidx) {
        int rank = cdmidx.getRank();
        int[] shape = cdmidx.getShape();
        long[] indices = new long[shape.length];
        for (int i = 0; i < rank; ++i) {
            indices[i] = shape[i];
        }
        Index dapidx = new Index(indices, indices);
        return dapidx;
    }

    public static ucar.ma2.Index indexToCcMIndex(Index d4) {
        int rank = d4.getRank();
        int[] shape = new int[rank];
        int[] indices = new int[rank];
        for (int i = 0; i < rank; ++i) {
            indices[i] = (int)d4.get(i);
            shape[i] = (int)d4.getSize(i);
        }
        ucar.ma2.Index cdm = ucar.ma2.Index.factory(shape);
        cdm.set(indices);
        return cdm;
    }
}

