/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdm.dsp;

import dap4.cdm.CDMTypeFcns;
import dap4.cdm.CDMUtil;
import dap4.cdm.dsp.CDMDSP;
import dap4.core.data.DataCursor;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Index;
import dap4.core.util.Odometer;
import dap4.core.util.Slice;
import dap4.dap4lib.AbstractCursor;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;

public class CDMCursor
extends AbstractCursor {
    protected Array array = null;
    protected StructureData structdata = null;
    StructureMembers.Member member = null;

    public CDMCursor(DataCursor.Scheme scheme, CDMDSP dsp, DapNode template, CDMCursor container) throws DapException {
        super(scheme, dsp, template, container);
    }

    public CDMCursor(CDMCursor c) {
        super(c);
        assert (false);
        this.array = c.array;
        this.structdata = c.structdata;
        this.member = c.member;
    }

    @Override
    public Object read(List<Slice> slices) throws DapException {
        switch (this.scheme) {
            case ATOMIC: {
                return this.readAtomic(slices);
            }
            case STRUCTURE: {
                if (((DapVariable)this.getTemplate()).getRank() > 0 || DapUtil.isScalarSlices(slices)) {
                    throw new DapException("Cannot slice a scalar variable");
                }
                CDMCursor[] instances = new CDMCursor[]{this};
                return instances;
            }
            case SEQUENCE: {
                if (((DapVariable)this.getTemplate()).getRank() > 0 || DapUtil.isScalarSlices(slices)) {
                    throw new DapException("Cannot slice a scalar variable");
                }
                CDMCursor[] instances = new CDMCursor[]{this};
                return instances;
            }
            case STRUCTARRAY: {
                Odometer odom = Odometer.factory(slices);
                CDMCursor[] instances = new CDMCursor[(int)odom.totalSize()];
                int i = 0;
                while (odom.hasNext()) {
                    instances[i] = this.readStructure(odom.next());
                    ++i;
                }
                return instances;
            }
            case SEQARRAY: {
                CDMCursor[] instances = this.readSequence(slices);
                return instances;
            }
        }
        throw new DapException("Attempt to slice a scalar object");
    }

    @Override
    public Object read(Index index) throws DapException {
        return this.read(DapUtil.indexToSlices(index));
    }

    @Override
    public CDMCursor readField(int findex) throws DapException {
        if (this.scheme != DataCursor.Scheme.RECORD) {
            if (this.scheme != DataCursor.Scheme.STRUCTURE) {
                throw new DapException("Illegal cursor scheme for readfield()");
            }
        }
        DapVariable var = (DapVariable)this.getTemplate();
        DapStructure basetype = (DapStructure)var.getBaseType();
        if (findex < 0 || findex >= basetype.getFields().size()) {
            throw new DapException("Field index out of range: " + findex);
        }
        CDMCursor fieldcursor = null;
        if (this.scheme == DataCursor.Scheme.RECORD) {
            DapSequence seq = (DapSequence)basetype;
            DapVariable field = seq.getField(0);
            DapType fieldtype = field.getBaseType();
            switch (fieldtype.getTypeSort()) {
                default: {
                    DataType cdmfieldtype = CDMTypeFcns.daptype2cdmtype(fieldtype);
                    if (cdmfieldtype == null) {
                        throw new DapException("Unknown field type: " + fieldtype);
                    }
                    int ri = (int)this.recordindex;
                    Object o = this.array.getObject(ri);
                    Array fielddata = CDMTypeFcns.arrayify(cdmfieldtype, o);
                    fieldcursor = new CDMCursor(DataCursor.Scheme.ATOMIC, (CDMDSP)this.dsp, (DapNode)field, this);
                    fieldcursor.setArray(fielddata);
                }
                case Sequence: 
                case Structure: 
            }
        } else {
            assert (this.structdata != null);
            fieldcursor = this.getFieldCursor(this, findex);
        }
        return fieldcursor;
    }

    protected CDMCursor getFieldCursor(CDMCursor container, int findex) throws DapException {
        DapVariable var = (DapVariable)this.getTemplate();
        DapStructure type = (DapStructure)var.getBaseType();
        DapVariable field = type.getFields().get(findex);
        DapType ftype = field.getBaseType();
        DataCursor.Scheme scheme = CDMCursor.schemeFor(field);
        CDMCursor fc = new CDMCursor(scheme, (CDMDSP)this.dsp, (DapNode)field, this);
        StructureMembers.Member member = this.structdata.getStructureMembers().getMember(findex);
        fc.setMember(member);
        fc.setArray(this.structdata.getArray(fc.member));
        return fc;
    }

    @Override
    public CDMCursor readRecord(long i) throws DapException {
        if (this.scheme != DataCursor.Scheme.SEQUENCE) {
            throw new DapException("Attempt to read record from non-sequence cursor");
        }
        if (i < 0L || i >= this.recordcount) {
            throw new DapException("Record index out of bounds");
        }
        DapVariable var = (DapVariable)this.getTemplate();
        CDMCursor c = new CDMCursor(DataCursor.Scheme.RECORD, (CDMDSP)this.dsp, (DapNode)var, this);
        c.setArray(this.array);
        c.setRecordIndex(i);
        return c;
    }

    protected Object readAtomic(List<Slice> slices) throws DapException {
        if (slices == null) {
            throw new DapException("DataCursor.read: null set of slices");
        }
        assert (this.scheme == DataCursor.Scheme.ATOMIC);
        DapVariable atomvar = (DapVariable)this.getTemplate();
        assert (slices != null && (atomvar.getRank() == 0 && slices.size() == 1 || slices.size() == atomvar.getRank()));
        return this.sliceAtomic(slices, this.array, atomvar);
    }

    protected Object sliceAtomic(List<Slice> slices, Array array, DapVariable var) throws DapException {
        List<DapDimension> dimset = var.getDimensions();
        DapType basetype = var.getBaseType();
        DataType datatype = CDMTypeFcns.daptype2cdmtype(basetype);
        if (datatype == null) {
            throw new DapException("Unknown basetype: " + basetype);
        }
        Object content = array.get1DJavaArray(datatype);
        Odometer odom = Odometer.factory(slices, dimset);
        Object data = CDMTypeFcns.createVector(datatype, odom.totalSize());
        int dstoffset = 0;
        while (odom.hasNext()) {
            Index index = odom.next();
            long srcoffset = index.index();
            CDMTypeFcns.vectorcopy(basetype, content, data, srcoffset, dstoffset);
            ++dstoffset;
        }
        return data;
    }

    protected CDMCursor readStructure(Index index) throws DapException {
        assert (index != null);
        DapVariable var = (DapVariable)this.getTemplate();
        DapStructure type = (DapStructure)var.getBaseType();
        long pos = index.index();
        if (pos < 0L || pos > var.getCount()) {
            throw new IndexOutOfBoundsException("read: " + index);
        }
        ArrayStructure sarray = (ArrayStructure)this.array;
        assert (this.scheme == DataCursor.Scheme.STRUCTARRAY);
        StructureData sd = sarray.getStructureData((int)pos);
        assert (sd != null);
        CDMCursor instance = new CDMCursor(DataCursor.Scheme.STRUCTURE, (CDMDSP)this.dsp, (DapNode)var, null).setStructureData(sd);
        instance.setIndex(index);
        return instance;
    }

    protected CDMCursor[] readSequence(List<Slice> slices) throws DapException {
        assert (this.scheme == DataCursor.Scheme.SEQARRAY);
        DapVariable var = (DapVariable)this.getTemplate();
        DapSequence type = (DapSequence)var.getBaseType();
        CDMCursor[] instances = new CDMCursor[(int)DapUtil.sliceProduct(slices)];
        Array seqarray = this.array;
        if (var.getRank() == 0) {
            if (!DapUtil.isScalarSlices(slices)) {
                throw new DapException("Non-scalar slice set applied to scalar variable");
            }
            instances[0] = new CDMCursor(DataCursor.Scheme.SEQUENCE, (CDMDSP)this.dsp, (DapNode)var, this);
            instances[0].setArray(seqarray);
            instances[0].setRecordCount(seqarray.getSize());
        } else {
            Array instancearray;
            List<Range> rlist = CDMUtil.createCDMRanges(slices);
            try {
                instancearray = seqarray.section(rlist);
            }
            catch (InvalidRangeException e) {
                throw new DapException("Illegal slice set", e);
            }
            int slicecount = (int)DapUtil.sliceProduct(slices);
            for (int i = 0; i < slicecount; ++i) {
                Array ao = (Array)instancearray.getObject(i);
                CDMCursor c = new CDMCursor(DataCursor.Scheme.SEQUENCE, (CDMDSP)this.dsp, (DapNode)var, this);
                c.setArray(ao);
                long rcount = ao.getSize();
                c.setRecordCount(rcount);
                instances[i] = c;
            }
        }
        return instances;
    }

    public CDMCursor setArray(Array a) {
        this.array = a;
        return this;
    }

    public Array getArray() {
        return this.array;
    }

    public CDMCursor setStructureData(StructureData sd) {
        this.structdata = sd;
        return this;
    }

    public CDMCursor setMember(StructureMembers.Member m3) {
        this.member = m3;
        return this;
    }
}

