/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdm.nc2;

import dap4.cdm.CDMTypeFcns;
import dap4.cdm.nc2.CDMArray;
import dap4.cdm.nc2.CDMArrayAtomic;
import dap4.cdm.nc2.CDMArrayStructure;
import dap4.core.data.DSP;
import dap4.core.data.DataCursor;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Index;
import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataA;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Group;

class CDMArraySequence
extends ArraySequence
implements CDMArray {
    protected Group cdmroot = null;
    protected DSP dsp;
    protected DapVariable template;
    protected DapType basetype;
    protected long bytesize = 0L;
    protected long recordcount = 0L;
    protected int nmembers = 0;
    protected DataCursor seqdata = null;
    protected FieldSet[] records = null;

    CDMArraySequence(Group group, DataCursor data) throws DapException {
        super(CDMArrayStructure.computemembers((DapVariable)data.getTemplate()), new SDI(), 0);
        this.template = (DapVariable)data.getTemplate();
        this.basetype = this.template.getBaseType();
        if (this.template.getRank() != 0) {
            throw new DapException("Non-scalar sequences unsupported through CDM interface");
        }
        assert (data.getScheme() == DataCursor.Scheme.SEQARRAY);
        this.cdmroot = group;
        this.dsp = this.dsp;
        this.seqdata = ((DataCursor[])data.read(Index.SCALAR))[0];
        this.recordcount = this.seqdata.getRecordCount();
        this.nmembers = ((DapStructure)this.basetype).getFields().size();
        this.sdata = new StructureDataA[(int)this.recordcount];
        this.records = new FieldSet[(int)this.recordcount];
        int i = 0;
        while ((long)i < this.recordcount) {
            this.sdata[i] = new StructureDataA(this, i);
            this.records[i] = new FieldSet(this.nmembers);
            ++i;
        }
        ((SDI)this.iter).setList(this.sdata);
    }

    void add(long recno, int fieldno, Array field) {
        FieldSet fs;
        if ((long)this.records.length <= recno) {
            FieldSet[] newrecs = new FieldSet[(int)recno + 1];
            System.arraycopy(this.records, 0, newrecs, 0, this.records.length);
            this.records = newrecs;
        }
        if ((fs = this.records[(int)recno]) == null) {
            this.records[(int)recno] = fs = new FieldSet(this.nmembers);
        }
        fs.fields[fieldno] = field;
    }

    @Override
    public DapType getBaseType() {
        return this.basetype;
    }

    @Override
    public DSP getDSP() {
        return this.dsp;
    }

    @Override
    public DapVariable getTemplate() {
        return this.template;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        DapVariable var = this.template;
        DapSequence seq = (DapSequence)this.basetype;
        long dimsize = DapUtil.dimProduct(var.getDimensions());
        int i = 0;
        while ((long)i < dimsize) {
            List<DapVariable> fields = seq.getFields();
            if ((long)i < dimsize - 1L) {
                buf.append("\n");
            }
            buf.append("Sequence {\n");
            buf.append(String.format("} [%d/%d]", i, dimsize));
            ++i;
        }
        return buf.toString();
    }

    @Override
    public int getStructureDataCount() {
        return this.records.length;
    }

    @Override
    protected StructureData makeStructureData(ArrayStructure as, int index) {
        throw new UnsupportedOperationException("Cannot subset a Sequence");
    }

    @Override
    public StructureData getStructureData(int index) {
        assert (this.sdata != null);
        if (index < 0 || index >= this.records.length) {
            throw new IllegalArgumentException(index + " >= " + this.sdata.length);
        }
        assert (this.sdata[index] != null);
        return this.sdata[index];
    }

    public ArraySequence getArraySequence(StructureMembers.Member m3) {
        return this;
    }

    @Override
    public Array copy() {
        return this;
    }

    @Override
    public Array getArray(int recno, StructureMembers.Member m3) {
        return this.memberArray(recno, CDMArrayStructure.memberIndex(m3));
    }

    protected CDMArrayAtomic getAtomicArray(int index, StructureMembers.Member m3) {
        Array dd = this.memberArray(index, CDMArrayStructure.memberIndex(m3));
        if (dd.getDataType() != DataType.STRUCTURE && dd.getDataType() != DataType.SEQUENCE) {
            return (CDMArrayAtomic)dd;
        }
        throw new ForbiddenConversionException("Cannot convert structure to AtomicArray");
    }

    protected Array memberArray(int recno, int memberindex) {
        Object[] values = new Object[(int)this.recordcount];
        int i = 0;
        while ((long)i < this.recordcount) {
            FieldSet fs = this.records[i];
            values[i] = fs.fields[memberindex];
            ++i;
        }
        DapVariable field = ((DapStructure)this.basetype).getField(memberindex);
        DapType base = field.getBaseType();
        if (base == null) {
            throw new IllegalStateException("Unknown field type: " + field);
        }
        DataType dt = CDMTypeFcns.daptype2cdmtype(base);
        Class elemtype = CDMTypeFcns.cdmElementClass(dt);
        int[] shape = new int[]{(int)this.recordcount};
        return new ArrayObject(dt, elemtype, false, shape, values);
    }

    public static class SDI
    implements StructureDataIterator {
        protected StructureData[] list = null;
        protected int position = 0;

        public SDI setList(StructureData[] list) {
            this.list = list;
            return this;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.position < this.list.length;
        }

        @Override
        public StructureData next() throws IOException {
            if (this.position >= this.list.length) {
                throw new IOException("No next element");
            }
            return this.list[this.position++];
        }

        @Override
        public StructureDataIterator reset() {
            this.position = 0;
            return this;
        }

        @Override
        public int getCurrentRecno() {
            return this.position;
        }
    }

    protected static class FieldSet {
        public Array[] fields;

        FieldSet(int nfields) {
            this.fields = new Array[nfields];
        }
    }
}

