/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdm.nc2;

import dap4.cdm.CDMTypeFcns;
import dap4.cdm.CDMUtil;
import dap4.cdm.nc2.CDMArray;
import dap4.cdm.nc2.CDMArrayAtomic;
import dap4.core.data.DSP;
import dap4.core.data.DataCursor;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Slice;
import dap4.dap4lib.LibTypeFcns;
import java.nio.ByteBuffer;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataA;
import ucar.ma2.StructureMembers;
import ucar.nc2.Group;

class CDMArrayStructure
extends ArrayStructure
implements CDMArray {
    protected Group cdmroot = null;
    protected DSP dsp = null;
    protected DapVariable template = null;
    protected DapType basetype = null;
    protected long dimsize = 0L;
    protected int nmembers = 0;
    protected DataCursor data = null;
    protected FieldArrays[] records = null;

    CDMArrayStructure(Group cdmroot, DataCursor data) {
        super(CDMArrayStructure.computemembers((DapVariable)data.getTemplate()), CDMUtil.computeEffectiveShape(((DapVariable)data.getTemplate()).getDimensions()));
        this.template = (DapVariable)data.getTemplate();
        assert (data.getScheme() == DataCursor.Scheme.STRUCTARRAY);
        this.dsp = data.getDSP();
        this.cdmroot = cdmroot;
        this.basetype = this.template.getBaseType();
        this.dimsize = DapUtil.dimProduct(this.template.getDimensions());
        this.nmembers = ((DapStructure)this.template.getBaseType()).getFields().size();
        this.data = data;
        this.sdata = new StructureDataA[(int)this.dimsize];
        this.records = new FieldArrays[(int)this.dimsize];
        int i = 0;
        while ((long)i < this.dimsize) {
            this.sdata[i] = new StructureDataA(this, i);
            this.records[i] = new FieldArrays(this.nmembers);
            ++i;
        }
    }

    void add(long recno, int fieldno, Array field) {
        FieldArrays fs = this.records[(int)recno];
        if (fs == null) {
            this.records[(int)recno] = fs = new FieldArrays(this.nmembers);
        }
        fs.fields[fieldno] = field;
    }

    @Override
    public DSP getDSP() {
        return this.dsp;
    }

    @Override
    public DapVariable getTemplate() {
        return this.template;
    }

    @Override
    public DapType getBaseType() {
        return this.basetype;
    }

    @Override
    public long getSize() {
        return this.dimsize;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        DapVariable var = this.template;
        DapStructure struct = (DapStructure)var.getBaseType();
        int i = 0;
        while ((long)i < this.dimsize) {
            List<DapVariable> fields = struct.getFields();
            if ((long)i < this.dimsize - 1L) {
                buf.append("\n");
            }
            buf.append("Structure {\n");
            if (fields != null) {
                for (int j = 0; j < this.nmembers; ++j) {
                    Array field = this.records[i].fields[j];
                    String sfield = field == null ? "null" : fields.toString();
                    buf.append(sfield + "\n");
                }
            }
            buf.append(String.format("} [%d/%d]", i, this.dimsize));
            ++i;
        }
        return buf.toString();
    }

    @Override
    public StructureData getStructureData(int index) {
        assert (this.sdata != null);
        if (index < 0 || (long)index >= this.dimsize) {
            throw new IllegalArgumentException(index + " >= " + this.sdata.length);
        }
        assert (this.sdata[index] != null);
        return this.sdata[index];
    }

    @Override
    public double getScalarDouble(int index, StructureMembers.Member m3) {
        CDMArrayAtomic data = this.getAtomicArray(index, m3);
        return data.getDouble(0);
    }

    @Override
    public float getScalarFloat(int index, StructureMembers.Member m3) {
        CDMArrayAtomic data = this.getAtomicArray(index, m3);
        return data.getFloat(0);
    }

    @Override
    public byte getScalarByte(int index, StructureMembers.Member m3) {
        CDMArrayAtomic data = this.getAtomicArray(index, m3);
        return data.getByte(0);
    }

    @Override
    public short getScalarShort(int index, StructureMembers.Member m3) {
        CDMArrayAtomic data = this.getAtomicArray(index, m3);
        return data.getShort(0);
    }

    @Override
    public int getScalarInt(int index, StructureMembers.Member m3) {
        CDMArrayAtomic data = this.getAtomicArray(index, m3);
        return data.getInt(0);
    }

    @Override
    public long getScalarLong(int index, StructureMembers.Member m3) {
        CDMArrayAtomic data = this.getAtomicArray(index, m3);
        return data.getLong(0);
    }

    @Override
    public char getScalarChar(int index, StructureMembers.Member m3) {
        CDMArrayAtomic data = this.getAtomicArray(index, m3);
        return data.getChar(0);
    }

    @Override
    public String getScalarString(int recnum, StructureMembers.Member m3) {
        Array data = m3.getDataArray();
        return data.getObject(recnum).toString();
    }

    @Override
    public double[] getJavaArrayDouble(int recnum, StructureMembers.Member m3) {
        CDMArrayAtomic array = this.getAtomicArray(recnum, m3);
        if (!array.getBaseType().isNumericType()) {
            throw new IllegalArgumentException("Cannot convert non-numeric type");
        }
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m3.getShape());
            Object vector = this.data.read(slices);
            return (double[])LibTypeFcns.convertVector(DapType.FLOAT64, atomtype, vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    @Override
    public float[] getJavaArrayFloat(int index, StructureMembers.Member m3) {
        CDMArrayAtomic array = this.getAtomicArray(index, m3);
        if (!array.getBaseType().isNumericType()) {
            throw new IllegalArgumentException("Cannot convert non-numeric type");
        }
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m3.getShape());
            Object vector = this.data.read(slices);
            return (float[])LibTypeFcns.convertVector(DapType.FLOAT32, atomtype, vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    @Override
    public byte[] getJavaArrayByte(int index, StructureMembers.Member m3) {
        CDMArrayAtomic array = this.getAtomicArray(index, m3);
        if (!array.getBaseType().isNumericType()) {
            throw new IllegalArgumentException("Cannot convert non-numeric type");
        }
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m3.getShape());
            Object vector = this.data.read(slices);
            return (byte[])LibTypeFcns.convertVector(DapType.INT8, atomtype, vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    @Override
    public short[] getJavaArrayShort(int index, StructureMembers.Member m3) {
        CDMArrayAtomic array = this.getAtomicArray(index, m3);
        if (!array.getBaseType().isNumericType()) {
            throw new IllegalArgumentException("Cannot convert non-numeric type");
        }
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m3.getShape());
            Object vector = this.data.read(slices);
            return (short[])LibTypeFcns.convertVector(DapType.INT16, atomtype, vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    @Override
    public int[] getJavaArrayInt(int index, StructureMembers.Member m3) {
        CDMArrayAtomic array = this.getAtomicArray(index, m3);
        if (!array.getBaseType().isNumericType()) {
            throw new IllegalArgumentException("Cannot convert non-numeric type");
        }
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m3.getShape());
            Object vector = this.data.read(slices);
            return (int[])LibTypeFcns.convertVector(DapType.INT32, atomtype, vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    @Override
    public long[] getJavaArrayLong(int index, StructureMembers.Member m3) {
        CDMArrayAtomic array = this.getAtomicArray(index, m3);
        if (!array.getBaseType().isNumericType()) {
            throw new IllegalArgumentException("Cannot convert non-numeric type");
        }
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m3.getShape());
            Object vector = this.data.read(slices);
            return (long[])LibTypeFcns.convertVector(DapType.INT64, atomtype, vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    @Override
    public char[] getJavaArrayChar(int index, StructureMembers.Member m3) {
        CDMArrayAtomic array = this.getAtomicArray(index, m3);
        if (!array.getBaseType().isNumericType()) {
            throw new IllegalArgumentException("Cannot convert non-numeric type");
        }
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m3.getShape());
            Object vector = this.data.read(slices);
            return (char[])LibTypeFcns.convertVector(DapType.CHAR, atomtype, vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    @Override
    public String[] getJavaArrayString(int index, StructureMembers.Member m3) {
        CDMArrayAtomic array = this.getAtomicArray(index, m3);
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m3.getShape());
            Object vector = this.data.read(slices);
            return (String[])LibTypeFcns.convertVector(DapType.STRING, atomtype, vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public ByteBuffer[] getJavaArrayOpaque(int index, StructureMembers.Member m3) {
        CDMArrayAtomic array = this.getAtomicArray(index, m3);
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m3.getShape());
            Object vector = this.data.read(slices);
            return (ByteBuffer[])LibTypeFcns.convertVector(DapType.OPAQUE, atomtype, vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    @Override
    public StructureData getScalarStructure(int index, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.STRUCTURE) {
            throw new ForbiddenConversionException("Atomic field cannot be converted to Structure");
        }
        Array ca = this.memberArray(index, CDMArrayStructure.memberIndex(m3));
        if (ca.getDataType() != DataType.STRUCTURE && ca.getDataType() != DataType.SEQUENCE) {
            throw new ForbiddenConversionException("Attempt to access non-structure member");
        }
        CDMArrayStructure as = (CDMArrayStructure)ca;
        return as.getStructureData(0);
    }

    @Override
    public ArrayStructure getArrayStructure(int index, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.STRUCTURE) {
            throw new ForbiddenConversionException("Atomic field cannot be converted to Structure");
        }
        Array dd = this.memberArray(index, CDMArrayStructure.memberIndex(m3));
        if (dd.getDataType() != DataType.STRUCTURE && dd.getDataType() != DataType.SEQUENCE) {
            throw new ForbiddenConversionException("Attempt to access non-structure member");
        }
        return (CDMArrayStructure)dd;
    }

    public ArraySequence getArraySequence(StructureMembers.Member m3) {
        throw new UnsupportedOperationException("CDMArraySequence");
    }

    @Override
    public Array copy() {
        return this;
    }

    @Override
    public Array getArray(int recno, StructureMembers.Member m3) {
        return this.memberArray(recno, CDMArrayStructure.memberIndex(m3));
    }

    @Override
    protected StructureData makeStructureData(ArrayStructure as, int index) {
        if (this.sdata[index] == null) {
            this.sdata[index] = new StructureDataA(as, index);
        }
        return this.sdata[index];
    }

    static StructureMembers computemembers(DapVariable var) {
        DapStructure ds = (DapStructure)var.getBaseType();
        StructureMembers sm = new StructureMembers(ds.getShortName());
        List<DapVariable> fields = ds.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            DapVariable field = fields.get(i);
            DapType dt = field.getBaseType();
            DataType cdmtype = CDMTypeFcns.daptype2cdmtype(dt);
            StructureMembers.Member m3 = sm.addMember(field.getShortName(), "", null, cdmtype, CDMUtil.computeEffectiveShape(field.getDimensions()));
            m3.setDataParam(i);
            if (!dt.getTypeSort().isStructType()) continue;
            StructureMembers subsm = CDMArrayStructure.computemembers(field);
            m3.setStructureMembers(subsm);
        }
        return sm;
    }

    protected Array memberArray(int recno, int memberindex) {
        DapVariable var = this.getTemplate();
        DapStructure struct = (DapStructure)var.getBaseType();
        DapVariable field = struct.getField(memberindex);
        DapType base = field.getBaseType();
        if (base == null) {
            throw new IllegalStateException("Unknown field type: " + field);
        }
        Object[] values = new Object[(int)field.getCount()];
        FieldArrays fs = this.records[recno];
        Array fa = fs.fields[memberindex];
        return fa;
    }

    protected static int memberIndex(StructureMembers.Member m3) {
        return m3.getDataParam();
    }

    protected CDMArrayAtomic getAtomicArray(int index, StructureMembers.Member m3) {
        Array dd = this.memberArray(index, CDMArrayStructure.memberIndex(m3));
        if (dd.getDataType() != DataType.STRUCTURE && dd.getDataType() != DataType.SEQUENCE) {
            return (CDMArrayAtomic)dd;
        }
        throw new ForbiddenConversionException("Cannot convert structure to AtomicArray");
    }

    protected static class FieldArrays {
        public Array[] fields;

        FieldArrays(int nfields) {
            this.fields = new Array[nfields];
        }
    }
}

