/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib.netcdf;

import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.dap4lib.netcdf.Nc4DSP;

public abstract class Nc4Notes {
    public static final int NOGROUP = -1;
    public static final int NOID = -1;
    public static final int NOFIELDID = -1;

    static Notes factory(NoteSort ns, int g2, int id, Nc4DSP dsp) {
        Notes note = null;
        switch (ns) {
            case TYPE: {
                note = new TypeNotes(g2, id, dsp);
                break;
            }
            case VAR: {
                note = new VarNotes(g2, id, dsp);
                break;
            }
            case DIM: {
                note = new DimNotes(g2, id, dsp);
                break;
            }
            case GROUP: {
                note = new GroupNotes(g2, id, dsp);
            }
        }
        return note;
    }

    public static long getVarId(VarNotes note) {
        return Nc4Notes.getVarId(note.gid, note.id, note.getFieldIndex());
    }

    public static long getVarId(int gid, int varid, int ifid) {
        long gv = (long)gid << 32;
        assert (varid < 0x100000);
        gv |= (long)varid << 20;
        long fid = ifid;
        if (fid >= 0L) {
            gv |= fid;
        }
        return gv;
    }

    public static class VarNotes
    extends Notes {
        protected VarNotes(int g2, int v, Nc4DSP dsp) {
            super(NoteSort.VAR, g2, v, dsp);
        }

        @Override
        public VarNotes setBaseType(TypeNotes ti) {
            return (VarNotes)super.setBaseType(ti);
        }

        @Override
        public DapVariable get() {
            return (DapVariable)super.get();
        }

        @Override
        public VarNotes set(DapNode node) {
            return (VarNotes)super.set(node);
        }

        public int getFieldIndex() {
            assert (this.get() != null);
            return this.get().getFieldIndex();
        }

        @Override
        public long getSize() {
            return this.getBaseType().getSize() * DapUtil.dimProduct(this.get().getDimensions());
        }
    }

    public static class TypeNotes
    extends Notes {
        public int enumbase = -1;
        public boolean isvlen = false;

        protected TypeNotes(int g2, int id, Nc4DSP dsp) {
            super(NoteSort.TYPE, g2, id, dsp);
        }

        public DapType getType() {
            DapSort sort = this.node.getSort();
            switch (sort) {
                case ATOMICTYPE: 
                case STRUCTURE: 
                case SEQUENCE: {
                    return (DapType)super.get();
                }
                case ENUMERATION: {
                    return (DapEnumeration)super.get();
                }
                case VARIABLE: {
                    return ((DapVariable)super.get()).getBaseType();
                }
            }
            return null;
        }

        public TypeNotes setOpaque(long len) {
            super.setSize(len);
            return this;
        }

        public TypeNotes setEnumBaseType(int bt) {
            this.enumbase = bt;
            TypeNotes btt = (TypeNotes)this.dsp.find(bt, NoteSort.TYPE);
            this.setSize(btt.getSize());
            return this;
        }

        public boolean isOpaque() {
            return this.getType().getTypeSort().isOpaqueType();
        }

        public boolean isEnum() {
            return this.getType().getTypeSort().isEnumType();
        }

        public boolean isSeq() {
            return this.getType().getTypeSort().isSeqType();
        }

        public boolean isCompound() {
            return this.getType().getTypeSort().isCompoundType();
        }

        public boolean isVlen() {
            return this.isvlen;
        }

        public TypeNotes markVlen() {
            this.isvlen = true;
            return this;
        }

        @Override
        public DapType get() {
            return (DapType)super.get();
        }

        @Override
        public TypeNotes set(DapNode node) {
            return (TypeNotes)super.set(node);
        }
    }

    public static class DimNotes
    extends Notes {
        protected DimNotes(int g2, int id, Nc4DSP dsp) {
            super(NoteSort.DIM, g2, id, dsp);
        }

        @Override
        public DapDimension get() {
            return (DapDimension)super.get();
        }

        @Override
        public DimNotes set(DapNode node) {
            return (DimNotes)super.set(node);
        }
    }

    public static class GroupNotes
    extends Notes {
        protected GroupNotes(int p, int g2, Nc4DSP dsp) {
            super(NoteSort.GROUP, p, g2, dsp);
        }

        @Override
        public DapGroup get() {
            return (DapGroup)super.get();
        }

        @Override
        public GroupNotes set(DapNode node) {
            return (GroupNotes)super.set(node);
        }
    }

    public static class Notes
    implements Cloneable {
        Nc4DSP dsp;
        NoteSort sort;
        int gid;
        int id;
        DapNode node = null;
        protected String name = null;
        protected Notes parent = null;
        protected TypeNotes basetype = null;
        protected long offset = 0L;
        protected long size = 0L;
        protected long recordsize = 0L;

        protected Notes(NoteSort sort, int gid, int id, Nc4DSP dsp) {
            this.sort = sort;
            this.dsp = dsp;
            this.gid = gid;
            this.id = id;
        }

        public NoteSort getSort() {
            return this.sort;
        }

        public Notes setName(String name) {
            this.name = name;
            return this;
        }

        public Notes set(DapNode node) {
            this.node = node;
            if (this.name == null) {
                this.setName(node.getShortName());
            }
            return this;
        }

        public DapNode get() {
            return this.node;
        }

        public Notes setContainer(Notes parent) {
            this.parent = parent;
            return this;
        }

        public Notes getContainer() {
            return this.parent;
        }

        public long getOffset() {
            return this.offset;
        }

        public Notes setOffset(long offset) {
            this.offset = offset;
            return this;
        }

        public long getSize() {
            return this.size;
        }

        public Notes setSize(long size) {
            this.size = size;
            return this;
        }

        public long getRecordSize() {
            return this.recordsize;
        }

        public Notes setRecordSize(long size) {
            this.recordsize = size;
            return this;
        }

        public Notes setBaseType(TypeNotes t) {
            this.basetype = t;
            return this;
        }

        public TypeNotes getBaseType() {
            return this.basetype;
        }

        DapGroup group() {
            GroupNotes g2 = (GroupNotes)this.dsp.find(this.gid, NoteSort.GROUP);
            return g2 == null ? null : g2.get();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getClass().getName());
            buf.append("{");
            if (this.name != null) {
                buf.append("name=");
                buf.append(this.name);
            }
            buf.append(" node=");
            buf.append(this.node != null ? this.node.getShortName() : "null");
            if (this.basetype != null) {
                buf.append(" type=");
                buf.append(this.node.getShortName());
            }
            buf.append("}");
            return buf.toString();
        }
    }

    public static enum NoteSort {
        TYPE,
        VAR,
        GROUP,
        DIM;

    }
}

