/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans;

import javax.xml.namespace.QName;

public final class QNameCache {
    private static final float DEFAULT_LOAD = 0.7f;
    private final float loadFactor;
    private int numEntries = 0;
    private int threshold;
    private int hashmask;
    private QName[] table;
    static final /* synthetic */ boolean $assertionsDisabled;

    public QNameCache(int initialCapacity, float loadFactor) {
        int capacity;
        if (!$assertionsDisabled && initialCapacity <= 0) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || loadFactor > 0.0f && loadFactor < 1.0f)) {
            throw new AssertionError();
        }
        for (capacity = 16; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.hashmask = capacity - 1;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new QName[capacity];
    }

    public QNameCache(int initialCapacity) {
        this(initialCapacity, 0.7f);
    }

    public QName getName(String uri, String localName) {
        return this.getName(uri, localName, "");
    }

    public QName getName(String uri, String localName, String prefix) {
        if (!$assertionsDisabled && localName == null) {
            throw new AssertionError();
        }
        if (uri == null) {
            uri = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        int index = QNameCache.hash(uri, localName, prefix) & this.hashmask;
        while (true) {
            QName q;
            if ((q = this.table[index]) == null) {
                ++this.numEntries;
                if (this.numEntries >= this.threshold) {
                    this.rehash();
                }
                this.table[index] = new QName(uri, localName, prefix);
                return this.table[index];
            }
            if (QNameCache.equals(q, uri, localName, prefix)) {
                return q;
            }
            index = index - 1 & this.hashmask;
        }
    }

    private void rehash() {
        int newLength = this.table.length * 2;
        QName[] newTable = new QName[newLength];
        int newHashmask = newLength - 1;
        for (int i = 0; i < this.table.length; ++i) {
            QName q = this.table[i];
            if (q == null) continue;
            int newIndex = QNameCache.hash(q.getNamespaceURI(), q.getLocalPart(), q.getPrefix()) & newHashmask;
            while (newTable[newIndex] != null) {
                newIndex = newIndex - 1 & newHashmask;
            }
            newTable[newIndex] = q;
        }
        this.table = newTable;
        this.hashmask = newHashmask;
        this.threshold = (int)((float)newLength * this.loadFactor);
    }

    private static int hash(String uri, String localName, String prefix) {
        int h2 = 0;
        h2 += prefix.hashCode() << 10;
        h2 += uri.hashCode() << 5;
        return h2 += localName.hashCode();
    }

    private static boolean equals(QName q, String uri, String localName, String prefix) {
        return q.getLocalPart().equals(localName) && q.getNamespaceURI().equals(uri) && q.getPrefix().equals(prefix);
    }

    static {
        $assertionsDisabled = !QNameCache.class.desiredAssertionStatus();
    }
}

