/*
 * Decompiled with CFR 0.152.
 */
package org.bounce;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public class CenterLayout
implements LayoutManager2 {
    private static final int MINIMUM = 0;
    private static final int PREFERRED = 1;
    private static final int MAXIMUM = 2;
    public static final String CENTER = "Center";
    public static final String TOP = "Top/Left";
    public static final String LEFT = "Top/Left";
    public static final String BOTTOM = "Bottom/Right";
    public static final String RIGHT = "Bottom/Right";
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int gap;
    private int orientation;
    private Component topLeftComponent = null;
    private Component bottomRightComponent = null;
    private Component centerComponent = null;

    public CenterLayout() {
        this(0, 0);
    }

    public CenterLayout(int orientation) {
        this(orientation, 0);
    }

    public CenterLayout(int orientation, int gap) {
        this.orientation = orientation;
        this.gap = gap;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setConstraints(Component component, Object constraint) {
        if (constraint == null || !(constraint instanceof String)) throw new IllegalArgumentException("cannot add to layout: constraint must be of type String");
        String value = (String)constraint;
        this.removeLayoutComponent(component);
        if (value == CENTER) {
            this.centerComponent = component;
            return;
        } else if (value == "Top/Left") {
            this.topLeftComponent = component;
            return;
        } else {
            if (value != "Bottom/Right") throw new IllegalArgumentException("cannot add to layout: constraint must be of a defined type");
            this.bottomRightComponent = component;
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component != null) {
            if (this.centerComponent != null && this.centerComponent.equals(component)) {
                this.centerComponent = null;
            } else if (this.topLeftComponent != null && this.topLeftComponent.equals(component)) {
                this.topLeftComponent = null;
            } else if (this.bottomRightComponent != null && this.bottomRightComponent.equals(component)) {
                this.bottomRightComponent = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return this.getSize(1, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return this.getSize(0, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            Dimension size = parent.getSize();
            int width = size.width - (insets.left + insets.right);
            int height = size.height - (insets.top + insets.bottom);
            Dimension centerSize = this.getSize(1, this.centerComponent);
            int totalGap = this.getTotalGap();
            if (this.orientation == 1) {
                int x = insets.left;
                int y = insets.top;
                int w = width;
                int h2 = 0;
                h2 = (height - centerSize.height - totalGap) / 2;
                if (h2 < 0) {
                    h2 = 0;
                }
                if (this.topLeftComponent != null && this.topLeftComponent.isVisible()) {
                    this.topLeftComponent.setBounds(x, y, w, h2);
                }
                y += h2 + this.gap;
                if (this.centerComponent != null && this.centerComponent.isVisible()) {
                    h2 = centerSize.height;
                    this.centerComponent.setBounds(x, y, w, h2);
                    y += h2 + this.gap;
                }
                if ((h2 = height - y + insets.top) < 0) {
                    h2 = 0;
                }
                if (this.bottomRightComponent != null && this.bottomRightComponent.isVisible()) {
                    this.bottomRightComponent.setBounds(x, y, w, h2);
                }
            } else {
                int x = insets.left;
                int y = insets.top;
                int w = 0;
                int h3 = height;
                w = (width - centerSize.width - totalGap) / 2;
                if (w < 0) {
                    w = 0;
                }
                if (this.topLeftComponent != null && this.topLeftComponent.isVisible()) {
                    this.topLeftComponent.setBounds(x, y, w, h3);
                }
                x += w + this.gap;
                if (this.centerComponent != null && this.centerComponent.isVisible()) {
                    w = centerSize.width;
                    this.centerComponent.setBounds(x, y, w, h3);
                    x += w + this.gap;
                }
                if ((w = width - x + insets.left) < 0) {
                    w = 0;
                }
                if (this.bottomRightComponent != null && this.bottomRightComponent.isVisible()) {
                    this.bottomRightComponent.setBounds(x, y, w, h3);
                }
            }
        }
    }

    public void addLayoutComponent(Component component, Object constraints) {
        this.setConstraints(component, constraints);
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    private int getTotalGap() {
        int totalGap = 0;
        if (this.topLeftComponent != null && this.topLeftComponent.isVisible()) {
            totalGap += this.gap;
        }
        if (this.bottomRightComponent != null && this.bottomRightComponent.isVisible()) {
            totalGap += this.gap;
        }
        if (this.centerComponent == null || !this.centerComponent.isVisible()) {
            totalGap -= this.gap;
        }
        if (totalGap < 0) {
            totalGap = 0;
        }
        return totalGap;
    }

    private Dimension getSize(int type, Component component) {
        Dimension size = new Dimension();
        if (component != null && component.isVisible()) {
            switch (type) {
                case 0: {
                    size = component.getMinimumSize();
                    break;
                }
                case 1: {
                    size = component.getPreferredSize();
                    break;
                }
                case 2: {
                    size = component.getMaximumSize();
                }
            }
        }
        return size;
    }

    private Dimension getSize(int type, Container parent) {
        Dimension size = new Dimension();
        Dimension centerSize = this.getSize(type, this.centerComponent);
        Insets insets = parent.getInsets();
        int totalGap = this.getTotalGap();
        if (this.orientation == 1) {
            size.width = centerSize.width + insets.left + insets.right;
            size.height = centerSize.height + totalGap + insets.top + insets.bottom;
        } else {
            size.width = centerSize.width + totalGap + insets.left + insets.right;
            size.height = centerSize.height + insets.top + insets.bottom;
        }
        return size;
    }
}

