/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.bounce.text.FoldingPlainView;
import org.bounce.text.SyntaxHighlightingScanner;

public abstract class SyntaxHighlightingView
extends FoldingPlainView {
    private static Style DEFAULT_STYLE = new StyleContext.NamedStyle(new StyleContext());
    private Color selected = null;
    private SyntaxHighlightingScanner scanner = null;
    private StyleContext context = null;

    public SyntaxHighlightingView(SyntaxHighlightingScanner scanner, StyleContext context, Element elem) throws IOException {
        super(elem);
        this.context = context;
        this.scanner = scanner;
    }

    public void paint(Graphics g2, Shape a) {
        JTextComponent component = (JTextComponent)this.getContainer();
        Highlighter highlighter = component.getHighlighter();
        Color unselected = component.isEnabled() ? component.getForeground() : component.getDisabledTextColor();
        Caret caret = component.getCaret();
        this.selected = !caret.isSelectionVisible() || highlighter == null ? unselected : component.getSelectedTextColor();
        super.paint(g2, a);
        this.scanner.setValid(false);
    }

    protected int drawUnselectedText(Graphics g2, int x, int y, int start, int end) throws BadLocationException {
        if (this.context != null) {
            Document doc = this.getDocument();
            while (start < end) {
                this.updateScanner(this.scanner, doc, start, doc.getLength());
                int position = Math.min(this.scanner.getEndOffset(), end);
                position = position <= start ? end : position;
                Style style = this.context.getStyle(this.scanner.token);
                if (style == null) {
                    style = DEFAULT_STYLE;
                }
                g2.setColor(this.context.getForeground(style));
                g2.setFont(g2.getFont().deriveFont(SyntaxHighlightingView.getFontStyle(style)));
                Segment text = this.getLineBuffer();
                doc.getText(start, position - start, text);
                int x1 = x;
                x = Utilities.drawTabbedText(text, x, y, g2, (TabExpander)this, start);
                if (this.scanner.isError()) {
                    this.drawError(this.scanner, g2, x1, x - x1, y, false);
                }
                start = position;
            }
        }
        return x;
    }

    private void drawError(SyntaxHighlightingScanner scanner, Graphics g2, int x, int length, int y, boolean selected) throws BadLocationException {
        if (this.isErrorHighlighting()) {
            Rectangle rec;
            if (!selected) {
                g2.setColor(new Color(255, 0, 0));
            }
            if ((rec = ((JTextComponent)this.getContainer()).modelToView(scanner.getStartOffset())) != null) {
                SyntaxHighlightingView.drawZigZag(g2, x, rec.x, length, y);
            }
        }
    }

    protected abstract boolean isErrorHighlighting();

    private static void drawZigZag(Graphics g2, int x, int x1, int width, int y) {
        int pos = 0;
        int before = x - x1;
        int npoints = width;
        if (npoints > 0) {
            int[] xpoints = new int[npoints];
            int[] ypoints = new int[npoints];
            for (int i = 0; i < npoints; ++i) {
                int height = (i + before) % 4;
                if (height > 2) {
                    height -= 2;
                }
                xpoints[i] = x + pos;
                ypoints[i] = y + 2 - height;
                ++pos;
            }
            g2.drawPolyline(xpoints, ypoints, npoints);
        }
    }

    protected int drawSelectedText(Graphics g2, int x, int y, int start, int end) throws BadLocationException {
        g2.setColor(this.selected);
        Document doc = this.getDocument();
        while (start < end) {
            this.updateScanner(this.scanner, doc, start, doc.getLength());
            int position = Math.min(this.scanner.getEndOffset(), end);
            position = position <= start ? end : position;
            Style style = this.context.getStyle(this.scanner.token);
            if (style == null) {
                style = DEFAULT_STYLE;
            }
            g2.setFont(g2.getFont().deriveFont(SyntaxHighlightingView.getFontStyle(style)));
            Segment text = this.getLineBuffer();
            doc.getText(start, position - start, text);
            int x1 = x;
            x = Utilities.drawTabbedText(text, x, y, g2, (TabExpander)this, start);
            if (this.scanner.isError()) {
                this.drawError(this.scanner, g2, x1, x - x1, y, true);
            }
            start = position;
        }
        return x;
    }

    protected abstract void updateScanner(SyntaxHighlightingScanner var1, Document var2, int var3, int var4);

    public static int getFontStyle(Style style) {
        int fontStyle = 0;
        if (style != null) {
            if (StyleConstants.isItalic(style)) {
                fontStyle += 2;
            }
            if (StyleConstants.isBold(style)) {
                ++fontStyle;
            }
        }
        return fontStyle;
    }
}

