/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text.xml;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.bounce.text.xml.XMLScanner;
import org.bounce.text.xml.XMLStyleConstants;
import org.bounce.text.xml.XMLView;

public class XMLEditorKit
extends DefaultEditorKit
implements XMLStyleConstants,
KeyListener {
    private static final long serialVersionUID = 6303638967973333256L;
    public static final String ERROR_HIGHLIGHTING_ATTRIBUTE = "errorHighlighting";
    private boolean tagCompletion = false;
    private boolean autoIndent = false;
    private StyleContext context = new StyleContext();
    private ViewFactory factory = null;

    public XMLEditorKit() {
        this.setStyle("element-name", new Color(136, 18, 128), 0);
        this.setStyle("element-value", Color.black, 0);
        this.setStyle("element-prefix", new Color(136, 18, 128), 0);
        this.setStyle("attribute-name", new Color(153, 69, 0), 0);
        this.setStyle("attribute-value", new Color(26, 26, 166), 0);
        this.setStyle("attribute-prefix", new Color(153, 69, 0), 0);
        this.setStyle("namespace-name", new Color(128, 128, 0), 0);
        this.setStyle("namespace-value", new Color(63, 95, 191), 0);
        this.setStyle("namespace-prefix", new Color(128, 128, 0), 0);
        this.setStyle("Entity", new Color(102, 102, 102), 0);
        this.setStyle("CDATA", new Color(127, 159, 191), 0);
        this.setStyle("Comment", new Color(63, 127, 95), 0);
        this.setStyle("Special", new Color(102, 102, 102), 0);
        this.factory = new XMLViewFactory();
    }

    public String getContentType() {
        return "text/xml";
    }

    public ViewFactory getViewFactory() {
        return this.factory;
    }

    public final void setTagCompletion(boolean enabled) {
        this.tagCompletion = enabled;
    }

    public final void setAutoIndentation(boolean enabled) {
        this.autoIndent = enabled;
    }

    public void setStyle(String token, Color foreground, int fontStyle) {
        Style s2 = this.context.getStyle(token);
        if (s2 == null) {
            s2 = this.context.addStyle(token, new StyleContext.NamedStyle(this.context));
        }
        StyleConstants.setItalic(s2, (fontStyle & 2) > 0);
        StyleConstants.setBold(s2, (fontStyle & 1) > 0);
        StyleConstants.setForeground(s2, foreground);
    }

    public void install(JEditorPane editor) {
        super.install(editor);
        editor.addKeyListener(this);
    }

    public void deinstall(JEditorPane editor) {
        super.deinstall(editor);
        editor.removeKeyListener(this);
    }

    private static void completeTag(Document document, int off) throws BadLocationException {
        String tag;
        char first;
        StringBuffer endTag = new StringBuffer();
        String text = document.getText(0, off);
        int startTag = text.lastIndexOf(60, off);
        int prefEndTag = text.lastIndexOf(62, off);
        if (startTag > 0 && startTag > prefEndTag && startTag < text.length() - 1 && (first = (tag = text.substring(startTag, text.length())).charAt(1)) != '/' && first != '!' && first != '?' && !Character.isWhitespace(first)) {
            boolean finished = false;
            char previous = tag.charAt(tag.length() - 1);
            if (previous != '/' && previous != '-') {
                endTag.append("</");
                for (int i = 1; i < tag.length() && !finished; ++i) {
                    char ch = tag.charAt(i);
                    if (!Character.isWhitespace(ch)) {
                        endTag.append(ch);
                        continue;
                    }
                    finished = true;
                }
                endTag.append(">");
            }
        }
        document.insertString(off, endTag.toString(), null);
    }

    private static void autoIndent(Document document, int off) throws BadLocationException {
        StringBuffer newStr = new StringBuffer("\r\n");
        Element elem = document.getDefaultRootElement().getElement(document.getDefaultRootElement().getElementIndex(off));
        int start = elem.getStartOffset();
        String line = document.getText(start, off - start);
        boolean finished = false;
        for (int i = 0; i < line.length() && !finished; ++i) {
            char ch = line.charAt(i);
            if (ch != '\n' && ch != '\f' && ch != '\r' && Character.isWhitespace(ch)) {
                newStr.append(ch);
                continue;
            }
            finished = true;
        }
        if (XMLEditorKit.isStartElement(line)) {
            newStr.append("\t");
        }
        document.insertString(off, newStr.toString(), null);
    }

    private static boolean isStartElement(String line) {
        boolean result = false;
        int first = line.lastIndexOf("<");
        int last = line.lastIndexOf(">");
        if (last < first) {
            result = true;
        } else {
            int firstEnd = line.lastIndexOf("</");
            int lastEnd = line.lastIndexOf("/>");
            if (firstEnd != first && lastEnd + 1 != last) {
                result = true;
            }
        }
        return result;
    }

    public void keyPressed(KeyEvent event) {
        JEditorPane editor = (JEditorPane)event.getSource();
        if (event.getKeyChar() == '>' && this.tagCompletion) {
            try {
                int pos = editor.getCaretPosition();
                XMLEditorKit.completeTag(editor.getDocument(), pos);
                editor.setCaretPosition(pos);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else if (event.getKeyChar() == '\n' && this.autoIndent) {
            try {
                XMLEditorKit.autoIndent(editor.getDocument(), editor.getCaretPosition());
                event.consume();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    public void keyReleased(KeyEvent keyevent) {
    }

    public void keyTyped(KeyEvent keyevent) {
    }

    class XMLViewFactory
    implements ViewFactory {
        XMLViewFactory() {
        }

        public View create(Element elem) {
            try {
                return new XMLView(new XMLScanner(elem.getDocument()), XMLEditorKit.this.context, elem);
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }
}

