/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.StringTokenizer;

public class URIUtils {
    private static String encodeURI(String url) {
        StringBuffer uri = new StringBuffer(url.length());
        int length = url.length();
        block5: for (int i = 0; i < length; ++i) {
            char c = url.charAt(i);
            switch (c) {
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '[': 
                case ']': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '~': {
                    uri.append(c);
                    continue block5;
                }
                default: {
                    StringBuffer result = new StringBuffer(3);
                    String s2 = String.valueOf(c);
                    try {
                        byte[] data = s2.getBytes("UTF8");
                        for (int j = 0; j < data.length; ++j) {
                            result.append('%');
                            String hex = Integer.toHexString(data[j]);
                            result.append(hex.substring(hex.length() - 2));
                        }
                        uri.append(result.toString());
                        continue block5;
                    }
                    catch (UnsupportedEncodingException ex) {
                        // empty catch block
                    }
                }
            }
        }
        return uri.toString();
    }

    public static String getName(URI uri) {
        String location;
        if (uri != null && (location = uri.getSchemeSpecificPart()) != null) {
            String name = location;
            int index = location.lastIndexOf(47);
            if (index != -1) {
                name = name.substring(index + 1, name.length());
            }
            return name;
        }
        return "";
    }

    public static String getExtension(URI uri) {
        String location;
        if (uri != null && (location = uri.getSchemeSpecificPart()) != null) {
            String name = location;
            int index = location.lastIndexOf(46);
            if (index != -1) {
                name = name.substring(index + 1, name.length());
            }
            return name;
        }
        return "";
    }

    public static String getDirectoryName(URI uri) {
        String location = uri.getSchemeSpecificPart();
        if (location != null) {
            String name = location;
            int end = location.lastIndexOf(47);
            if (end != -1) {
                int start = location.lastIndexOf(47, end - 1);
                name = name.substring(start + 1, end);
            }
            return name;
        }
        return null;
    }

    public static URI createURI(String path) {
        path = path.replace('\\', '/');
        return URI.create(URIUtils.encodeURI(path));
    }

    public static String toString(URI uri) {
        StringBuffer buffer = new StringBuffer();
        if (uri.getScheme() != null) {
            buffer.append(uri.getScheme());
            buffer.append(":");
        }
        buffer.append(uri.getSchemeSpecificPart());
        if (uri.getFragment() != null) {
            buffer.append("#");
            buffer.append(uri.getFragment());
        }
        return buffer.toString();
    }

    public static File toFile(URI uri) {
        return new File((File)null, uri.getSchemeSpecificPart());
    }

    public static URI getRelativeURI(URI base, URI uri) {
        if (base != null && uri != null && (uri.getScheme() == null || uri.getScheme().equals(base.getScheme()))) {
            StringTokenizer baseParts = URIUtils.tokenizeBase(base);
            StringTokenizer uriParts = new StringTokenizer(uri.getSchemeSpecificPart(), "/");
            StringBuffer relativePath = new StringBuffer();
            String part = null;
            boolean first = true;
            if (!baseParts.hasMoreTokens()) {
                return uri;
            }
            while (baseParts.hasMoreTokens() && uriParts.hasMoreTokens()) {
                String baseDir = baseParts.nextToken();
                if (baseDir.equals(part = uriParts.nextToken()) && baseDir.contains(":") && first) {
                    baseDir = baseParts.nextToken();
                    part = uriParts.nextToken();
                }
                if (!baseDir.equals(part)) {
                    if (first) {
                        return uri;
                    }
                    relativePath.append("../");
                    break;
                }
                part = null;
                first = false;
            }
            while (baseParts.hasMoreTokens()) {
                relativePath.append("../");
                baseParts.nextToken();
            }
            if (part != null) {
                relativePath.append(part);
                if (uriParts.hasMoreTokens()) {
                    relativePath.append("/");
                }
            }
            while (uriParts.hasMoreTokens()) {
                relativePath.append(uriParts.nextToken());
                if (!uriParts.hasMoreTokens()) continue;
                relativePath.append("/");
            }
            return URIUtils.createURI(relativePath.toString());
        }
        return uri;
    }

    public static String getRelativePath(URI base, File file) {
        return URIUtils.toString(URIUtils.getRelativeURI(base, file.toURI()));
    }

    public static URI composeURI(URI base, String relativePath) {
        if (base != null) {
            return base.resolve(URIUtils.createURI(relativePath));
        }
        return URIUtils.createURI(relativePath);
    }

    public static File composeFile(URI base, String relativePath) {
        URI uri = URIUtils.composeURI(base, relativePath);
        if (uri.isAbsolute()) {
            return new File(uri);
        }
        if (base != null) {
            return new File(new File(base), uri.toString());
        }
        return null;
    }

    public static String composePath(URI base, String relativePath) {
        URI uri = URIUtils.composeURI(base, relativePath);
        if (uri.isAbsolute()) {
            File file = new File(uri);
            return file.toString();
        }
        if (base != null) {
            File file = new File(new File(base), uri.toString());
            return file.toString();
        }
        return relativePath;
    }

    private static StringTokenizer tokenizeBase(URI uri) {
        String scheme = uri.getSchemeSpecificPart();
        int index = scheme.lastIndexOf("/");
        if (index != -1) {
            scheme = scheme.substring(0, index + 1);
        }
        return new StringTokenizer(scheme, "/");
    }
}

