/*
 * Decompiled with CFR 0.152.
 */
package thredds.logs;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import thredds.logs.LogReader;

public class AccessLogParser
implements LogReader.LogParser {
    private SimpleDateFormat formatFrom = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
    static Pattern regPattern = Pattern.compile("^(\\d+\\.\\d+\\.\\d+\\.\\d+) - (.*) \\[(.*)] \"(.*)\" (\\d+) ([\\-\\d]+) \"(.*)\" \"(.*)\" (\\d+)");
    private static Pattern regPattern2 = Pattern.compile("^(\\d+\\.\\d+\\.\\d+\\.\\d+) - (.*) \\[(.*)] \"(.*)\" (\\d+) ([\\-\\d]+)");

    @Override
    public LogReader.Log nextLog(BufferedReader dataIS) throws IOException {
        String line = dataIS.readLine();
        if (line == null) {
            return null;
        }
        LogReader.Log resultLog = this.parseLog(line);
        if (resultLog != null) {
            return resultLog;
        }
        return this.nextLog(dataIS);
    }

    LogReader.Log parseLog(String line) throws IOException {
        try {
            Matcher m3 = regPattern.matcher(line);
            if (m3.matches()) {
                LogReader.Log log = new LogReader.Log();
                log.ip = m3.group(1);
                log.date = this.convertDate(m3.group(3));
                String request = m3.group(4);
                log.returnCode = this.parse(m3.group(5));
                log.sizeBytes = this.parseLong(m3.group(6));
                log.referrer = m3.group(7);
                log.client = m3.group(8);
                log.msecs = this.parseLong(m3.group(9));
                String[] reqss = request.split(" ");
                if (reqss.length == 3) {
                    log.verb = reqss[0].intern();
                    log.path = reqss[1];
                    log.http = reqss[2].intern();
                } else if (reqss.length == 2) {
                    log.verb = reqss[0].intern();
                    log.path = reqss[1];
                }
                return log;
            }
            m3 = regPattern2.matcher(line);
            if (m3.matches()) {
                LogReader.Log log = new LogReader.Log();
                log.ip = m3.group(1);
                log.date = this.convertDate(m3.group(3));
                String request = m3.group(4);
                log.returnCode = this.parse(m3.group(5));
                log.sizeBytes = this.parseLong(m3.group(6));
                log.referrer = "-";
                log.client = "-";
                log.msecs = -1L;
                String[] reqss = request.split(" ");
                if (reqss.length == 3) {
                    log.verb = reqss[0].intern();
                    log.path = reqss[1];
                    log.http = reqss[2].intern();
                } else if (reqss.length == 2) {
                    log.verb = reqss[0].intern();
                    log.path = reqss[1];
                }
                return log;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Cant parse " + line);
        }
        return null;
    }

    private long convertDate(String accessDateFormat) {
        try {
            Date d = this.formatFrom.parse(accessDateFormat);
            return d.getTime();
        }
        catch (Throwable t) {
            System.out.printf("Bad date format = %s err = %s%n", accessDateFormat, t.getMessage());
            return -1L;
        }
    }

    private int parse(String s2) {
        if (s2.equals("-")) {
            return 0;
        }
        return Integer.parseInt(s2);
    }

    private long parseLong(String s2) {
        if (s2.equals("-")) {
            return 0L;
        }
        return Long.parseLong(s2);
    }
}

