/*
 * Decompiled with CFR 0.152.
 */
package thredds.logs;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import ucar.unidata.util.StringUtil2;

public class PathMatcher {
    private final TreeMap<String, Match> treeMap = new TreeMap(new PathComparator());

    public void put(String root) {
        this.treeMap.put(root, new Match(root));
    }

    public Match get(String key) {
        return this.treeMap.get(key);
    }

    public Iterator iterator() {
        return this.treeMap.values().iterator();
    }

    public Match match(String path) {
        SortedMap<String, Match> tail = this.treeMap.tailMap(path);
        if (tail.isEmpty()) {
            return null;
        }
        String after = tail.firstKey();
        if (path.startsWith(after)) {
            return this.treeMap.get(after);
        }
        for (String key : tail.keySet()) {
            if (path.startsWith(key)) {
                return this.treeMap.get(key);
            }
            if (StringUtil2.match(path, key) != 0) continue;
            break;
        }
        return null;
    }

    private static class PathComparator
    implements Comparator<String>,
    Serializable {
        private PathComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int compare = -1 * o1.compareTo(o2);
            return compare;
        }
    }

    public static class Match {
        public String root;

        Match(String root) {
            this.root = root;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("root", this.root).toString();
        }
    }
}

