/*
 * Decompiled with CFR 0.152.
 */
package thredds.logs;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import thredds.logs.LogReader;
import ucar.nc2.util.EscapeStrings;

public class ServletLogParser
implements LogReader.LogParser {
    private static final Pattern donePattern = Pattern.compile("^Request Completed - (.*) - (.*) - (.*)");
    static final Pattern startPattern = Pattern.compile("^Remote host: ([^-]+) - Request: \"(\\w+) (.*) (.*)");
    static final Pattern commonPattern = Pattern.compile("^(\\d+-\\d+-\\d+T\\d+:\\d+:\\d+\\.\\d+ [+-]\\d+) \\[(.*)]\\[(.*)] (\\w+)[\\s]+- ([^-]+) - (.*)");
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    @Override
    public LogReader.Log nextLog(BufferedReader dataIS) throws IOException {
        ServletLog log = new ServletLog();
        boolean haveLog = false;
        while (true) {
            dataIS.mark(20000);
            String line = dataIS.readLine();
            if (line == null) {
                return haveLog ? log : null;
            }
            try {
                Matcher m3 = commonPattern.matcher(line);
                if (m3.matches()) {
                    Matcher m22;
                    int pos;
                    if (haveLog) {
                        try {
                            dataIS.reset();
                            return log;
                        }
                        catch (Throwable t) {
                            System.out.println("Cant reset " + line);
                        }
                    }
                    haveLog = true;
                    log.date = this.convertDate(m3.group(1));
                    log.reqTime = this.parseLong(m3.group(2));
                    log.reqSeq = this.parseLong(m3.group(3));
                    log.level = m3.group(4).intern();
                    log.where = m3.group(5);
                    String rest = m3.group(6);
                    if (rest.contains("Request Completed")) {
                        pos = rest.indexOf("Request Completed");
                        m22 = donePattern.matcher(rest.substring(pos));
                        if (m22.matches()) {
                            log.returnCode = this.parse(m22.group(1));
                            log.sizeBytes = this.parseLong(m22.group(2));
                            log.msecs = this.parseLong(m22.group(3));
                            log.isDone = true;
                            continue;
                        }
                        System.out.println("Cant parse donePattern= " + rest);
                        System.out.println(" line= " + line);
                        log.addExtra(rest);
                        continue;
                    }
                    if (rest.contains("Remote host")) {
                        pos = rest.indexOf("Remote host");
                        m22 = startPattern.matcher(rest.substring(pos));
                        if (m22.matches()) {
                            log.ip = m22.group(1);
                            log.verb = m22.group(2).intern();
                            log.path = EscapeStrings.urlDecode(m22.group(3));
                            if (m22.groupCount() > 4) {
                                log.http = m22.group(4).intern();
                            }
                            log.isStart = true;
                            continue;
                        }
                        System.out.println("Cant parse startPattern= " + rest);
                        System.out.println(" line= " + line);
                        log.addExtra(rest);
                        continue;
                    }
                    log.addExtra(rest);
                    continue;
                }
                log.addExtra(line);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Cant parse " + line);
                log.addExtra(line);
                continue;
            }
            break;
        }
    }

    private long convertDate(String accessDateFormat) {
        try {
            Date d = this.df.parse(accessDateFormat);
            return d.getTime();
        }
        catch (Throwable t) {
            System.out.printf("Bad date format = %s err = %s%n", accessDateFormat, t.getMessage());
            return -1L;
        }
    }

    private int parse(String s2) {
        if ((s2 = s2.trim()).isEmpty()) {
            return 0;
        }
        if (s2.equals("-")) {
            return 0;
        }
        return Integer.parseInt(s2);
    }

    private long parseLong(String s2) {
        if ((s2 = s2.trim()).isEmpty()) {
            return 0L;
        }
        if (s2.equals("-")) {
            return 0L;
        }
        return Long.parseLong(s2);
    }

    public static class ServletLog
    extends LogReader.Log {
        long reqTime;
        long reqSeq;
        String level;
        String where;
        public StringBuilder extra;
        boolean isDone;
        boolean isStart;
        int nthreads;

        public long getReqTime() {
            return this.reqTime;
        }

        public long getReqSeq() {
            return this.reqSeq;
        }

        public String getLevel() {
            return this.level;
        }

        public boolean isExtra() {
            return this.extra != null;
        }

        public boolean isDone() {
            return this.isDone;
        }

        public boolean isStart() {
            return this.isStart;
        }

        public int getNthreads() {
            return this.nthreads;
        }

        public void setNthreads(int nthreads) {
            this.nthreads = nthreads;
        }

        @Override
        public String toString() {
            Formatter f = new Formatter();
            f.format("%s [%d] [%d] %s %s: ", this.getDate(), this.reqTime, this.reqSeq, this.level, this.where);
            if (this.isStart) {
                f.format(" (%s) %s %n", this.ip, this.getPath());
            } else if (this.isDone) {
                f.format(" %d %d %d %n", this.returnCode, this.sizeBytes, this.msecs);
            }
            if (this.extra != null) {
                f.format(" %s", this.extra);
            }
            return f.toString();
        }

        void addExtra(String s2) {
            if (this.extra == null) {
                this.extra = new StringBuilder(300);
            }
            this.extra.append(s2);
            this.extra.append("\n");
        }
    }
}

