/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ogc;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.xml.namespace.QName;
import net.opengis.waterml.x20.CollectionDocument;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlValidationError;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ogc.waterml.NcCollectionType;
import ucar.nc2.time.CalendarDate;

public class MarshallingUtil {
    public static CalendarDate fixedGenerationDate = null;
    public static CalendarDate fixedResultTime = null;
    private static Map<Class<?>, Integer> idsMap = new HashMap();

    public static String createIdForType(Class<?> clazz) {
        Integer numIds = idsMap.get(clazz);
        if (numIds == null) {
            numIds = 0;
        }
        numIds = numIds + 1;
        String id = clazz.getSimpleName() + "." + numIds;
        idsMap.put(clazz, numIds);
        return id;
    }

    public static void resetIds() {
        idsMap.clear();
    }

    public static void marshalPointDataset(FeatureDatasetPoint fdPoint, OutputStream outputStream) throws IOException, XmlException {
        MarshallingUtil.marshalPointDataset(fdPoint, fdPoint.getDataVariables(), outputStream);
    }

    public static void marshalPointDataset(FeatureDatasetPoint fdPoint, List<VariableSimpleIF> dataVars, OutputStream outputStream) throws IOException, XmlException {
        MarshallingUtil.resetIds();
        CollectionDocument collectionDoc = CollectionDocument.Factory.newInstance();
        NcCollectionType.initCollection(collectionDoc.addNewCollection(), fdPoint, dataVars);
        MarshallingUtil.writeObject(collectionDoc, outputStream, true);
    }

    public static void writeObject(XmlObject doc, OutputStream out, boolean validate) throws IOException, XmlException {
        XmlCursor cursor = doc.newCursor();
        if (cursor.toFirstChild()) {
            String location = "http://www.opengis.net/waterml/2.0 http://schemas.opengis.net/waterml/2.0/waterml2.xsd";
            cursor.setAttributeText(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"), location);
        }
        if (validate) {
            MarshallingUtil.validate(doc, false);
        }
        doc.save(out, MarshallingUtil.makeOptions());
    }

    private static XmlOptions makeOptions() {
        XmlOptions options = new XmlOptions();
        options.setSaveNamespacesFirst();
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(4);
        options.setSaveAggressiveNamespaces();
        options.setSaveSuggestedPrefixes(MarshallingUtil.getSuggestedPrefixes());
        return options;
    }

    private static Map<String, String> getSuggestedPrefixes() {
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        prefixMap.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        prefixMap.put("http://www.w3.org/1999/xlink", "xlink");
        prefixMap.put("http://www.opengis.net/gml/3.2", "gml");
        prefixMap.put("http://www.opengis.net/om/2.0", "om");
        prefixMap.put("http://www.opengis.net/sampling/2.0", "sam");
        prefixMap.put("http://www.opengis.net/samplingSpatial/2.0", "sams");
        prefixMap.put("http://www.opengis.net/swe/2.0", "swe");
        prefixMap.put("http://www.opengis.net/waterml/2.0", "wml2");
        prefixMap.put("http://www.opengis.net/waterml-dr/2.0", "wml2dr");
        prefixMap.put("http://www.opengis.net/gmlcov/1.0", "gmlcov");
        return prefixMap;
    }

    public static void validate(XmlObject doc, boolean strict) throws XmlException {
        Set<XmlError> validationErrors = new HashSet<XmlError>();
        XmlOptions validationOptions = new XmlOptions();
        validationOptions.setErrorListener(validationErrors);
        boolean isValid = doc.validate(validationOptions);
        if (!isValid && !strict) {
            validationErrors = MarshallingUtil.filterToOnlySerious(validationErrors);
        }
        if (!validationErrors.isEmpty()) {
            throw new XmlException(MarshallingUtil.createErrorMessage(validationErrors));
        }
    }

    private static Set<XmlError> filterToOnlySerious(Iterable<XmlError> allValidationErrors) {
        HashSet<XmlError> filteredErrors = new HashSet<XmlError>();
        GML32AbstractFeatureLaxCase pred = new GML32AbstractFeatureLaxCase();
        for (XmlError validationError : allValidationErrors) {
            if (pred.test(validationError)) continue;
            filteredErrors.add(validationError);
        }
        return filteredErrors;
    }

    private static String createErrorMessage(Collection<XmlError> errors) {
        StringBuilder errorBuilder = new StringBuilder();
        for (XmlError xmlError : errors) {
            errorBuilder.append(xmlError.getMessage()).append(";");
        }
        if (!errors.isEmpty()) {
            errorBuilder.deleteCharAt(errorBuilder.length() - 1);
        }
        return errorBuilder.toString();
    }

    private MarshallingUtil() {
    }

    private static class GML32AbstractFeatureLaxCase
    implements Predicate<XmlError> {
        private static final Object FEATURE_QN = new QName("http://www.opengis.net/gml/3.2", "AbstractFeature");

        private GML32AbstractFeatureLaxCase() {
        }

        @Override
        public boolean test(XmlError validationError) {
            if (!(validationError instanceof XmlValidationError)) {
                return false;
            }
            XmlValidationError xve = (XmlValidationError)validationError;
            return xve.getExpectedQNames() != null && xve.getExpectedQNames().contains(FEATURE_QN);
        }
    }
}

