/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.gis.shapefile;

import java.io.InputStream;
import javax.swing.ImageIcon;
import ucar.nc2.ui.gis.MapBean;
import ucar.nc2.ui.gis.shapefile.EsriShapefileRenderer;
import ucar.nc2.ui.util.Renderer;
import ucar.ui.prefs.Debug;
import ucar.ui.util.Resource;
import ucar.ui.widget.BAMutil;

public class ShapeFileBean
extends MapBean {
    private String name;
    private String desc;
    private String iconName;
    private String shapefileName;
    private Renderer rend;

    public ShapeFileBean(String name, String desc, String iconName, String shapefileName) {
        this.name = name;
        this.desc = desc;
        this.iconName = iconName;
        this.shapefileName = shapefileName;
    }

    @Override
    public Renderer getRenderer() {
        if (this.rend == null) {
            this.fetchMap();
        }
        return this.rend;
    }

    private void fetchMap() {
        long startTime = System.currentTimeMillis();
        InputStream is = Resource.getFileResource(this.shapefileName);
        if (is == null) {
            System.err.println("ShapeFileBean read failed on resource " + this.shapefileName);
        } else {
            this.rend = EsriShapefileRenderer.factory(this.shapefileName, is);
        }
        if (Debug.isSet("timing.readShapefile")) {
            long tookTime = System.currentTimeMillis() - startTime;
            System.out.println("timing.readShapefile: " + (double)tookTime * 0.001 + " seconds");
        }
    }

    @Override
    public ImageIcon getIcon() {
        return BAMutil.getIcon(this.iconName, true);
    }

    @Override
    public String getActionName() {
        return this.name;
    }

    @Override
    public String getActionDesc() {
        return this.desc;
    }
}

