/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import thredds.inventory.CollectionUpdateType;
import ucar.ma2.DataType;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.grib1.Grib1Gds;
import ucar.nc2.grib.grib1.Grib1Index;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2Show;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.Grib2Tables;
import ucar.nc2.ui.grib.Grib1CollectionPanel;
import ucar.nc2.util.Misc;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class GribIndexPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable recordTable;
    private BeanTable gds1Table;
    private BeanTable gds2Table;
    private JSplitPane split;
    private TextHistoryPane infoPopup;
    private TextHistoryPane detailTA;
    private IndependentWindow infoWindow;
    private IndependentWindow detailWindow;
    private String indexFile;
    Object gc;
    Grib1Customizer cust1;
    Grib2Tables cust2;

    public GribIndexPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        AbstractButton infoButton = BAMutil.makeButtcon("Information", "Show Info", false);
        infoButton.addActionListener(e -> {
            Formatter f = new Formatter();
            this.showIndex(f);
            this.detailTA.setText(f.toString());
            this.detailTA.gotoTop();
            this.detailWindow.show();
        });
        buttPanel.add(infoButton);
        this.recordTable = new BeanTable<RecordBean>(RecordBean.class, (PreferencesExt)prefs.node("Grib2RecordBean"), false);
        PopupMenu popup = new PopupMenu(this.recordTable.getJTable(), "Options");
        popup.addAction("Show Record", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordBean bean = (RecordBean)GribIndexPanel.this.recordTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    bean.show(f);
                    GribIndexPanel.this.infoPopup.setText(f.toString());
                    GribIndexPanel.this.infoPopup.gotoTop();
                    GribIndexPanel.this.infoWindow.show();
                }
            }
        });
        this.gds1Table = new BeanTable<Gds1Bean>(Gds1Bean.class, (PreferencesExt)prefs.node("GdsRecordBean"), false);
        PopupMenu varPopup = new PopupMenu(this.gds1Table.getJTable(), "Options");
        varPopup.addAction("Compare Raw GDS Bytes", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = GribIndexPanel.this.gds1Table.getSelectedBeans();
                if (list.size() == 2) {
                    Gds1Bean bean1 = (Gds1Bean)list.get(0);
                    Gds1Bean bean2 = (Gds1Bean)list.get(1);
                    Formatter f = new Formatter();
                    GribIndexPanel.this.compareData(bean1, bean2, f);
                    GribIndexPanel.this.infoPopup.setText(f.toString());
                    GribIndexPanel.this.infoPopup.gotoTop();
                    GribIndexPanel.this.infoWindow.show();
                }
            }
        });
        this.gds2Table = new BeanTable<Gds2Bean>(Gds2Bean.class, (PreferencesExt)prefs.node("Gds2RecordBean"), false);
        varPopup = new PopupMenu(this.gds2Table.getJTable(), "Options");
        varPopup.addAction("Compare Raw GDS Bytes", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = GribIndexPanel.this.gds2Table.getSelectedBeans();
                if (list.size() == 2) {
                    Gds2Bean bean1 = (Gds2Bean)list.get(0);
                    Gds2Bean bean2 = (Gds2Bean)list.get(1);
                    Formatter f = new Formatter();
                    GribIndexPanel.this.compareData(bean1, bean2, f);
                    GribIndexPanel.this.infoPopup.setText(f.toString());
                    GribIndexPanel.this.infoPopup.gotoTop();
                    GribIndexPanel.this.infoWindow.show();
                }
            }
        });
        this.infoPopup = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("nj22/NetcdfUI"), this.infoPopup);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.detailTA = new TextHistoryPane();
        this.detailWindow = new IndependentWindow("Extra Information", BAMutil.getImage("nj22/NetcdfUI"), this.detailTA);
        this.detailWindow.setBounds((Rectangle)prefs.getBean("DetailWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.split = new JSplitPane(0, false, this.recordTable, this.gds1Table);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.recordTable.saveState(false);
        this.gds1Table.saveState(false);
        this.gds2Table.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putBeanObject("DetailWindowBounds", this.detailWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public void closeOpenFiles() throws IOException {
        this.gc = null;
    }

    public void setIndexFile(String indexFile) throws IOException {
        block14: {
            this.closeOpenFiles();
            this.indexFile = indexFile;
            this.cust1 = null;
            this.cust2 = null;
            try (RandomAccessFile raf = new RandomAccessFile(indexFile, "r");){
                raf.seek(0L);
                String magic = raf.readString("Grib2Index".getBytes(StandardCharsets.UTF_8).length);
                if (magic.equals("Grib2Index")) {
                    this.readIndex2(indexFile);
                    break block14;
                }
                if (magic.equals("Grib1Index")) {
                    this.readIndex1(indexFile);
                    break block14;
                }
                throw new IOException("Not a grib index file =" + magic);
            }
        }
    }

    public void readIndex1(String filename) throws IOException {
        Grib1Index g1idx = new Grib1Index();
        g1idx.readIndex(filename, 0L, CollectionUpdateType.nocheck);
        ArrayList<RecordBean> records = new ArrayList<RecordBean>();
        for (Grib1Record gr : g1idx.getRecords()) {
            records.add(new RecordBean(gr));
        }
        this.recordTable.setBeans(records);
        this.gc = g1idx;
        ArrayList<Gds1Bean> gdsList = new ArrayList<Gds1Bean>();
        for (Grib1SectionGridDefinition gds : g1idx.getGds()) {
            gdsList.add(new Gds1Bean(gds));
        }
        this.gds1Table.setBeans(gdsList);
        this.split.setBottomComponent(this.gds1Table);
        this.split.setDividerLocation(this.prefs.getInt("splitPos", 500));
    }

    public void readIndex2(String filename) throws IOException {
        Grib2Index g2idx = new Grib2Index();
        g2idx.readIndex(filename, 0L, CollectionUpdateType.nocheck);
        ArrayList<RecordBean> records = new ArrayList<RecordBean>();
        for (Grib2Record gr : g2idx.getRecords()) {
            records.add(new RecordBean(gr));
        }
        this.recordTable.setBeans(records);
        this.gc = g2idx;
        ArrayList<Gds2Bean> gdsList = new ArrayList<Gds2Bean>();
        for (Grib2SectionGridDefinition gds : g2idx.getGds()) {
            gdsList.add(new Gds2Bean(gds));
        }
        this.gds2Table.setBeans(gdsList);
        this.split.setBottomComponent(this.gds2Table);
        this.split.setDividerLocation(this.prefs.getInt("splitPos", 500));
    }

    private void showIndex(Formatter f) {
        if (this.gc == null) {
            return;
        }
        if (this.gc instanceof Grib1Index) {
            Grib1Index index1 = (Grib1Index)this.gc;
            f.format("GRIB1 = %s%n", index1);
        } else if (this.gc instanceof Grib2Index) {
            Grib2Index index2 = (Grib2Index)this.gc;
            f.format("GRIB2 = %s%n", index2);
        }
    }

    private void compareData(RecordBean bean1, RecordBean bean2, Formatter f) {
        byte[] data1 = bean1.gdsBytes();
        byte[] data2 = bean2.gdsBytes();
        Misc.compare(data1, data2, f);
    }

    private void compareData(Gds1Bean bean1, Gds1Bean bean2, Formatter f) {
        byte[] data1 = bean1.gdss.getRawBytes();
        byte[] data2 = bean2.gdss.getRawBytes();
        Misc.compare(data1, data2, f);
    }

    private void compareData(Gds2Bean bean1, Gds2Bean bean2, Formatter f) {
        byte[] data1 = bean1.gdss.getRawBytes();
        byte[] data2 = bean2.gdss.getRawBytes();
        Misc.compare(data1, data2, f);
    }

    public class Gds2Bean
    implements Comparable<Gds2Bean> {
        Grib2SectionGridDefinition gdss;
        Grib2Gds gds;

        public Gds2Bean() {
        }

        public Gds2Bean(Grib2SectionGridDefinition m3) {
            this.gdss = m3;
            this.gds = this.gdss.getGDS();
        }

        public int getGDShash() {
            return this.gds.hashCode();
        }

        public long getCRC() {
            return this.gdss.calcCRC();
        }

        public int getTemplate() {
            return this.gdss.getGDSTemplateNumber();
        }

        public String getGridName() {
            return GribIndexPanel.this.cust2.getCodeTableValue("3.1", this.gdss.getGDSTemplateNumber());
        }

        public String getGroupName() {
            return this.getGridName() + "-" + this.getNy() + "X" + this.getNx();
        }

        public int getNPoints() {
            return this.gdss.getNumberPoints();
        }

        public int getNx() {
            return this.gds.getNx();
        }

        public int getNy() {
            return this.gds.getNy();
        }

        public String getScanMode() {
            int scanMode = this.gds.getScanMode();
            Formatter f = new Formatter();
            f.format("0x%s=", Long.toHexString(scanMode));
            if (!GribUtils.scanModeXisPositive(scanMode)) {
                f.format(" Xneg", new Object[0]);
            }
            if (GribUtils.scanModeYisPositive(scanMode)) {
                f.format(" Ypos", new Object[0]);
            }
            if (!GribUtils.scanModeXisConsecutive(scanMode)) {
                f.format(" !XisConsecutive", new Object[0]);
            }
            if (!GribUtils.scanModeSameDirection(scanMode)) {
                f.format(" !SameDirection", new Object[0]);
            }
            return f.toString();
        }

        public String toString() {
            return this.getGridName() + " " + this.getTemplate() + " " + this.getNx() + " X " + this.getNy();
        }

        public void toRawGdsString(Formatter f) {
            byte[] bytes = this.gds.getRawBytes();
            int count = 1;
            for (byte b : bytes) {
                short s2 = DataType.unsignedByteToShort(b);
                f.format(" %d : %d%n", count++, s2);
            }
        }

        @Override
        public int compareTo(Gds2Bean o) {
            return this.getGroupName().compareTo(o.getGroupName());
        }
    }

    public static class Gds1Bean
    implements Comparable<Gds1Bean> {
        Grib1SectionGridDefinition gdss;
        Grib1Gds gds;

        public Gds1Bean() {
        }

        public Gds1Bean(Grib1SectionGridDefinition m3) {
            this.gdss = m3;
            this.gds = this.gdss.getGDS();
        }

        public int getHash() {
            return this.gds.hashCode();
        }

        public long getCRC() {
            return this.gdss.calcCRC();
        }

        public int getTemplate() {
            return this.gdss.getGridTemplate();
        }

        public boolean isVertCoords() {
            return this.gdss.hasVerticalCoordinateParameters();
        }

        public String getGridName() {
            return this.gds.getNameShort();
        }

        public String getScanMode() {
            return Long.toBinaryString(this.gds.getScanMode());
        }

        public String getResolution() {
            return Long.toBinaryString(this.gds.getResolution());
        }

        public double getDx() {
            return this.gds.getDx();
        }

        public double getDy() {
            return this.gds.getDy();
        }

        public double getDxRaw() {
            return this.gds.getDxRaw();
        }

        public double getDyRaw() {
            return this.gds.getDyRaw();
        }

        public int getNx() {
            return this.gds.getNx();
        }

        public int getNy() {
            return this.gds.getNy();
        }

        public int getNxRaw() {
            return this.gds.getNxRaw();
        }

        public int getNyRaw() {
            return this.gds.getNyRaw();
        }

        @Override
        public int compareTo(Gds1Bean o) {
            return this.getGridName().compareTo(o.getGridName());
        }
    }

    public class RecordBean {
        Grib1Record gr1;
        Grib2Record gr2;

        public RecordBean() {
        }

        public RecordBean(Grib2Record gr) throws IOException {
            this.gr2 = gr;
            if (GribIndexPanel.this.cust2 == null) {
                GribIndexPanel.this.cust2 = Grib2Tables.factory(this.gr2);
            }
        }

        public RecordBean(Grib1Record gr) {
            this.gr1 = gr;
            if (GribIndexPanel.this.cust1 == null) {
                GribIndexPanel.this.cust1 = Grib1Customizer.factory(this.gr1, null);
            }
        }

        public byte[] gdsBytes() {
            return this.gr2 == null ? this.gr1.getGDSsection().getRawBytes() : this.gr2.getGDSsection().getRawBytes();
        }

        public int getFile() {
            return this.gr2 == null ? this.gr1.getFile() : this.gr2.getFile();
        }

        public long getGdsCRC() {
            return this.gr2 == null ? this.gr1.getGDSsection().calcCRC() : this.gr2.getGDSsection().calcCRC();
        }

        public int getPredefinedGrid() {
            return this.gr2 == null ? this.gr1.getGDSsection().getPredefinedGridDefinition() : -1;
        }

        public String getReferenceDate() {
            return this.gr2 == null ? this.gr1.getReferenceDate().toString() : this.gr2.getReferenceDate().toString();
        }

        public String getVariable() {
            return this.gr2 == null ? Integer.toString(this.gr1.getPDSsection().getParameterNumber()) : Grib2Utils.getVariableName(this.gr2);
        }

        public long getStart() {
            return this.gr2 == null ? this.gr1.getIs().getStartPos() : this.gr2.getIs().getStartPos();
        }

        public long getLength() {
            return this.gr2 == null ? this.gr1.getIs().getMessageLength() : this.gr2.getIs().getMessageLength();
        }

        private void show(Formatter f) {
            if (this.gr2 == null) {
                this.show(this.gr1, f);
            } else {
                this.show(this.gr2, f);
            }
        }

        private void show(Grib1Record gr1, Formatter f) {
            Grib1CollectionPanel.showCompleteRecord(GribIndexPanel.this.cust1, gr1, GribIndexPanel.this.indexFile, f);
        }

        private void show(Grib2Record gr2, Formatter f) {
            Grib2Show.showCompleteGribRecord(f, GribIndexPanel.this.indexFile, gr2, GribIndexPanel.this.cust2);
        }
    }
}

