/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.image;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.image.ImageDatasetFactory;
import ucar.nc2.dt.image.ImageFactoryRandom;
import ucar.nc2.ui.image.PicturePane;
import ucar.ui.widget.BAMutil;

public class ImageViewPanel
extends JPanel {
    private static boolean debug;
    private ImageDatasetFactory imageDatasetFactory = new ImageDatasetFactory();
    private ImageFactoryRandom imageFactoryRandom;
    private String location;
    private boolean movieIsPlaying;
    private Timer timer;
    private int delay = 4000;
    private JSpinner spinner;
    private Random random = new Random(System.currentTimeMillis());
    private long start;
    private boolean fullscreenMode;
    private PicturePane pixPane = new PicturePane();
    private JFrame fullFrame;

    public ImageViewPanel(Container buttPanel) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.pixPane, "Center");
        if (buttPanel == null) {
            buttPanel = new JPanel();
            this.add((Component)buttPanel, "North");
        }
        AbstractAction prevAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageViewPanel.this.setImage(ImageViewPanel.this.imageDatasetFactory.getNextImage(false));
            }
        };
        BAMutil.setActionProperties(prevAction, "VCRPrevFrame", "previous", false, 80, -1);
        BAMutil.addActionToContainer(buttPanel, prevAction);
        AbstractAction nextAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageViewPanel.this.setImage(ImageViewPanel.this.imageDatasetFactory.getNextImage(true));
            }
        };
        BAMutil.setActionProperties(nextAction, "VCRNextFrame", "next", false, 78, -1);
        BAMutil.addActionToContainer(buttPanel, nextAction);
        AbstractAction loopAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ImageViewPanel.this.movieIsPlaying) {
                    if (ImageViewPanel.this.timer != null) {
                        ImageViewPanel.this.timer.stop();
                    }
                    ImageViewPanel.this.movieIsPlaying = false;
                } else {
                    if (ImageViewPanel.this.location == null) {
                        return;
                    }
                    File f = new File(ImageViewPanel.this.location);
                    if (!f.exists()) {
                        return;
                    }
                    ImageViewPanel.this.imageFactoryRandom = new ImageFactoryRandom(f.getParentFile());
                    ImageViewPanel.this.timer = new Timer(ImageViewPanel.this.delay, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            ImageViewPanel.this.setImage(ImageViewPanel.this.imageFactoryRandom.getNextImage());
                            int delayMsecs = ImageViewPanel.this.delay + ImageViewPanel.this.random.nextInt() % ImageViewPanel.this.delay / 2;
                            ImageViewPanel.this.timer.setDelay(delayMsecs);
                            long time = System.currentTimeMillis();
                            long took = time - ImageViewPanel.this.start;
                            ImageViewPanel.this.start = time;
                            System.out.printf(" delay=%d; took=%d%n ", delayMsecs, took);
                        }
                    });
                    ImageViewPanel.this.timer.start();
                    ImageViewPanel.this.movieIsPlaying = true;
                }
            }
        };
        BAMutil.setActionProperties(loopAction, "MovieLoop", "loop", true, 78, -1);
        BAMutil.addActionToContainer(buttPanel, loopAction);
        this.spinner = new JSpinner(new SpinnerNumberModel(5000, 10, 20000, 1000));
        this.spinner.addChangeListener(e -> {
            Integer value = (Integer)this.spinner.getModel().getValue();
            this.delay = value;
            if (this.timer != null) {
                this.timer.setDelay(this.delay);
            }
        });
        buttPanel.add(this.spinner);
        AbstractAction fullscreenAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice device = ge.getDefaultScreenDevice();
                System.out.println("isFullScreenSupported= " + device.isFullScreenSupported());
                ImageViewPanel.this.fullFrame = new JFrame();
                ImageViewPanel.this.fullFrame.setUndecorated(true);
                ImageViewPanel.this.fullFrame.getContentPane().add(ImageViewPanel.this.pixPane);
                ImageViewPanel.this.fullscreenMode = true;
                device.setFullScreenWindow(ImageViewPanel.this.fullFrame);
                MyKeyEventDispatcher dispatcher = new MyKeyEventDispatcher();
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(dispatcher);
            }
        };
        BAMutil.setActionProperties(fullscreenAction, "Export", "fullscreen", true, 78, -1);
        BAMutil.addActionToContainer(buttPanel, fullscreenAction);
    }

    private void resetPane() {
        this.add((Component)this.pixPane, "Center");
        this.revalidate();
    }

    public void setImageFromGrid(GridDatatype grid) {
        try {
            BufferedImage image = this.imageDatasetFactory.openDataset(grid);
            this.setImage(image);
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(null, "Error on dataset\n" + this.imageDatasetFactory.getErrorMessages());
            e2.printStackTrace();
        }
    }

    public boolean setImageFromUrl(String location) {
        this.location = location;
        if (location.startsWith("http")) {
            URL url;
            try {
                url = new URL(location);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return false;
            }
            this.pixPane.setPicture(url, "legendParam", 0.0);
        } else {
            try {
                BufferedImage image = this.imageDatasetFactory.open(location);
                if (image == null) {
                    JOptionPane.showMessageDialog(null, "Cant open dataset as image = " + location + "\n" + this.imageDatasetFactory.getErrorMessages());
                    return false;
                }
                this.setImage(image);
            }
            catch (Exception e2) {
                JOptionPane.showMessageDialog(null, "Error on dataset = " + location + "\n" + this.imageDatasetFactory.getErrorMessages());
                e2.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void setImage(BufferedImage im) {
        if (im == null) {
            return;
        }
        if (debug) {
            System.out.println("ImageViewPanel setImage ");
        }
        this.pixPane.setBufferedImage(im, "setImage");
        this.pixPane.repaint();
    }

    private class MyKeyEventDispatcher
    implements KeyEventDispatcher {
        private MyKeyEventDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            System.out.printf(" dispatchKeyEvent=%s code = %d %n", e, e.getKeyCode());
            if (e.getKeyCode() == 127) {
                ImageViewPanel.this.imageFactoryRandom.delete();
                return false;
            }
            if (ImageViewPanel.this.fullscreenMode) {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice device = ge.getDefaultScreenDevice();
                device.setFullScreenWindow(null);
                ImageViewPanel.this.fullscreenMode = false;
            }
            ImageViewPanel.this.resetPane();
            if (ImageViewPanel.this.fullFrame != null) {
                ImageViewPanel.this.fullFrame.dispose();
            }
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
            return false;
        }
    }
}

