/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.menu;

import com.google.common.collect.ImmutableList;
import java.awt.event.ActionEvent;
import java.util.Formatter;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ui.ToolsUI;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.PLAF;
import ucar.unidata.io.RandomAccessFile;

public class SystemMenu
extends JMenu {
    private ToolsUI toolsui;
    private static boolean isCacheInit;

    public SystemMenu(ToolsUI tui) {
        super("System");
        this.setMnemonic('S');
        this.toolsui = tui;
        AbstractAction clearHttpStateAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        BAMutil.setActionProperties(clearHttpStateAction, null, "Clear Http State", false, 83, -1);
        BAMutil.addActionToMenu(this, clearHttpStateAction);
        AbstractAction showCacheAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                f.format("RandomAccessFileCache contents%n", new Object[0]);
                FileCacheIF rafCache = RandomAccessFile.getGlobalFileCache();
                if (null != rafCache) {
                    rafCache.showCache(f);
                }
                f.format("%nNetcdfFileCache contents%n", new Object[0]);
                FileCacheIF cache = NetcdfDataset.getNetcdfFileCache();
                if (null != cache) {
                    cache.showCache(f);
                }
                SystemMenu.this.toolsui.getDatasetViewerPanel().setText(f.toString());
                SystemMenu.this.toolsui.getDatasetViewerPanel().getDetailWindow().show();
            }
        };
        BAMutil.setActionProperties(showCacheAction, null, "Show Caches", false, 83, -1);
        BAMutil.addActionToMenu(this, showCacheAction);
        AbstractAction clearRafCacheAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileCacheIF rafCache = RandomAccessFile.getGlobalFileCache();
                if (rafCache != null) {
                    rafCache.clearCache(true);
                }
            }
        };
        BAMutil.setActionProperties(clearRafCacheAction, null, "Clear RandomAccessFileCache", false, 67, -1);
        BAMutil.addActionToMenu(this, clearRafCacheAction);
        AbstractAction clearCacheAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileCacheIF cache = NetcdfDataset.getNetcdfFileCache();
                if (cache != null) {
                    cache.clearCache(true);
                }
            }
        };
        BAMutil.setActionProperties(clearCacheAction, null, "Clear NetcdfDatasetCache", false, 67, -1);
        BAMutil.addActionToMenu(this, clearCacheAction);
        AbstractAction enableCache = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                if (state == isCacheInit) {
                    return;
                }
                isCacheInit = state;
                if (isCacheInit) {
                    FileCacheIF cache = NetcdfDataset.getNetcdfFileCache();
                    if (cache != null) {
                        cache.enable();
                    } else {
                        NetcdfDataset.initNetcdfFileCache(10, 20, 600);
                    }
                } else {
                    FileCacheIF cache = NetcdfDataset.getNetcdfFileCache();
                    if (cache != null) {
                        cache.disable();
                    }
                }
            }
        };
        BAMutil.setActionPropertiesToggle(enableCache, null, "Enable NetcdfDatasetCache", isCacheInit, 78, -1);
        BAMutil.addActionToMenu(this, enableCache);
        AbstractAction showPropertiesAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemMenu.this.toolsui.getDatasetViewerPanel().setText("System Properties\n");
                Properties sysp = System.getProperties();
                Set<String> eprops = sysp.stringPropertyNames();
                ImmutableList<String> list = ImmutableList.copyOf(eprops);
                for (Object e2 : list) {
                    String name = (String)e2;
                    String value = System.getProperty(name);
                    SystemMenu.this.toolsui.getDatasetViewerPanel().appendLine("  " + name + " = " + value);
                }
                SystemMenu.this.toolsui.getDatasetViewerPanel().getDetailWindow().show();
            }
        };
        BAMutil.setActionProperties(showPropertiesAction, null, "System Properties", false, 80, -1);
        BAMutil.addActionToMenu(this, showPropertiesAction);
        this.addPlafSubmenu();
        AbstractAction exitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolsUI.exit();
            }
        };
        BAMutil.setActionProperties(exitAction, "Exit", "Exit", false, 88, -1);
        BAMutil.addActionToMenu(this, exitAction);
    }

    private void addPlafSubmenu() {
        JMenu plafMenu = new JMenu("Look and Feel");
        plafMenu.setMnemonic('L');
        PLAF plaf = new PLAF(this.toolsui);
        plaf.addToMenu(plafMenu);
        this.add(plafMenu);
    }
}

