/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import ucar.nc2.iosp.bufr.tables.CodeFlagTables;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class BufrWmoCodesPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable codeTable;
    private BeanTable entryTable;
    private JSplitPane split;
    private TextHistoryPane compareTA;
    private IndependentWindow infoWindow;

    public BufrWmoCodesPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.codeTable = new BeanTable<CodeTableBean>(CodeTableBean.class, (PreferencesExt)prefs.node("CodeTableBean"), false);
        this.codeTable.addListSelectionListener(e -> {
            CodeTableBean csb = (CodeTableBean)this.codeTable.getSelectedBean();
            this.setEntries(csb.code);
        });
        PopupMenu varPopup = new PopupMenu(this.codeTable.getJTable(), "Options");
        varPopup.addAction("Show table", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter out = new Formatter();
                CodeTableBean csb = (CodeTableBean)BufrWmoCodesPanel.this.codeTable.getSelectedBean();
                csb.showTable(out);
                BufrWmoCodesPanel.this.compareTA.setText(out.toString());
                BufrWmoCodesPanel.this.compareTA.gotoTop();
                BufrWmoCodesPanel.this.infoWindow.setVisible(true);
            }
        });
        this.entryTable = new BeanTable<EntryBean>(EntryBean.class, (PreferencesExt)prefs.node("EntryBean"), false);
        Map<Short, CodeFlagTables> tables = CodeFlagTables.getTables();
        ArrayList<CodeTableBean> beans = new ArrayList<CodeTableBean>(tables.size());
        ArrayList<Short> list = new ArrayList<Short>(tables.keySet());
        Collections.sort(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            short key = (Short)iterator.next();
            beans.add(new CodeTableBean(tables.get(key)));
        }
        this.codeTable.setBeans(beans);
        this.compareTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("nj22/NetcdfUI"), this.compareTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 800, 600)));
        this.split = new JSplitPane(0, false, this.codeTable, this.entryTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.codeTable.saveState(false);
        this.entryTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public void setEntries(CodeFlagTables codeTable) {
        Map<Integer, String> map = codeTable.getMap();
        ArrayList<EntryBean> beans = new ArrayList<EntryBean>(map.size());
        ArrayList<Integer> list = new ArrayList<Integer>(map.keySet());
        Collections.sort(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            beans.add(new EntryBean(key, map.get(key)));
        }
        this.entryTable.setBeans(beans);
    }

    public static class EntryBean {
        int code;
        String value;

        public EntryBean(int code, String value) {
            this.code = code;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static class CodeTableBean {
        CodeFlagTables code;

        public CodeTableBean() {
        }

        public CodeTableBean(CodeFlagTables code) {
            this.code = code;
        }

        public String getName() {
            return this.code.getName();
        }

        public String getFxy() {
            return this.code.fxy();
        }

        public short getId() {
            return this.code.getId();
        }

        public int getSize() {
            return this.code.getMap().size();
        }

        void showTable(Formatter f) {
            f.format("Code Table %s (%s)%n", this.code.getName(), this.code.fxy());
            Map<Integer, String> map = this.code.getMap();
            for (int key : map.keySet()) {
                f.format("  %3d: %s%n", key, map.get(key));
            }
        }
    }
}

