/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JSplitPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileSubclass;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.jni.netcdf.Nc4Iosp;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.ToolsUI;
import ucar.nc2.ui.op.DatasetViewer;
import ucar.ui.widget.BAMutil;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class DatasetViewerPanel
extends OpPanel {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private DatasetViewer dsViewer;
    private JSplitPane split;
    private NetcdfFile ncfile;
    private boolean jni;

    public DatasetViewerPanel(PreferencesExt dbPrefs, boolean jni) {
        super(dbPrefs, "dataset:");
        this.jni = jni;
        this.dsViewer = new DatasetViewer(dbPrefs, fileChooser);
        this.add((Component)this.dsViewer, "Center");
        AbstractButton infoButton = BAMutil.makeButtcon("Information", "Detail Info", false);
        infoButton.addActionListener(e -> {
            if (this.ncfile != null) {
                this.detailTA.setText(this.ncfile.getDetailInfo());
                this.detailTA.gotoTop();
                this.detailWindow.show();
            }
        });
        this.buttPanel.add(infoButton);
        AbstractAction dumpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetcdfFile ds = DatasetViewerPanel.this.dsViewer.getDataset();
                if (ds != null) {
                    logger.debug("setNCdumpPanel");
                    ToolsUI.setNCdumpPanel(ds);
                }
            }
        };
        BAMutil.setActionProperties(dumpAction, "Dump", "NCDump", false, 68, -1);
        BAMutil.addActionToContainer(this.buttPanel, dumpAction);
        this.dsViewer.addActions(this.buttPanel);
    }

    @Override
    public boolean process(Object o) {
        String location = (String)o;
        boolean err = false;
        try {
            if (this.ncfile != null) {
                this.ncfile.close();
            }
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        try {
            NetcdfFile ncnew;
            if (this.jni) {
                Nc4Iosp iosp = new Nc4Iosp(NetcdfFileWriter.Version.netcdf4);
                ncnew = new NetcdfFileSubclass(iosp, location);
                RandomAccessFile raf = new RandomAccessFile(location, "r");
                iosp.open(raf, ncnew, null);
            } else {
                ncnew = ToolsUI.getToolsUI().openFile(location, this.addCoords, null);
            }
            if (ncnew != null) {
                this.setDataset(ncnew);
            }
        }
        catch (Exception ioe) {
            StringWriter sw = new StringWriter(5000);
            ioe.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            err = true;
        }
        return !err;
    }

    @Override
    public void closeOpenFiles() throws IOException {
        if (this.ncfile != null) {
            this.ncfile.close();
        }
        this.ncfile = null;
        this.dsViewer.clear();
    }

    public void setDataset(NetcdfFile nc) {
        try {
            if (this.ncfile != null) {
                this.ncfile.close();
            }
            this.ncfile = null;
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        this.ncfile = nc;
        if (nc != null) {
            this.dsViewer.setDataset(nc);
            this.setSelectedItem(nc.getLocation());
        }
    }

    @Override
    public void save() {
        super.save();
        this.dsViewer.save();
    }

    public void setText(String text) {
        this.detailTA.setText(text);
    }

    public void appendLine(String text) {
        this.detailTA.appendLine(text);
    }
}

