/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.simplegeom;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDatasetInfo;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.ui.geoloc.CursorMoveEvent;
import ucar.nc2.ui.geoloc.CursorMoveEventListener;
import ucar.nc2.ui.geoloc.NavigatedPanel;
import ucar.nc2.ui.geoloc.NewMapAreaEvent;
import ucar.nc2.ui.geoloc.NewMapAreaListener;
import ucar.nc2.ui.geoloc.NewProjectionEvent;
import ucar.nc2.ui.geoloc.NewProjectionListener;
import ucar.nc2.ui.geoloc.PickEvent;
import ucar.nc2.ui.geoloc.PickEventListener;
import ucar.nc2.ui.grid.ColorScale;
import ucar.nc2.ui.grid.GridRenderer;
import ucar.nc2.ui.grid.VertPanel;
import ucar.nc2.ui.simplegeom.SimpleGeomUI;
import ucar.nc2.ui.util.Renderer;
import ucar.nc2.ui.widget.ScaledPanel;
import ucar.nc2.util.NamedObject;
import ucar.ui.event.ActionCoordinator;
import ucar.ui.event.ActionSourceListener;
import ucar.ui.event.ActionValueEvent;
import ucar.ui.prefs.Debug;
import ucar.ui.widget.BAMutil;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.util.prefs.PreferencesExt;

public class SimpleGeomController {
    private static final Logger log = LoggerFactory.getLogger(SimpleGeomController.class);
    private static final int DELAY_DRAW_AFTER_DATA_EVENT = 250;
    private static final String LastMapAreaName = "LastMapArea";
    private static final String LastProjectionName = "LastProjection";
    private static final String LastDatasetName = "LastDataset";
    private static final String ColorScaleName = "ColorScale";
    private PreferencesExt store;
    private SimpleGeomUI ui;
    private ColorScale cs;
    private NavigatedPanel np;
    private VertPanel vertPanel;
    private ProjectionImpl project;
    private String datasetUrlString;
    private NetcdfDataset netcdfDataset;
    private GridDataset gridDataset;
    private GridDatatype currentField;
    private List<NamedObject> levelNames;
    private List<NamedObject> timeNames;
    private List<NamedObject> ensembleNames;
    private List<NamedObject> runtimeNames;
    private int currentLevel;
    private int currentSlice;
    private int currentTime;
    private int currentEnsemble;
    private int currentRunTime;
    boolean drawHorizOn = true;
    boolean drawVertOn;
    private boolean hasDependentTimeAxis;
    private AffineTransform atI = new AffineTransform();
    private Renderer renderMap;
    public GridRenderer renderGrid;
    private Timer redrawTimer;
    private Color mapColor = Color.black;
    private JLabel dataValueLabel;
    private JLabel posLabel;
    AbstractAction dataProjectionAction;
    AbstractAction showGridAction;
    AbstractAction showContoursAction;
    AbstractAction showContourLabelsAction;
    AbstractAction drawHorizAction;
    AbstractAction drawVertAction;
    JSpinner strideSpinner;
    private ActionSourceListener levelSource;
    private boolean eventsOK = true;
    private boolean startOK;
    private ProjectionPointImpl projPoint = new ProjectionPointImpl();
    private final boolean debugThread = false;

    public SimpleGeomController(SimpleGeomUI ui, PreferencesExt store) {
        this.ui = ui;
        this.store = store;
        Object bean = store.getBean(ColorScaleName, null);
        this.cs = !(bean instanceof ColorScale) ? new ColorScale("default") : (ColorScale)store.getBean(ColorScaleName, null);
        this.renderGrid = new GridRenderer();
        this.renderGrid.setColorScale(this.cs);
        this.strideSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
        this.strideSpinner.addChangeListener(e -> {
            Integer val = (Integer)this.strideSpinner.getValue();
            this.renderGrid.setHorizStride(val);
        });
        this.redrawTimer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SimpleGeomController.this.draw(false);
                    }
                });
                SimpleGeomController.this.redrawTimer.stop();
            }
        });
        this.redrawTimer.setInitialDelay(250);
        this.redrawTimer.setRepeats(false);
        this.makeActions();
    }

    void finishInit() {
        ProjectionRect ma;
        this.np = this.ui.panz;
        this.vertPanel = this.ui.vertPanel;
        this.dataValueLabel = this.ui.dataValueLabel;
        this.posLabel = this.ui.positionLabel;
        this.project = (ProjectionImpl)this.store.getBean(LastProjectionName, null);
        if (this.project != null) {
            this.setProjection(this.project);
        }
        if ((ma = (ProjectionRect)this.store.getBean(LastMapAreaName, null)) != null) {
            this.np.setMapArea(ma);
        }
        this.makeEventManagement();
    }

    void start(boolean ok) {
        this.startOK = ok;
        this.renderGrid.makeStridedGrid();
    }

    private void makeActions() {
        this.dataProjectionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectionImpl dataProjection = SimpleGeomController.this.renderGrid.getDataProjection();
                if (null != dataProjection) {
                    SimpleGeomController.this.setProjection(dataProjection);
                }
            }
        };
        BAMutil.setActionProperties(this.dataProjectionAction, "DataProjection", "use Data Projection", false, 68, 0);
        this.drawHorizAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleGeomController.this.drawHorizOn = (Boolean)this.getValue("state");
                SimpleGeomController.this.ui.setDrawHorizAndVert(SimpleGeomController.this.drawHorizOn, SimpleGeomController.this.drawVertOn);
                SimpleGeomController.this.draw(false);
            }
        };
        BAMutil.setActionProperties(this.drawHorizAction, "nj22/DrawHoriz", "draw horizontal", true, 72, 0);
        boolean state = this.store.getBoolean("drawHorizAction", true);
        this.drawHorizAction.putValue("state", state);
        this.drawHorizOn = state;
        this.drawVertAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleGeomController.this.drawVertOn = (Boolean)this.getValue("state");
                SimpleGeomController.this.ui.setDrawHorizAndVert(SimpleGeomController.this.drawHorizOn, SimpleGeomController.this.drawVertOn);
                SimpleGeomController.this.draw(false);
            }
        };
        BAMutil.setActionProperties(this.drawVertAction, "nj22/DrawVert", "draw vertical", true, 86, 0);
        state = this.store.getBoolean("drawVertAction", false);
        this.drawVertAction.putValue("state", state);
        this.drawVertOn = state;
        this.showGridAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                SimpleGeomController.this.renderGrid.setDrawGridLines(state);
                SimpleGeomController.this.draw(false);
            }
        };
        BAMutil.setActionProperties(this.showGridAction, "nj22/Grid", "show grid lines", true, 71, 0);
        state = this.store.getBoolean("showGridAction", false);
        this.showGridAction.putValue("state", state);
        this.renderGrid.setDrawGridLines(state);
        this.showContoursAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                SimpleGeomController.this.renderGrid.setDrawContours(state);
                SimpleGeomController.this.draw(false);
            }
        };
        BAMutil.setActionProperties(this.showContoursAction, "nj22/Contours", "show contours", true, 67, 0);
        state = this.store.getBoolean("showContoursAction", false);
        this.showContoursAction.putValue("state", state);
        this.renderGrid.setDrawContours(state);
        this.showContourLabelsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                SimpleGeomController.this.renderGrid.setDrawContourLabels(state);
                SimpleGeomController.this.draw(false);
            }
        };
        BAMutil.setActionProperties(this.showContourLabelsAction, "nj22/ContourLabels", "show contour labels", true, 76, 0);
        state = this.store.getBoolean("showContourLabelsAction", false);
        this.showContourLabelsAction.putValue("state", state);
        this.renderGrid.setDrawContourLabels(state);
    }

    private void makeEventManagement() {
        String actionName = "field";
        ActionCoordinator fieldCoordinator = new ActionCoordinator(actionName);
        fieldCoordinator.addActionSourceListener(this.ui.fieldChooser.getActionSourceListener());
        fieldCoordinator.addActionSourceListener(this.ui.gridTable.getActionSourceListener());
        ActionSourceListener fieldSource = new ActionSourceListener(actionName){

            @Override
            public void actionPerformed(ActionValueEvent e) {
                if (SimpleGeomController.this.setField(e.getValue())) {
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        SimpleGeomController.this.draw(true);
                    } else {
                        SimpleGeomController.this.redrawLater();
                    }
                }
            }
        };
        fieldCoordinator.addActionSourceListener(fieldSource);
        actionName = "level";
        ActionCoordinator levelCoordinator = new ActionCoordinator(actionName);
        levelCoordinator.addActionSourceListener(this.ui.levelChooser.getActionSourceListener());
        levelCoordinator.addActionSourceListener(this.ui.vertPanel.getActionSourceListener());
        this.vertPanel.getDrawArea().addPickEventListener(new PickEventListener(){

            @Override
            public void actionPerformed(PickEvent e) {
                int level = SimpleGeomController.this.renderGrid.findLevelCoordElement(e.getLocation().getY());
                if (level != -1 && level != SimpleGeomController.this.currentLevel) {
                    SimpleGeomController.this.currentLevel = level;
                    SimpleGeomController.this.redrawLater();
                    String selectedName = ((NamedObject)SimpleGeomController.this.levelNames.get(SimpleGeomController.this.currentLevel)).getName();
                    if (Debug.isSet("pick/event")) {
                        System.out.println("pick.event Vert: " + selectedName);
                    }
                    SimpleGeomController.this.levelSource.fireActionValueEvent("selected", selectedName);
                }
            }
        });
        this.levelSource = new ActionSourceListener(actionName){

            @Override
            public void actionPerformed(ActionValueEvent e) {
                int level = SimpleGeomController.this.findIndexFromName(SimpleGeomController.this.levelNames, e.getValue().toString());
                if (level != -1 && level != SimpleGeomController.this.currentLevel) {
                    SimpleGeomController.this.currentLevel = level;
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        SimpleGeomController.this.draw(true);
                    } else {
                        SimpleGeomController.this.redrawLater();
                    }
                }
            }
        };
        levelCoordinator.addActionSourceListener(this.levelSource);
        actionName = "time";
        ActionCoordinator timeCoordinator = new ActionCoordinator(actionName);
        timeCoordinator.addActionSourceListener(this.ui.timeChooser.getActionSourceListener());
        ActionSourceListener timeSource = new ActionSourceListener(actionName){

            @Override
            public void actionPerformed(ActionValueEvent e) {
                int time = SimpleGeomController.this.findIndexFromName(SimpleGeomController.this.timeNames, e.getValue().toString());
                if (time != -1 && time != SimpleGeomController.this.currentTime) {
                    SimpleGeomController.this.currentTime = time;
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        SimpleGeomController.this.draw(true);
                    } else {
                        SimpleGeomController.this.redrawLater();
                    }
                }
            }
        };
        timeCoordinator.addActionSourceListener(timeSource);
        actionName = "runtime";
        ActionCoordinator runtimeCoordinator = new ActionCoordinator(actionName);
        runtimeCoordinator.addActionSourceListener(this.ui.runtimeChooser.getActionSourceListener());
        ActionSourceListener runtimeSource = new ActionSourceListener(actionName){

            @Override
            public void actionPerformed(ActionValueEvent e) {
                int runtime = SimpleGeomController.this.findIndexFromName(SimpleGeomController.this.runtimeNames, e.getValue().toString());
                if (runtime != -1 && runtime != SimpleGeomController.this.currentRunTime) {
                    SimpleGeomController.this.currentRunTime = runtime;
                    if (SimpleGeomController.this.hasDependentTimeAxis) {
                        GridCoordSystem gcs = SimpleGeomController.this.currentField.getCoordinateSystem();
                        if (gcs != null) {
                            CoordinateAxis1DTime taxis = gcs.getTimeAxisForRun(runtime);
                            if (taxis != null) {
                                SimpleGeomController.this.timeNames = taxis.getNames();
                            } else {
                                SimpleGeomController.this.timeNames = Collections.emptyList();
                            }
                        }
                        ((SimpleGeomController)SimpleGeomController.this).ui.timeChooser.setCollection(SimpleGeomController.this.timeNames.iterator(), true);
                        if (SimpleGeomController.this.currentTime >= SimpleGeomController.this.timeNames.size()) {
                            SimpleGeomController.this.currentTime = 0;
                        }
                        ((SimpleGeomController)SimpleGeomController.this).ui.timeChooser.setSelectedByIndex(SimpleGeomController.this.currentTime);
                    }
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        SimpleGeomController.this.draw(true);
                    } else {
                        SimpleGeomController.this.redrawLater();
                    }
                }
            }
        };
        runtimeCoordinator.addActionSourceListener(runtimeSource);
        actionName = "ensemble";
        ActionCoordinator ensembleCoordinator = new ActionCoordinator(actionName);
        ensembleCoordinator.addActionSourceListener(this.ui.ensembleChooser.getActionSourceListener());
        ActionSourceListener ensembleSource = new ActionSourceListener(actionName){

            @Override
            public void actionPerformed(ActionValueEvent e) {
                int ensIndex = SimpleGeomController.this.findIndexFromName(SimpleGeomController.this.ensembleNames, e.getValue().toString());
                if (ensIndex != -1 && ensIndex != SimpleGeomController.this.currentEnsemble) {
                    SimpleGeomController.this.currentEnsemble = ensIndex;
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        SimpleGeomController.this.draw(true);
                    } else {
                        SimpleGeomController.this.redrawLater();
                    }
                }
            }
        };
        ensembleCoordinator.addActionSourceListener(ensembleSource);
        this.np.addNewProjectionListener(new NewProjectionListener(){

            @Override
            public void actionPerformed(NewProjectionEvent e) {
                if (Debug.isSet("event/NewProjection")) {
                    System.out.println("Controller got NewProjectionEvent " + SimpleGeomController.this.np.getMapArea());
                }
                if (SimpleGeomController.this.eventsOK && SimpleGeomController.this.renderMap != null) {
                    SimpleGeomController.this.renderMap.setProjection(e.getProjection());
                    SimpleGeomController.this.renderGrid.setProjection(e.getProjection());
                    SimpleGeomController.this.drawH(false);
                }
            }
        });
        this.np.addNewMapAreaListener(new NewMapAreaListener(){

            @Override
            public void actionPerformed(NewMapAreaEvent e) {
                if (Debug.isSet("event/NewMapArea")) {
                    System.out.println("Controller got NewMapAreaEvent " + SimpleGeomController.this.np.getMapArea());
                }
                SimpleGeomController.this.drawH(false);
            }
        });
        this.np.addPickEventListener(new PickEventListener(){

            @Override
            public void actionPerformed(PickEvent e) {
                SimpleGeomController.this.projPoint.setLocation(e.getLocation());
                int slice = SimpleGeomController.this.renderGrid.findSliceFromPoint(SimpleGeomController.this.projPoint);
                if (Debug.isSet("pick/event")) {
                    System.out.println("pick.event: " + SimpleGeomController.this.projPoint + " " + slice);
                }
                if (slice >= 0 && slice != SimpleGeomController.this.currentSlice) {
                    SimpleGeomController.this.currentSlice = slice;
                    SimpleGeomController.this.vertPanel.setSlice(SimpleGeomController.this.currentSlice);
                    SimpleGeomController.this.redrawLater();
                }
            }
        });
        this.np.addCursorMoveEventListener(new CursorMoveEventListener(){

            @Override
            public void actionPerformed(CursorMoveEvent e) {
                SimpleGeomController.this.projPoint.setLocation(e.getLocation());
                String valueS = SimpleGeomController.this.renderGrid.getXYvalueStr(SimpleGeomController.this.projPoint);
                SimpleGeomController.this.dataValueLabel.setText(valueS);
            }
        });
        this.vertPanel.getDrawArea().addCursorMoveEventListener(new CursorMoveEventListener(){

            @Override
            public void actionPerformed(CursorMoveEvent e) {
                Point2D loc = e.getLocationPoint();
                SimpleGeomController.this.posLabel.setText(SimpleGeomController.this.renderGrid.getYZpositionStr(loc));
                SimpleGeomController.this.dataValueLabel.setText(SimpleGeomController.this.renderGrid.getYZvalueStr(loc));
            }
        });
        this.vertPanel.getDrawArea().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SimpleGeomController.this.draw(false);
            }
        });
    }

    String getDatasetName() {
        return null == this.gridDataset ? null : this.gridDataset.getTitle();
    }

    String getDatasetUrlString() {
        return this.datasetUrlString;
    }

    String getDatasetXML() {
        if (this.gridDataset == null) {
            return "";
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            GridDatasetInfo info = new GridDatasetInfo(this.gridDataset, "path");
            info.writeXML(info.makeDatasetDescription(), bos);
            return bos.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return "";
        }
    }

    String getNcML() {
        if (this.gridDataset == null) {
            return "Null gridset";
        }
        NcMLWriter ncmlWriter = new NcMLWriter();
        Element netcdfElement = ncmlWriter.makeNetcdfElement(this.gridDataset.getNetcdfFile(), null);
        return ncmlWriter.writeToString(netcdfElement);
    }

    NetcdfDataset getNetcdfDataset() {
        return this.netcdfDataset;
    }

    GridDatatype getCurrentField() {
        return this.currentField;
    }

    Array getCurrentHorizDataSlice() {
        return this.renderGrid.getCurrentHorizDataSlice();
    }

    String getDatasetInfo() {
        if (null == this.gridDataset) {
            return "";
        }
        Formatter info = new Formatter();
        this.gridDataset.getDetailInfo(info);
        return info.toString();
    }

    List getFields() {
        if (this.gridDataset == null) {
            return null;
        }
        return this.gridDataset.getGrids();
    }

    public void setGridDataset(GridDataset gridDataset) {
        this.gridDataset = gridDataset;
        this.netcdfDataset = (NetcdfDataset)gridDataset.getNetcdfFile();
        this.datasetUrlString = this.netcdfDataset.getLocation();
        this.startOK = false;
    }

    public void clear() {
        this.gridDataset = null;
        this.netcdfDataset = null;
        this.currentField = null;
        this.renderGrid.clear();
    }

    boolean showDataset() {
        List<GridDatatype> grids = this.gridDataset.getGrids();
        if (grids == null || grids.isEmpty()) {
            JOptionPane.showMessageDialog(null, "No gridded fields in file " + this.gridDataset.getTitle());
            return false;
        }
        this.currentField = grids.get(0);
        this.currentSlice = 0;
        this.currentLevel = 0;
        this.currentTime = 0;
        this.currentEnsemble = 0;
        this.currentRunTime = 0;
        this.eventsOK = false;
        this.renderGrid.setGeoGrid(this.currentField);
        this.ui.setFields(this.gridDataset.getGrids());
        this.setField(this.currentField);
        ProjectionImpl dataProjection = this.currentField.getProjection();
        if (dataProjection != null) {
            this.setProjection(dataProjection);
        }
        this.eventsOK = true;
        return true;
    }

    private boolean setField(Object fld) {
        GridDatatype gg = null;
        if (fld instanceof GridDatatype) {
            gg = (GridDatatype)fld;
        } else if (fld instanceof String) {
            gg = this.gridDataset.findGridDatatype((String)fld);
        }
        if (null == gg) {
            return false;
        }
        this.renderGrid.setGeoGrid(gg);
        this.currentField = gg;
        GridCoordSystem gcs = gg.getCoordinateSystem();
        gcs.setProjectionBoundingBox();
        CoordinateAxis1D vaxis = gcs.getVerticalAxis();
        List<Object> list = this.levelNames = vaxis == null ? new ArrayList() : vaxis.getNames();
        if (this.levelNames == null || this.currentLevel >= this.levelNames.size()) {
            this.currentLevel = 0;
        }
        this.vertPanel.setCoordSys(this.currentField.getCoordinateSystem(), this.currentLevel);
        if (gcs.hasTimeAxis()) {
            CoordinateAxis1DTime taxis = gcs.hasTimeAxis1D() ? gcs.getTimeAxis1D() : gcs.getTimeAxisForRun(0);
            List<Object> list2 = this.timeNames = taxis == null ? new ArrayList() : taxis.getNames();
            if (this.timeNames == null || this.currentTime >= this.timeNames.size()) {
                this.currentTime = 0;
            }
            this.hasDependentTimeAxis = !gcs.hasTimeAxis1D();
        } else {
            this.hasDependentTimeAxis = false;
        }
        CoordinateAxis1D eaxis = gcs.getEnsembleAxis();
        this.ensembleNames = eaxis == null ? new ArrayList() : eaxis.getNames();
        this.currentEnsemble = !this.ensembleNames.isEmpty() ? 0 : -1;
        CoordinateAxis1DTime rtaxis = gcs.getRunTimeAxis();
        this.runtimeNames = rtaxis == null ? new ArrayList() : rtaxis.getNames();
        this.currentRunTime = !this.runtimeNames.isEmpty() ? 0 : -1;
        this.ui.setField(gg);
        return true;
    }

    public int getCurrentLevelIndex() {
        return this.currentLevel;
    }

    public int getCurrentTimeIndex() {
        return this.currentTime;
    }

    public int getCurrentEnsembleIndex() {
        return this.currentEnsemble;
    }

    public int getCurrentRunTimeIndex() {
        return this.currentRunTime;
    }

    private int findIndexFromName(List<NamedObject> list, String name) {
        for (int idx = 0; idx < list.size(); ++idx) {
            NamedObject no = list.get(idx);
            if (!name.equals(no.getName())) continue;
            return idx;
        }
        log.error("findIndexFromName cant find " + name);
        return -1;
    }

    synchronized void draw(boolean immediate) {
        if (!this.startOK) {
            return;
        }
        this.renderGrid.setLevel(this.currentLevel);
        this.renderGrid.setTime(this.currentTime);
        this.renderGrid.setSlice(this.currentSlice);
        this.renderGrid.setEnsemble(this.currentEnsemble);
        this.renderGrid.setRunTime(this.currentRunTime);
        if (this.drawHorizOn) {
            this.drawH(immediate);
        }
        if (this.drawVertOn) {
            this.drawV(immediate);
        }
    }

    private void drawH(boolean immediate) {
        long tookTime;
        if (!this.startOK) {
            return;
        }
        boolean already = this.redrawTimer.isRunning();
        if (already) {
            this.redrawTimer.stop();
        }
        long tstart = System.currentTimeMillis();
        Graphics2D gNP = this.np.getBufferedImageGraphics();
        if (gNP == null) {
            return;
        }
        gNP.setBackground(this.np.getBackgroundColor());
        gNP.fill(gNP.getClipBounds());
        long startTime = System.currentTimeMillis();
        try {
            this.renderGrid.renderPlanView(gNP, this.atI);
        }
        catch (IOException ioe) {
            log.error("Error rendering Grid", ioe);
            JOptionPane.showMessageDialog(null, "Error rendering Grid " + ioe.getMessage());
            return;
        }
        if (Debug.isSet("timing/GridDraw")) {
            tookTime = System.currentTimeMillis() - startTime;
            System.out.println("timing.GridDraw: " + (double)tookTime * 0.001 + " seconds");
        }
        if (this.renderMap != null) {
            startTime = System.currentTimeMillis();
            this.renderMap.draw(gNP, this.atI);
            if (Debug.isSet("timing/MapDraw")) {
                tookTime = System.currentTimeMillis() - startTime;
                System.out.println("timing/MapDraw: " + (double)tookTime * 0.001 + " seconds");
            }
        }
        if (immediate) {
            this.np.drawG();
        } else {
            this.np.repaint();
        }
        gNP.dispose();
        if (Debug.isSet("timing/total")) {
            tookTime = System.currentTimeMillis() - tstart;
            System.out.println("timing.total: " + (double)tookTime * 0.001 + " seconds");
        }
    }

    private void drawV(boolean immediate) {
        if (!this.startOK) {
            return;
        }
        ScaledPanel drawArea = this.vertPanel.getDrawArea();
        Graphics2D gV = drawArea.getBufferedImageGraphics();
        if (gV == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        gV.setBackground(Color.white);
        gV.fill(gV.getClipBounds());
        this.renderGrid.renderVertView(gV, this.atI);
        if (Debug.isSet("timing/GridDrawVert")) {
            long tookTime = System.currentTimeMillis() - startTime;
            System.out.println("timing.GridDrawVert: " + (double)tookTime * 0.001 + " seconds");
        }
        gV.dispose();
        if (immediate) {
            drawArea.drawNow();
        } else {
            drawArea.repaint();
        }
    }

    private synchronized void redrawLater() {
        boolean already = this.redrawTimer.isRunning();
        if (already) {
            this.redrawTimer.restart();
        } else {
            this.redrawTimer.start();
        }
    }

    public ColorScale getColorScale() {
        return this.cs;
    }

    public void setColorScale(ColorScale cs) {
        this.cs = cs;
        this.renderGrid.setColorScale(cs);
        this.redrawLater();
    }

    public void setProjection(ProjectionImpl p) {
        this.project = p;
        if (this.renderMap != null) {
            this.renderMap.setProjection(p);
        }
        this.renderGrid.setProjection(p);
        this.np.setProjectionImpl(p);
        this.redrawLater();
    }

    public void setDataMinMaxType(ColorScale.MinMaxType type) {
        this.renderGrid.setDataMinMaxType(type);
        this.redrawLater();
    }

    void setMapRenderer(Renderer mapRenderer) {
        this.renderMap = mapRenderer;
        mapRenderer.setProjection(this.np.getProjectionImpl());
        mapRenderer.setColor(this.mapColor);
        this.redrawLater();
    }

    public void storePersistentData() {
        this.store.putBeanObject(LastMapAreaName, this.np.getMapArea());
        this.store.putBeanObject(LastProjectionName, this.np.getProjectionImpl());
        if (this.gridDataset != null) {
            this.store.put(LastDatasetName, this.gridDataset.getTitle());
        }
        this.store.putBeanObject(ColorScaleName, this.cs);
        this.store.putBoolean("showGridAction", (Boolean)this.showGridAction.getValue("state"));
        this.store.putBoolean("showContoursAction", (Boolean)this.showContoursAction.getValue("state"));
        this.store.putBoolean("showContourLabelsAction", (Boolean)this.showContourLabelsAction.getValue("state"));
    }
}

