/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.entity.StringEntity;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;
import ucar.nc2.util.IO;
import ucar.unidata.util.Urlencoded;

public class HttpClientManager {
    private static boolean debug;
    private static int timeout;

    public static void init(CredentialsProvider provider, String userAgent) {
        if (provider != null) {
            try {
                HTTPSession.setGlobalCredentialsProvider(provider);
            }
            catch (HTTPException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (userAgent != null) {
            HTTPSession.setGlobalUserAgent(userAgent + "/NetcdfJava/HttpClient");
        } else {
            HTTPSession.setGlobalUserAgent("NetcdfJava/HttpClient");
        }
    }

    @Urlencoded
    public static String getContentAsString(String urlencoded) throws IOException {
        return HttpClientManager.getContentAsString(null, urlencoded);
    }

    /*
     * Loose catch block
     */
    @Deprecated
    @Urlencoded
    public static String getContentAsString(HTTPSession session, String urlencoded) throws IOException {
        HTTPSession useSession = session;
        try {
            if (useSession == null) {
                useSession = HTTPFactory.newSession(urlencoded);
            }
            try (HTTPMethod m3 = HTTPFactory.Get(useSession, urlencoded);){
                m3.execute();
                String string = m3.getResponseAsString();
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (session == null && useSession != null) {
                useSession.close();
            }
        }
    }

    public static int putContent(String urlencoded, String content) throws IOException {
        try (HTTPMethod m3 = HTTPFactory.Put(urlencoded);){
            Optional<String> locationOpt;
            m3.setRequestContent(new StringEntity(content, "application/text", "UTF-8"));
            m3.execute();
            int resultCode = m3.getStatusCode();
            if (resultCode == 302 && (locationOpt = m3.getResponseHeaderValue("location")).isPresent()) {
                String redirectLocation = locationOpt.get();
                resultCode = HttpClientManager.putContent(redirectLocation, content);
            }
            int n = resultCode;
            return n;
        }
    }

    public static String getUrlContentsAsString(String urlencoded, int maxKbytes) throws IOException {
        return HttpClientManager.getUrlContentsAsString(null, urlencoded, maxKbytes);
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public static String getUrlContentsAsString(HTTPSession session, String urlencoded, int maxKbytes) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 27[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String readContents(InputStream is, String charset, int maxKbytes) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1000 * maxKbytes);
        IO.copy(is, bout, 1000 * maxKbytes);
        return bout.toString(charset);
    }

    public static void copyUrlContentsToFile(String urlencoded, File file) throws IOException {
        HttpClientManager.copyUrlContentsToFile(null, urlencoded, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void copyUrlContentsToFile(HTTPSession session, String urlencoded, File file) throws IOException {
        HTTPSession useSession = session;
        try {
            if (useSession == null) {
                useSession = HTTPFactory.newSession(urlencoded);
            }
            HTTPMethod m3 = HTTPFactory.Get(useSession, urlencoded);
            m3.setCompression("gzip,deflate");
            int status = m3.execute();
            if (status != 200) {
                throw new IOException(urlencoded + ": failed status = " + status);
            }
            Optional<String> encodingOpt = m3.getResponseHeaderValue("content-encoding");
            if (encodingOpt.isPresent()) {
                String encoding = encodingOpt.get();
                if ("deflate".equals(encoding)) {
                    BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(m3.getResponseAsStream()), 10000);
                    IO.writeToFile(is, file.getPath());
                    return;
                }
                if ("gzip".equals(encoding)) {
                    BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(m3.getResponseAsStream()), 10000);
                    IO.writeToFile(is, file.getPath());
                    return;
                }
            }
            IO.writeToFile(m3.getResponseAsStream(), file.getPath());
        }
        finally {
            if (session == null && useSession != null) {
                useSession.close();
            }
        }
    }

    public static long appendUrlContentsToFile(String urlencoded, File file, long start, long end) throws IOException {
        return HttpClientManager.appendUrlContentsToFile(null, urlencoded, file, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static long appendUrlContentsToFile(HTTPSession session, String urlencoded, File file, long start, long end) throws IOException {
        long nbytes;
        HTTPSession useSession = session;
        try {
            if (useSession == null) {
                useSession = HTTPFactory.newSession(urlencoded);
            }
            try (HTTPMethod m3 = HTTPFactory.Get(useSession, urlencoded);){
                m3.setCompression("gzip,deflate");
                m3.setRange(start, end);
                int status = m3.execute();
                if (status != 200 && status != 206) {
                    throw new RuntimeException("failed status = " + status);
                }
                Optional<String> encodingOpt = m3.getResponseHeaderValue("content-encoding");
                if (encodingOpt.isPresent()) {
                    String encoding = encodingOpt.get();
                    if ("deflate".equals(encoding)) {
                        BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(m3.getResponseAsStream()), 10000);
                        nbytes = IO.appendToFile(is, file.getPath());
                    } else if ("gzip".equals(encoding)) {
                        BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(m3.getResponseAsStream()), 10000);
                        nbytes = IO.appendToFile(is, file.getPath());
                    }
                }
                nbytes = IO.appendToFile(m3.getResponseAsStream(), file.getPath());
            }
        }
        finally {
            if (session == null && useSession != null) {
                useSession.close();
            }
        }
        return nbytes;
    }
}

