/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import ucar.ui.table.AbstractCellEditor;
import ucar.ui.table.TreeTableModel;
import ucar.ui.table.TreeTableModelAbstract;
import ucar.ui.table.TreeTableModelAdapter;
import ucar.ui.widget.BAMutil;

public class JTreeTable
extends JTable {
    private static Icon openIcon = BAMutil.getIcon("treeOpen", true);
    private static Icon closedIcon = BAMutil.getIcon("treeClosed", true);
    private static Icon leafIcon = BAMutil.getIcon("treeLeaf", true);
    protected TreeTableCellRenderer tree;
    protected TreeTableModelAdapter tableModel;
    protected TreeTableModelAbstract treeModel;
    protected ListToTreeSelectionModelWrapper selectionModel;
    private boolean debug;
    private boolean debugSelection;

    public JTreeTable(TreeTableModelAbstract treeTableModel) {
        this.treeModel = treeTableModel;
        this.tree = new TreeTableCellRenderer(treeTableModel);
        this.tableModel = new TreeTableModelAdapter(treeTableModel, this.tree);
        super.setModel(this.tableModel);
        this.selectionModel = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(this.selectionModel);
        this.setSelectionModel(this.selectionModel.getListSelectionModel());
        this.selectionModel.setSelectionMode(2);
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setAutoCreateColumnsFromModel(false);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
    }

    TreePath[] getSelectionPaths() {
        return this.selectionModel.getSelectionPaths();
    }

    TreePath getSelectionPath() {
        return this.selectionModel.getSelectionPath();
    }

    int setSelectionPath(TreePath path) {
        int rowno = this.tree.getRowForPath(path);
        if (this.debugSelection) {
            System.out.println("  getRowForPath = " + rowno + " " + path);
        }
        if (rowno >= 0) {
            this.setRowSelectionInterval(rowno, rowno);
        }
        if (this.debugSelection) {
            int[] rows;
            for (int row : rows = this.getSelectedRows()) {
                System.out.println("  rowSelection is = " + row);
            }
        }
        return rowno;
    }

    JTree getTree() {
        return this.tree;
    }

    public int incrSelected(boolean increment) {
        int rowno = this.tree.getRowForPath(this.getSelectionPath());
        if (rowno < 0) {
            return -1;
        }
        if (increment && rowno < this.tree.getRowCount() - 1) {
            ++rowno;
        } else if (!increment && rowno > 0) {
            --rowno;
        }
        this.setRowSelectionInterval(rowno, rowno);
        if (this.debug) {
            System.out.println("  incrSelected to " + rowno);
        }
        return rowno;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    public TreePath getPathForRow(int row) {
        return this.tree.getPathForRow(row);
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public void fireDataChanged() {
        Object[] path = new Object[]{this.treeModel.getRoot()};
        this.treeModel.fireTreeStructureChanged(this, path, null, null);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.debug) {
            System.out.println("tableChanged " + this.autoCreateColumnsFromModel);
        }
        super.tableChanged(null);
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min2 = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min2 != -1 && max != -1) {
                        for (int counter = min2; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = JTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                            this.addSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return JTreeTable.this.tree;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                for (int counter = JTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                    if (JTreeTable.this.getColumnClass(counter) != TreeTableModel.class) continue;
                    MouseEvent me = (MouseEvent)e;
                    MouseEvent newME = new MouseEvent(JTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - JTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent(newME);
                    break;
                }
            }
            return false;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
            this.setRootVisible(false);
            this.setShowsRootHandles(false);
            this.setToggleClickCount(1);
            DefaultTreeCellRenderer rend = (DefaultTreeCellRenderer)this.getCellRenderer();
            rend.setOpenIcon(openIcon);
            rend.setClosedIcon(closedIcon);
            rend.setLeafIcon(null);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        @Override
        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != rowHeight) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int x, int y, int w, int h2) {
            super.setBounds(x, 0, w, JTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics g2) {
            g2.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.visibleRow = row;
            return this;
        }
    }
}

