/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.widget;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import ucar.ui.event.ActionSourceListener;
import ucar.ui.event.ActionValueEvent;
import ucar.ui.event.ActionValueListener;
import ucar.ui.prefs.Field;
import ucar.ui.prefs.PrefPanel;
import ucar.ui.widget.HelpWindow;

public class RangeSelector
extends JPanel {
    private static final int SLIDER_RESOLUTION = 1000;
    private String tit;
    private String helpMessage;
    private double minLimit;
    private double maxLimit;
    private double resolution;
    private double minSelect;
    private double maxSelect;
    private int nfracDig;
    private JSlider minSlider;
    private JSlider maxSlider;
    private PrefPanel pp;
    private Field.Double minField;
    private Field.Double maxField;
    private Scale scale;
    private HelpWindow helpWindow;
    private JButton helpButton;
    private ActionSourceListener actionSource;
    private String actionName = "rangeSelection";
    private boolean eventOK = true;
    private int incrY = 1;
    private int currentIdx = -1;
    private static boolean debugEvent;
    private static boolean debugSliderSize;

    public RangeSelector(String title, String min2, String max, String resolutionS, String units, boolean acceptButton, String help, boolean pointOnly) {
        this.tit = title;
        this.minLimit = Double.parseDouble(min2);
        this.maxLimit = Double.parseDouble(max);
        this.helpMessage = help;
        this.nfracDig = Math.max(this.calcFracDigits(min2), this.calcFracDigits(max));
        if (resolutionS != null) {
            this.resolution = Double.parseDouble(resolutionS);
            this.nfracDig = Math.max(this.nfracDig, this.calcFracDigits(resolutionS));
        }
        this.minSelect = this.minLimit;
        this.maxSelect = this.maxLimit;
        this.scale = new Scale(this.minLimit, this.maxLimit, this.resolution);
        JPanel sliderPanel = new JPanel();
        JPanel topPanel = null;
        if (title != null || help != null) {
            topPanel = new JPanel(new BorderLayout());
            JPanel butts = new JPanel();
            if (title != null) {
                topPanel.add("West", new JLabel("  " + title + ":"));
            }
            if (help != null) {
                this.helpButton = new JButton("help");
                this.helpButton.addActionListener(e -> {
                    if (this.helpWindow == null) {
                        this.helpWindow = new HelpWindow(null, "Help on " + this.tit, this.helpMessage);
                    }
                    this.helpWindow.show(this.helpButton);
                });
                butts.add(this.helpButton);
            }
            if (acceptButton) {
                JButton okButton = new JButton("accept");
                okButton.addActionListener(e -> {
                    this.pp.accept();
                    this.sendEvent();
                });
                butts.add(okButton);
                acceptButton = false;
            }
            topPanel.add("East", butts);
        }
        sliderPanel.setLayout(new BoxLayout(sliderPanel, 1));
        sliderPanel.setBorder(new LineBorder(Color.black, 1, true));
        this.minSlider = new JSlider(0, 0, 1000, 0);
        this.maxSlider = new JSlider(0, 0, 1000, 1000);
        Border b = BorderFactory.createEmptyBorder(0, 15, 0, 15);
        this.minSlider.setBorder(b);
        this.maxSlider.setBorder(b);
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.add((Component)new JLabel("    " + this.scale.getMinLabel()), "West");
        labelPanel.add((Component)new JLabel(this.scale.getMaxLabel() + "    "), "East");
        this.pp = new PrefPanel(null, null);
        int col = 0;
        if (pointOnly) {
            this.minField = this.pp.addDoubleField("min", "value", this.minSelect, this.nfracDig, col, 0, null);
            col += 2;
        } else {
            this.minField = this.pp.addDoubleField("min", "min", this.minSelect, this.nfracDig, col, 0, null);
            this.maxField = this.pp.addDoubleField("max", "max", this.maxSelect, this.nfracDig, col += 2, 0, null);
            col += 2;
        }
        this.pp.addComponent(new JLabel(units), col, 0, null);
        this.pp.finish(acceptButton, "East");
        if (topPanel != null) {
            sliderPanel.add(topPanel);
        }
        sliderPanel.add(this.pp);
        if (!pointOnly) {
            sliderPanel.add(this.maxSlider);
        }
        sliderPanel.add(this.minSlider);
        sliderPanel.add(labelPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)sliderPanel, "North");
        this.maxSlider.addChangeListener(e -> {
            double val;
            if (!this.eventOK) {
                return;
            }
            int pos = this.maxSlider.getValue();
            this.maxSelect = val = this.scale.slider2world(pos);
            this.eventOK = false;
            this.maxField.setDouble(this.maxSelect);
            this.eventOK = true;
            if (val < this.minSelect) {
                this.minSlider.setValue(pos);
            }
        });
        this.minSlider.addChangeListener(e -> {
            double val;
            if (!this.eventOK) {
                return;
            }
            int pos = this.minSlider.getValue();
            this.minSelect = val = this.scale.slider2world(pos);
            this.eventOK = false;
            this.minField.setDouble(this.minSelect);
            this.eventOK = true;
            if (val > this.maxSelect && this.maxSlider != null) {
                this.maxSlider.setValue(pos);
            }
        });
        this.minField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (debugEvent) {
                    System.out.println("minField event= " + e.getNewValue() + " " + e.getNewValue().getClass().getName());
                }
                if (!RangeSelector.this.eventOK) {
                    return;
                }
                double val = RangeSelector.this.minField.getDouble();
                if (val >= RangeSelector.this.minLimit && val <= RangeSelector.this.maxLimit) {
                    RangeSelector.this.eventOK = false;
                    RangeSelector.this.minSlider.setValue(RangeSelector.this.scale.world2slider(val));
                    RangeSelector.this.eventOK = true;
                } else {
                    RangeSelector.this.minField.setDouble(RangeSelector.this.minSelect);
                }
            }
        });
        if (this.maxField != null) {
            this.maxField.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (debugEvent) {
                        System.out.println("maxField event= " + e.getNewValue());
                    }
                    if (!RangeSelector.this.eventOK) {
                        return;
                    }
                    double val = RangeSelector.this.maxField.getDouble();
                    if (val >= RangeSelector.this.minLimit && val <= RangeSelector.this.maxLimit) {
                        RangeSelector.this.eventOK = false;
                        RangeSelector.this.maxSlider.setValue(RangeSelector.this.scale.world2slider(val));
                        RangeSelector.this.eventOK = true;
                    } else {
                        RangeSelector.this.maxField.setDouble(RangeSelector.this.maxSelect);
                    }
                }
            });
        }
        this.actionSource = new ActionSourceListener(this.actionName){

            @Override
            public void actionPerformed(ActionValueEvent e) {
                if (debugEvent) {
                    System.out.println(" actionSource event " + e);
                }
            }
        };
    }

    public double getMinSelected() {
        return this.minSelect;
    }

    public double getMaxSelected() {
        return this.maxSelect;
    }

    public String getMinSelectedString() {
        return this.format(this.minSelect);
    }

    public String getMaxSelectedString() {
        return this.format(this.maxSelect);
    }

    public void sendEvent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.out.println("event min= " + RangeSelector.this.minSelect + " max = " + RangeSelector.this.maxSelect);
                RangeSelector.this.actionSource.fireActionValueEvent(RangeSelector.this.actionName, this);
            }
        });
    }

    public void addActionValueListener(ActionValueListener l) {
        this.actionSource.addActionValueListener(l);
    }

    public void removeActionValueListener(ActionValueListener l) {
        this.actionSource.removeActionValueListener(l);
    }

    private int calcFracDigits(String d) {
        int pos = d.indexOf(".");
        if (pos < 0) {
            return 0;
        }
        return d.length() - pos - 1;
    }

    private String format(double val) {
        return String.format("%." + this.nfracDig + "f", val);
    }

    private class Scale {
        private double min;
        private double max;
        private double resolution;
        private double scale;

        Scale(double min2, double max, double resolution) {
            this.min = min2;
            this.max = max;
            this.scale = 1000.0 / (max - min2);
            this.resolution = resolution > 0.0 ? resolution : 1.0 / this.scale;
        }

        private int world2slider(double val) {
            return (int)(this.scale * (val - this.min));
        }

        private double slider2world(int pval) {
            double val = (double)pval / this.scale;
            double floor = Math.floor(val / this.resolution);
            double incr = floor * this.resolution;
            return incr + this.min;
        }

        private String getMinLabel() {
            return RangeSelector.this.format(this.min);
        }

        private String getMaxLabel() {
            return RangeSelector.this.format(this.max);
        }
    }
}

