/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.widget;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.FontUtil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;

public class TextHistoryPane
extends JPanel {
    private static Logger log = LoggerFactory.getLogger(TextHistoryPane.class);
    protected JTextArea ta;
    private FontUtil.StandardFont fontu;
    private int nlines;
    private int removeIncr;
    private int count;
    private int ptSize;
    protected FileManager fileChooser;

    public TextHistoryPane() {
        this(false, 5000, 50, true, true, 14);
    }

    public TextHistoryPane(boolean editable) {
        this(editable, 5000, 50, true, true, 14);
    }

    public TextHistoryPane(boolean editable, int nlines, int removeIncr, boolean popupOK, boolean lineWrap, int ptSize) {
        super(new BorderLayout());
        this.nlines = nlines - 1;
        this.removeIncr = Math.min(nlines - 1, removeIncr - 1);
        this.ta = new JTextArea();
        this.ta.setLineWrap(lineWrap);
        this.ta.setEditable(editable);
        this.fontu = FontUtil.getMonoFont(ptSize);
        this.ta.setFont(this.fontu.getFont());
        if (popupOK) {
            this.ta.addMouseListener(new MyPopupMenu());
        }
        JScrollPane sp = new JScrollPane(this.ta);
        this.add((Component)sp, "Center");
        FileFilter[] filters = new FileFilter[]{new FileManager.HDF5ExtFilter(), new FileManager.NetcdfExtFilter()};
        this.fileChooser = new FileManager(null, null, null, null);
    }

    public void appendLine(String line) {
        if (this.count >= this.nlines) {
            try {
                int remove = Math.max(this.removeIncr, this.count - this.nlines);
                int offset = this.ta.getLineEndOffset(remove);
                this.ta.replaceRange("", 0, offset);
            }
            catch (Exception e) {
                log.error("Problem in TextHistoryPane", e);
            }
            this.count = this.nlines - this.removeIncr;
        }
        this.ta.append(line);
        this.ta.append("\n");
        ++this.count;
        this.ta.setCaretPosition(this.ta.getText().length());
    }

    public void clear() {
        this.ta.setText(null);
    }

    public String getText() {
        return this.ta.getText();
    }

    public void gotoTop() {
        this.ta.setCaretPosition(0);
    }

    public void setText(String text) {
        this.ta.setText(text);
    }

    public void setTextFromStackTrace(Throwable e) {
        try (StringWriter sw = new StringWriter(5000);){
            e.printStackTrace(new PrintWriter(sw));
            this.setText(sw.toString());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public IndependentWindow makeIndependentWindow(String title) {
        return new IW(title, this);
    }

    private static class IW
    extends IndependentWindow {
        private IW(String title, TextHistoryPane ta) {
            super(title, BAMutil.getImage("thredds"), ta);
            this.setSize(700, 700);
            this.setLocation(100, 100);
        }
    }

    private class MyPopupMenu
    extends PopupMenu.PopupTriggerListener
    implements Printable {
        private JPopupMenu popup = new JPopupMenu("Options");
        private JTextField nlinesFld = new JTextField();
        private JTextField ptSizeFld = new JTextField();
        private AbstractAction incrFontAction;
        private AbstractAction decrFontAction;
        private StringTokenizer token;
        private Font newFont;
        private int incrY;

        MyPopupMenu() {
            JPanel nlPan = new JPanel();
            nlPan.add(new JLabel("Number of lines to keep:"));
            nlPan.add(this.nlinesFld);
            this.popup.add(nlPan);
            this.incrFontAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextHistoryPane.this.fontu.incrFontSize();
                    TextHistoryPane.this.ta.setFont(TextHistoryPane.this.fontu.getFont());
                }
            };
            BAMutil.setActionProperties(this.incrFontAction, "FontIncr", "Increase Font Size", false, 43, -1);
            BAMutil.addActionToPopupMenu(this.popup, this.incrFontAction);
            this.decrFontAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextHistoryPane.this.fontu.decrFontSize();
                    TextHistoryPane.this.ta.setFont(TextHistoryPane.this.fontu.getFont());
                }
            };
            BAMutil.setActionProperties(this.decrFontAction, "FontDecr", "Decrease Font Size", false, 45, -1);
            BAMutil.addActionToPopupMenu(this.popup, this.decrFontAction);
            JMenuItem printButt = new JMenuItem("Print");
            this.popup.add(printButt);
            JMenuItem writeButt = new JMenuItem("Write to File");
            this.popup.add(writeButt);
            JMenuItem dissButt = new JMenuItem("Dismiss");
            this.popup.add(dissButt);
            JMenuItem clearButt = new JMenuItem("Clear");
            this.popup.add(clearButt);
            this.nlinesFld.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int numLines = Integer.parseInt(MyPopupMenu.this.nlinesFld.getText());
                    TextHistoryPane.this.nlines = Math.max(numLines - 1, TextHistoryPane.this.removeIncr);
                    MyPopupMenu.this.popup.setVisible(false);
                }
            });
            printButt.addActionListener(new AbstractAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    PrinterJob printJob = PrinterJob.getPrinterJob();
                    PageFormat pf = printJob.defaultPage();
                    MyPopupMenu.this.newFont = FontUtil.getMonoFont(10).getFont();
                    FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(MyPopupMenu.this.newFont);
                    MyPopupMenu.this.incrY = fontMetrics.getAscent() + fontMetrics.getDescent();
                    printJob.setPrintable(MyPopupMenu.this, pf);
                    if (printJob.printDialog()) {
                        try {
                            printJob.print();
                        }
                        catch (Exception PrintException) {
                            PrintException.printStackTrace();
                        }
                        finally {
                            MyPopupMenu.this.popup.setVisible(false);
                        }
                    }
                }
            });
            writeButt.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String filename = TextHistoryPane.this.fileChooser.chooseFilename();
                    if (filename == null) {
                        return;
                    }
                    try {
                        MyPopupMenu.this.writeToFile(TextHistoryPane.this.ta.getText(), new File(filename));
                        JOptionPane.showMessageDialog(null, "Text written to" + filename);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showConfirmDialog(null, "Error writting to" + filename + " " + ioe.getMessage());
                    }
                    MyPopupMenu.this.popup.setVisible(false);
                }
            });
            dissButt.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyPopupMenu.this.popup.setVisible(false);
                }
            });
            clearButt.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextHistoryPane.this.clear();
                    MyPopupMenu.this.popup.setVisible(false);
                }
            });
        }

        private void writeToFile(String contents, File file) throws IOException {
            try (FileOutputStream fout = new FileOutputStream(file);
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fout, StandardCharsets.UTF_8);){
                writer.write(contents);
                writer.flush();
            }
        }

        @Override
        public void showPopup(MouseEvent e) {
            this.nlinesFld.setText("" + (TextHistoryPane.this.nlines + 1));
            this.ptSizeFld.setText("" + TextHistoryPane.this.ptSize);
            this.popup.show(TextHistoryPane.this.ta, e.getX(), e.getY());
        }

        @Override
        public int print(Graphics g2, PageFormat pf, int pi) throws PrinterException {
            if (pi == 0) {
                this.token = new StringTokenizer(TextHistoryPane.this.ta.getText(), "\r\n");
            }
            if (!this.token.hasMoreTokens()) {
                return 1;
            }
            Graphics2D g2d = (Graphics2D)g2;
            g2d.setPaint(Color.black);
            g2d.setFont(this.newFont);
            double xbeg = pf.getImageableX();
            double ywidth = pf.getImageableHeight() + pf.getImageableY();
            for (double y = pf.getImageableY() + (double)this.incrY; this.token.hasMoreTokens() && y < ywidth; y += (double)this.incrY) {
                String toke = this.token.nextToken();
                g2d.drawString(toke, (int)xbeg, (int)y);
            }
            return 0;
        }
    }
}

