/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.ReplicaConsistencyException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.Replica;
import com.sleepycat.je.utilint.PropUtil;
import java.util.concurrent.TimeUnit;

public class TimeConsistencyPolicy
implements ReplicaConsistencyPolicy {
    public static final String NAME = "TimeConsistencyPolicy";
    private final int permissibleLag;
    private final int timeout;

    public TimeConsistencyPolicy(long permissibleLag, TimeUnit permissibleLagUnit, long timeout, TimeUnit timeoutUnit) {
        this.permissibleLag = PropUtil.durationToMillis(permissibleLag, permissibleLagUnit);
        this.timeout = PropUtil.durationToMillis(timeout, timeoutUnit);
    }

    public String getName() {
        return NAME;
    }

    public long getPermissibleLag(TimeUnit unit) {
        return PropUtil.millisToDuration(this.permissibleLag, unit);
    }

    public long getTimeout(TimeUnit unit) {
        return PropUtil.millisToDuration(this.timeout, unit);
    }

    public void ensureConsistency(EnvironmentImpl replicatorImpl) throws InterruptedException, ReplicaConsistencyException {
        RepImpl repImpl = (RepImpl)replicatorImpl;
        Replica replica = repImpl.getRepNode().replica();
        replica.getConsistencyTracker().lagAwait(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.permissibleLag;
        result = 31 * result + this.timeout;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeConsistencyPolicy other = (TimeConsistencyPolicy)obj;
        if (this.permissibleLag != other.permissibleLag) {
            return false;
        }
        return this.timeout == other.timeout;
    }
}

