/*
 * Decompiled with CFR 0.152.
 */
package opendap.util;

import java.util.Enumeration;
import java.util.Hashtable;
import opendap.util.InvalidSwitch;
import opendap.util.OptSwitch;

public class Getopts {
    Hashtable switchtab;
    String[] arglist;
    String progname = null;
    String optarg = null;
    Enumeration optenum = null;
    boolean opterr = true;
    int optind = 0;
    char optopt = '\u0000';
    StringBuilder illegals = new StringBuilder();
    String[] optargv = null;
    String optflags = null;

    public OptSwitch getSwitch(Character sw) {
        return (OptSwitch)this.switchtab.get(sw);
    }

    public String getOption(Character sw) {
        return this.getOption((int)sw.charValue());
    }

    public String getOption(int sw) {
        Character opt = new Character((char)sw);
        return this.getOption(opt);
    }

    public Enumeration swList() {
        return this.switchtab.keys();
    }

    public String[] argList() {
        return this.arglist;
    }

    public Getopts(String flags, String[] args) throws InvalidSwitch {
        this((String)null, flags, args);
    }

    public Getopts(String progname, String flags, String[] args) throws InvalidSwitch {
        this.initialize(progname, flags, args);
    }

    protected void initialize(String progname, String flags, String[] args) throws InvalidSwitch {
        int i;
        String throwstring = progname == null ? "Invalid Getopts switch(s): " : progname + ": Invalid Getopts switch(s): ";
        String usage = "Usage: Getopts(String flags, String args[])or Usage: Getopts(String progname, String flags, String args[])";
        this.progname = progname;
        this.switchtab = new Hashtable(1, 1.0f);
        for (i = 0; i < flags.length(); ++i) {
            char cc = flags.charAt(i);
            Character c = new Character(cc);
            char[] alpha = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
            if (cc == ' ' || cc == '\t' || cc == '\n' || cc == '\r') {
                throw new InvalidSwitch(throwstring + "Spaces not allowed\n" + usage + "\n");
            }
            boolean found = false;
            for (int j = 0; j < alpha.length; ++j) {
                Character ch = new Character(alpha[j]);
                char uc = Character.toUpperCase(ch.charValue());
                if (alpha[j] != cc && uc != cc) continue;
                found = true;
                break;
            }
            if (!found && cc != ':') {
                throw new InvalidSwitch(throwstring + "Invalid Flag Character " + c + "\n");
            }
            if (cc == ':') {
                if (i <= 0) continue;
                char prv = flags.charAt(i - 1);
                if (prv == ':') {
                    throw new InvalidSwitch(throwstring + "Can't have consecutive ':'\n" + usage + "\n");
                }
                Character cp = new Character(prv);
                OptSwitch sw = (OptSwitch)this.switchtab.get(cp);
                sw.SetHasValue(2);
                continue;
            }
            OptSwitch sw = new OptSwitch((int)cc, 1);
            this.switchtab.put(c, sw);
        }
        i = 0;
        while (i < args.length) {
            char cc = args[i].charAt(0);
            if (args[i].equals("--")) {
                this.optind = i + 1;
                break;
            }
            if (cc != '-') {
                this.optind = i;
                break;
            }
            for (int j = 1; j < args[i].length(); ++j) {
                cc = args[i].charAt(j);
                Character fc = new Character(cc);
                OptSwitch cs = (OptSwitch)this.switchtab.get(fc);
                if (cs == null) {
                    if (this.opterr) {
                        throw new InvalidSwitch(throwstring + "invalid switch " + cc + "\n2 Valid switches are: " + flags + "\n" + usage + "\n");
                    }
                    this.illegals.append(cc);
                    continue;
                }
                if (!cs.acceptVal()) {
                    cs.SetVal(true);
                    continue;
                }
                if (j + 1 < args[i].length()) {
                    cs.SetVal(args[i].substring(j + 1));
                    j = args[i].length();
                    continue;
                }
                if (++i >= args.length) {
                    throw new InvalidSwitch(throwstring + "missing value from switch " + cc + "\n1 Valid switches are: " + flags + "\n" + usage + "\n");
                }
                if (args[i].charAt(0) == '-') {
                    throw new InvalidSwitch(throwstring + "missing value from switch " + cc + "\n0 Valid switches are: " + flags + "\n" + usage + "\n");
                }
                cs.SetVal(args[i]);
                j = args[i].length();
            }
            this.optind = i++;
        }
        this.arglist = new String[args.length - i];
        System.arraycopy(args, i, this.arglist, 0, args.length - i);
    }

    public static void main(String[] args) {
        int i;
        String[] args1 = new String[args.length - 1];
        System.arraycopy(args, 1, args1, 0, args.length - 1);
        for (i = 0; i < args.length; ++i) {
            System.out.println("args[" + i + "] : " + args[i]);
        }
        try {
            Getopts opts = new Getopts(args[0], args1);
            Enumeration names = opts.swList();
            i = 0;
            while (names.hasMoreElements()) {
                OptSwitch cs = opts.getSwitch((Character)names.nextElement());
                System.out.println("args[" + i + "] : " + (char)cs.sw + " " + cs.type + " " + cs.set + " " + cs.val);
                ++i;
            }
            String[] argp = opts.argList();
            for (i = 0; i < argp.length; ++i) {
                System.out.println("argv[" + i + "] : " + argp[i]);
            }
        }
        catch (InvalidSwitch e) {
            System.out.print(e);
        }
    }

    public Getopts(String progname, String[] args, String flags) {
        this.progname = progname;
        this.optargv = args;
        this.optflags = flags;
    }

    public int getopt() {
        this.optarg = null;
        this.optopt = '\u0000';
        if (this.optenum == null) {
            try {
                this.initialize(this.progname, this.optflags, this.optargv);
            }
            catch (InvalidSwitch ise) {
                System.err.println("new Getopts: " + ise.getMessage());
            }
            this.optenum = this.swList();
        }
        if (this.optenum.hasMoreElements()) {
            while (this.optenum.hasMoreElements()) {
                Character c = (Character)this.optenum.nextElement();
                OptSwitch sw = this.getSwitch(c);
                if (!sw.set) continue;
                if (sw.acceptVal()) {
                    this.optarg = sw.val;
                }
                return c.charValue();
            }
        } else if (!this.opterr && this.illegals.length() > 0) {
            this.optopt = this.illegals.charAt(0);
            this.illegals.deleteCharAt(0);
            return 63;
        }
        return -1;
    }

    public String getOptarg() {
        return this.optarg;
    }

    public void setOpterr(boolean b) {
        this.opterr = b;
    }

    public int getOptind() {
        return this.optind;
    }

    public int getOptopt() {
        return this.optopt;
    }
}

