/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.AlbersEqualArea;
import ucar.unidata.geoloc.projection.LambertAzimuthalEqualArea;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.TransverseMercator;
import ucar.unidata.geoloc.projection.UtmProjection;

public class M3IOConvention
extends CoordSysBuilder {
    private static final double earthRadius = 6370.0;
    private CoordinateTransform ct = null;

    public static boolean isMine(NetcdfFile ncfile) {
        return null != ncfile.findGlobalAttribute("XORIG") && null != ncfile.findGlobalAttribute("YORIG") && null != ncfile.findGlobalAttribute("XCELL") && null != ncfile.findGlobalAttribute("YCELL") && null != ncfile.findGlobalAttribute("NCOLS") && null != ncfile.findGlobalAttribute("NROWS");
    }

    public M3IOConvention() {
        this.conventionName = "M3IO";
    }

    @Override
    public void augmentDataset(NetcdfDataset ncd, CancelTask cancelTask) {
        if (null != ncd.findVariable("x")) {
            return;
        }
        if (null != ncd.findVariable("lon")) {
            return;
        }
        this.constructCoordAxes(ncd);
        ncd.finish();
    }

    protected void constructCoordAxes(NetcdfDataset ds) {
        boolean isLatLon;
        Dimension dimx = ds.findDimension("COL");
        int nx = dimx.getLength();
        Dimension dimy = ds.findDimension("ROW");
        int ny = dimy.getLength();
        int projType = this.findAttributeInt(ds, "GDTYP");
        boolean bl = isLatLon = projType == 1;
        if (isLatLon) {
            ds.addCoordinateAxis(this.makeCoordLLAxis(ds, "lon", "COL", nx, "XORIG", "XCELL", "degrees east"));
            ds.addCoordinateAxis(this.makeCoordLLAxis(ds, "lat", "ROW", ny, "YORIG", "YCELL", "degrees north"));
            this.ct = this.makeLatLongProjection(ds);
            VariableDS v = this.makeCoordinateTransformVariable(ds, this.ct);
            ds.addVariable(null, v);
            v.addAttribute(new Attribute("_CoordinateAxes", "lon lat"));
        } else {
            ds.addCoordinateAxis(this.makeCoordAxis(ds, "x", "COL", nx, "XORIG", "XCELL", "km"));
            ds.addCoordinateAxis(this.makeCoordAxis(ds, "y", "ROW", ny, "YORIG", "YCELL", "km"));
            if (projType == 2) {
                this.ct = this.makeLCProjection(ds);
            } else if (projType == 3) {
                this.ct = this.makeTMProjection(ds);
            } else if (projType == 4) {
                this.ct = this.makeSTProjection(ds);
            } else if (projType == 5) {
                this.ct = this.makeUTMProjection(ds);
            } else if (projType == 6) {
                this.ct = this.makePolarStereographicProjection(ds);
            } else if (projType == 7) {
                this.ct = this.makeEquitorialMercatorProjection(ds);
            } else if (projType == 8) {
                this.ct = this.makeTransverseMercatorProjection(ds);
            } else if (projType == 9) {
                this.ct = this.makeAlbersProjection(ds);
            } else if (projType == 10) {
                this.ct = this.makeLambertAzimuthalProjection(ds);
            }
            if (this.ct != null) {
                VariableDS v = this.makeCoordinateTransformVariable(ds, this.ct);
                ds.addVariable(null, v);
                v.addAttribute(new Attribute("_CoordinateAxes", "x y"));
            }
        }
        this.makeZCoordAxis(ds, "LAY", "VGLVLS", "sigma");
        this.makeTimeCoordAxis(ds, "TSTEP");
    }

    private CoordinateAxis makeCoordAxis(NetcdfDataset ds, String name, String dimName, int n, String startName, String incrName, String unitName) {
        double start = 0.001 * this.findAttributeDouble(ds, startName);
        double incr = 0.001 * this.findAttributeDouble(ds, incrName);
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, name, DataType.DOUBLE, dimName, unitName, "synthesized coordinate from " + startName + " " + incrName + " global attributes");
        v.setValues(n, start += incr / 2.0, incr);
        return v;
    }

    private CoordinateAxis makeCoordLLAxis(NetcdfDataset ds, String name, String dimName, int n, String startName, String incrName, String unitName) {
        double start = this.findAttributeDouble(ds, startName);
        double incr = this.findAttributeDouble(ds, incrName);
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, name, DataType.DOUBLE, dimName, unitName, "synthesized coordinate from " + startName + " " + incrName + " global attributes");
        v.setValues(n, start, incr);
        return v;
    }

    private void makeZCoordAxis(NetcdfDataset ds, String dimName, String levelsName, String unitName) {
        int i;
        Dimension dimz = ds.findDimension(dimName);
        int nz = dimz.getLength();
        ArrayDouble.D1 dataLev = new ArrayDouble.D1(nz);
        ArrayDouble.D1 dataLayers = new ArrayDouble.D1(nz + 1);
        Attribute layers = ds.findGlobalAttribute("VGLVLS");
        for (i = 0; i <= nz; ++i) {
            dataLayers.set(i, layers.getNumericValue(i).doubleValue());
        }
        for (i = 0; i < nz; ++i) {
            double midpoint = (dataLayers.get(i) + dataLayers.get(i + 1)) / 2.0;
            dataLev.set(i, midpoint);
        }
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, "level", DataType.DOUBLE, dimName, unitName, "synthesized coordinate from " + levelsName + " global attributes");
        v.setCachedData(dataLev, true);
        v.addAttribute(new Attribute("positive", "down"));
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.GeoZ.toString()));
        String edge_name = "layer";
        Dimension lay_edge = new Dimension(edge_name, nz + 1);
        ds.addDimension(null, lay_edge);
        CoordinateAxis1D vedge = new CoordinateAxis1D(ds, null, edge_name, DataType.DOUBLE, edge_name, unitName, "synthesized coordinate from " + levelsName + " global attributes");
        vedge.setCachedData(dataLayers, true);
        v.setBoundaryRef(edge_name);
        ds.addCoordinateAxis(v);
        ds.addCoordinateAxis(vedge);
    }

    private void makeTimeCoordAxis(NetcdfDataset ds, String timeName) {
        int start_date = this.findAttributeInt(ds, "SDATE");
        int start_time = this.findAttributeInt(ds, "STIME");
        int time_step = this.findAttributeInt(ds, "TSTEP");
        int year = start_date / 1000;
        int doy = start_date % 1000;
        int hour = start_time / 10000;
        int min = (start_time %= 10000) / 100;
        int sec = start_time % 100;
        GregorianCalendar cal = new GregorianCalendar(new SimpleTimeZone(0, "GMT"));
        cal.clear();
        cal.set(1, year);
        cal.set(6, doy);
        cal.set(11, hour);
        cal.set(12, min);
        cal.set(13, sec);
        SimpleDateFormat dateFormatOut = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormatOut.setTimeZone(TimeZone.getTimeZone("GMT"));
        String units = "seconds since " + dateFormatOut.format(cal.getTime()) + " UTC";
        hour = time_step / 10000;
        min = (time_step %= 10000) / 100;
        sec = time_step % 100;
        time_step = hour * 3600 + min * 60 + sec;
        Dimension dimt = ds.findDimension(timeName);
        int nt = dimt.getLength();
        ArrayInt.D1 data = new ArrayInt.D1(nt, false);
        for (int i = 0; i < nt; ++i) {
            data.set(i, i * time_step);
        }
        CoordinateAxis1D timeCoord = new CoordinateAxis1D(ds, null, "time", DataType.INT, timeName, units, "synthesized time coordinate from SDATE, STIME, STEP global attributes");
        timeCoord.setCachedData(data, true);
        timeCoord.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        ds.addCoordinateAxis(timeCoord);
    }

    private CoordinateTransform makeLatLongProjection(NetcdfDataset ds) {
        double x1 = this.findAttributeDouble(ds, "XORIG");
        double y1 = this.findAttributeDouble(ds, "YORIG");
        double x2 = x1 + this.findAttributeDouble(ds, "XCELL") * this.findAttributeDouble(ds, "NCOLS");
        double y2 = y1 + this.findAttributeDouble(ds, "YCELL") * this.findAttributeDouble(ds, "NROWS");
        LatLonProjection ll = new LatLonProjection("LatitudeLongitudeProjection", new ProjectionRect(x1, y1, x2, y2));
        return new ProjectionCT("LatitudeLongitudeProjection", "FGDC", ll);
    }

    private CoordinateTransform makeLCProjection(NetcdfDataset ds) {
        double par1 = this.findAttributeDouble(ds, "P_ALP");
        double par2 = this.findAttributeDouble(ds, "P_BET");
        double lon0 = this.findAttributeDouble(ds, "XCENT");
        double lat0 = this.findAttributeDouble(ds, "YCENT");
        LambertConformal lc = new LambertConformal(lat0, lon0, par1, par2, 0.0, 0.0, 6370.0);
        return new ProjectionCT("LambertConformalProjection", "FGDC", lc);
    }

    private CoordinateTransform makePolarStereographicProjection(NetcdfDataset ds) {
        double lon0 = this.findAttributeDouble(ds, "XCENT");
        double lat0 = this.findAttributeDouble(ds, "YCENT");
        double latts = this.findAttributeDouble(ds, "P_BET");
        Stereographic sg = new Stereographic(latts, lat0, lon0, 0.0, 0.0, 6370.0);
        return new ProjectionCT("PolarStereographic", "FGDC", sg);
    }

    private CoordinateTransform makeEquitorialMercatorProjection(NetcdfDataset ds) {
        double lon0 = this.findAttributeDouble(ds, "XCENT");
        double par = this.findAttributeDouble(ds, "P_ALP");
        Mercator p = new Mercator(lon0, par, 0.0, 0.0, 6370.0);
        return new ProjectionCT("EquitorialMercator", "FGDC", p);
    }

    private CoordinateTransform makeTransverseMercatorProjection(NetcdfDataset ds) {
        double lat0 = this.findAttributeDouble(ds, "P_ALP");
        double tangentLon = this.findAttributeDouble(ds, "P_GAM");
        TransverseMercator p = new TransverseMercator(lat0, tangentLon, 1.0, 0.0, 0.0, 6370.0);
        return new ProjectionCT("TransverseMercator", "FGDC", p);
    }

    private CoordinateTransform makeAlbersProjection(NetcdfDataset ds) {
        double lat0 = this.findAttributeDouble(ds, "YCENT");
        double lon0 = this.findAttributeDouble(ds, "XCENT");
        double par1 = this.findAttributeDouble(ds, "P_ALP");
        double par2 = this.findAttributeDouble(ds, "P_BET");
        AlbersEqualArea p = new AlbersEqualArea(lat0, lon0, par1, par2, 0.0, 0.0, 6370.0);
        return new ProjectionCT("Albers", "FGDC", p);
    }

    private CoordinateTransform makeLambertAzimuthalProjection(NetcdfDataset ds) {
        double lat0 = this.findAttributeDouble(ds, "YCENT");
        double lon0 = this.findAttributeDouble(ds, "XCENT");
        LambertAzimuthalEqualArea p = new LambertAzimuthalEqualArea(lat0, lon0, 0.0, 0.0, 6370.0);
        return new ProjectionCT("LambertAzimuthal", "FGDC", p);
    }

    private CoordinateTransform makeSTProjection(NetcdfDataset ds) {
        double lont;
        double latt = this.findAttributeDouble(ds, "PROJ_ALPHA");
        if (Double.isNaN(latt)) {
            latt = this.findAttributeDouble(ds, "P_ALP");
        }
        if (Double.isNaN(lont = this.findAttributeDouble(ds, "PROJ_BETA"))) {
            lont = this.findAttributeDouble(ds, "P_BET");
        }
        Stereographic st = new Stereographic(latt, lont, 1.0, 0.0, 0.0, 6370.0);
        return new ProjectionCT("StereographicProjection", "FGDC", st);
    }

    private CoordinateTransform makeTMProjection(NetcdfDataset ds) {
        double tangentLon;
        double lat0 = this.findAttributeDouble(ds, "PROJ_ALPHA");
        if (Double.isNaN(lat0)) {
            lat0 = this.findAttributeDouble(ds, "P_ALP");
        }
        if (Double.isNaN(tangentLon = this.findAttributeDouble(ds, "PROJ_BETA"))) {
            tangentLon = this.findAttributeDouble(ds, "P_BET");
        }
        TransverseMercator tm = new TransverseMercator(lat0, tangentLon, 1.0, 0.0, 0.0, 6370.0);
        return new ProjectionCT("MercatorProjection", "FGDC", tm);
    }

    private CoordinateTransform makeUTMProjection(NetcdfDataset ds) {
        int zone = (int)this.findAttributeDouble(ds, "P_ALP");
        double ycent = this.findAttributeDouble(ds, "YCENT");
        boolean isNorth = true;
        if (ycent < 0.0) {
            isNorth = false;
        }
        UtmProjection utm = new UtmProjection(zone, isNorth);
        return new ProjectionCT("UTM", "EPSG", utm);
    }

    @Override
    protected AxisType getAxisType(NetcdfDataset ds, VariableEnhanced ve) {
        Variable v = (Variable)((Object)ve);
        String vname = v.getShortName();
        if (vname.equalsIgnoreCase("x")) {
            return AxisType.GeoX;
        }
        if (vname.equalsIgnoreCase("y")) {
            return AxisType.GeoY;
        }
        if (vname.equalsIgnoreCase("lat")) {
            return AxisType.Lat;
        }
        if (vname.equalsIgnoreCase("lon")) {
            return AxisType.Lon;
        }
        if (vname.equalsIgnoreCase("time")) {
            return AxisType.Time;
        }
        if (vname.equalsIgnoreCase("level")) {
            return AxisType.GeoZ;
        }
        return null;
    }

    @Override
    protected void makeCoordinateTransforms(NetcdfDataset ds) {
        CoordSysBuilder.VarProcess vp;
        if (this.ct != null && (vp = this.findVarProcess(this.ct.getName(), null)) != null) {
            vp.ct = this.ct;
        }
        super.makeCoordinateTransforms(ds);
    }

    private double findAttributeDouble(NetcdfDataset ds, String attname) {
        Attribute att = ds.findGlobalAttributeIgnoreCase(attname);
        if (att == null || att.isString()) {
            return Double.NaN;
        }
        return att.getNumericValue().doubleValue();
    }

    private int findAttributeInt(NetcdfDataset ds, String attname) {
        Attribute att = ds.findGlobalAttributeIgnoreCase(attname);
        return att.getNumericValue().intValue();
    }
}

