/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import ucar.nc2.FileWriter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.grib.GribServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class Grib2Netcdf {
    public void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> reads/scans metadata");
        System.out.println("<NetCDF output file> file to store results");
        System.out.println();
        System.out.println("java -Xmx256m " + className + " <GribFileToRead> <NetCDF output file>");
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        Grib2Netcdf func = new Grib2Netcdf();
        if (args.length != 2) {
            Class<?> cl = func.getClass();
            func.usage(cl.getName());
        }
        TimeZone tz = TimeZone.getTimeZone("127");
        TimeZone.setDefault(tz);
        Date now = Calendar.getInstance().getTime();
        System.out.println(now.toString() + " ... Start of Grib2Netcdf");
        System.out.println("read grib file=" + args[0] + " write to netCDF file=" + args[1]);
        try {
            RandomAccessFile raf = new RandomAccessFile(args[0], "r");
            raf.order(0);
            Class<GribServiceProvider> c = GribServiceProvider.class;
            IOServiceProvider iosp = null;
            try {
                iosp = (IOServiceProvider)c.newInstance();
            }
            catch (InstantiationException e) {
                throw new IOException("IOServiceProvider " + c.getName() + "must have no-arg constructor.");
            }
            catch (IllegalAccessException e) {
                throw new IOException("IOServiceProvider " + c.getName() + " IllegalAccessException: " + e.getMessage());
            }
            MakeNetcdfFile ncfile = new MakeNetcdfFile(iosp, raf, args[0], null);
            NetcdfFile nc = FileWriter.writeToFile(ncfile, args[1]);
            nc.close();
            raf.close();
        }
        catch (FileNotFoundException noFileError) {
            System.err.println("FileNotFoundException : " + noFileError);
        }
        catch (IOException ioError) {
            System.err.println("IOException : " + ioError);
        }
        now = Calendar.getInstance().getTime();
        System.out.println(now.toString() + " ... End of Grib2Netcdf!");
    }

    static class MakeNetcdfFile
    extends NetcdfFile {
        MakeNetcdfFile(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
            super(spi, raf, location, cancelTask);
        }
    }
}

