/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public class WriterCFStationCollection
extends CFPointWriter {
    private static final String stationDimName = "station";
    private static final String idName = "station_id";
    private static final String descName = "station_description";
    private static final String wmoName = "wmo_id";
    private static final String stationIndexName = "stationIndex";
    private static final boolean debug = false;
    private int name_strlen = 1;
    private int desc_strlen = 1;
    private int wmo_strlen = 1;
    private List<Dimension> stationDims = new ArrayList<Dimension>(1);
    private boolean useAlt = false;
    private boolean useWmoId = false;
    private HashMap<String, Integer> stationMap;
    private int recno = 0;
    private ArrayDouble.D1 timeArray = new ArrayDouble.D1(1);
    private ArrayInt.D1 parentArray = new ArrayInt.D1(1);
    private int[] origin = new int[1];

    public WriterCFStationCollection(String fileOut, String title) throws IOException {
        this(fileOut, Arrays.asList(new Attribute("title", title)));
    }

    public WriterCFStationCollection(String fileOut, List<Attribute> atts) throws IOException {
        super(fileOut, atts);
        this.ncfile.addGlobalAttribute("featureType", CF.FeatureType.timeSeries.name());
    }

    public void writeHeader(List<Station> stns, List<VariableSimpleIF> vars, DateUnit timeUnit, String altUnits) throws IOException {
        this.altUnits = altUnits;
        this.createStations(stns);
        this.createObsVariables(timeUnit);
        this.createDataVariables(vars);
        this.ncfile.create();
        this.writeStationData(stns);
        if (!((Boolean)this.ncfile.sendIospMessage("AddRecordStructure")).booleanValue()) {
            throw new IllegalStateException("can't add record variable");
        }
    }

    private void createStations(List<Station> stnList) throws IOException {
        int nstns = stnList.size();
        for (Station stn : stnList) {
            if (!Double.isNaN(stn.getAltitude())) {
                this.useAlt = true;
            }
            if (stn.getWmoId() == null || stn.getWmoId().trim().length() <= 0) continue;
            this.useWmoId = true;
        }
        for (Station station : stnList) {
            this.name_strlen = Math.max(this.name_strlen, station.getName().length());
            this.desc_strlen = Math.max(this.desc_strlen, station.getDescription().length());
            if (!this.useWmoId) continue;
            this.wmo_strlen = Math.max(this.wmo_strlen, station.getWmoId().length());
        }
        this.llbb = this.getBoundingBox(stnList);
        this.ncfile.addUnlimitedDimension("obs");
        Dimension stationDim = this.ncfile.addDimension(stationDimName, nstns);
        this.stationDims.add(stationDim);
        Variable v = this.ncfile.addVariable("latitude", DataType.DOUBLE, stationDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("units", "degrees_north"));
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station latitude"));
        v = this.ncfile.addVariable("longitude", DataType.DOUBLE, stationDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("units", "degrees_east"));
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station longitude"));
        if (this.useAlt) {
            v = this.ncfile.addVariable("altitude", DataType.DOUBLE, stationDimName);
            this.ncfile.addVariableAttribute(v, new Attribute("units", "meters"));
            this.ncfile.addVariableAttribute(v, new Attribute("positive", "up"));
            this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station altitude"));
            this.ncfile.addVariableAttribute(v, new Attribute("standard_name", "surface_altitude"));
        }
        v = this.ncfile.addStringVariable(idName, this.stationDims, this.name_strlen);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station identifier"));
        this.ncfile.addVariableAttribute(v, new Attribute("cf_role", "timeseries_id"));
        v = this.ncfile.addStringVariable(descName, this.stationDims, this.desc_strlen);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station description"));
        this.ncfile.addVariableAttribute(v, new Attribute("standard_name", "platform_name"));
        if (this.useWmoId) {
            v = this.ncfile.addStringVariable(wmoName, this.stationDims, this.wmo_strlen);
            this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station WMO id"));
            this.ncfile.addVariableAttribute(v, new Attribute("standard_name", "platform_id"));
        }
    }

    private void createObsVariables(DateUnit timeUnit) throws IOException {
        Variable timeVar = this.ncfile.addVariable("time", DataType.DOUBLE, "obs");
        this.ncfile.addVariableAttribute(timeVar, new Attribute("units", timeUnit.getUnitsString()));
        this.ncfile.addVariableAttribute(timeVar, new Attribute("long_name", "time of measurement"));
        Variable v = this.ncfile.addVariable(stationIndexName, DataType.INT, "obs");
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station index for this observation record"));
        this.ncfile.addVariableAttribute(v, new Attribute("instance_dimension", stationDimName));
    }

    private void createDataVariables(List<VariableSimpleIF> dataVars) throws IOException {
        String coordNames = "latitude longitude altitude time";
        for (VariableSimpleIF var : dataVars) {
            List<Dimension> dims = var.getDimensions();
            this.dimSet.addAll(dims);
        }
        for (Dimension d : this.dimSet) {
            if (d.isUnlimited()) continue;
            this.ncfile.addDimension(d.getName(), d.getLength(), d.isShared(), false, d.isVariableLength());
        }
        ArrayList<VariableSimpleIF> useDataVars = new ArrayList<VariableSimpleIF>(dataVars.size());
        for (VariableSimpleIF var : dataVars) {
            if (this.ncfile.findVariable(var.getShortName()) != null) continue;
            useDataVars.add(var);
        }
        for (VariableSimpleIF oldVar : useDataVars) {
            List<Dimension> dims = oldVar.getDimensions();
            StringBuilder dimNames = new StringBuilder("obs");
            for (Dimension d : dims) {
                if (d.isUnlimited()) continue;
                dimNames.append(" ").append(d.getName());
            }
            Variable newVar = this.ncfile.addVariable(oldVar.getShortName(), oldVar.getDataType(), dimNames.toString());
            List<Attribute> atts = oldVar.getAttributes();
            for (Attribute att : atts) {
                newVar.addAttribute(att);
            }
            newVar.addAttribute(new Attribute("coordinates", coordNames));
        }
    }

    private void writeStationData(List<Station> stnList) throws IOException {
        int nstns = stnList.size();
        this.stationMap = new HashMap(2 * nstns);
        ArrayDouble.D1 latArray = new ArrayDouble.D1(nstns);
        ArrayDouble.D1 lonArray = new ArrayDouble.D1(nstns);
        ArrayDouble.D1 altArray = new ArrayDouble.D1(nstns);
        ArrayObject.D1 idArray = new ArrayObject.D1(String.class, nstns);
        ArrayObject.D1 descArray = new ArrayObject.D1(String.class, nstns);
        ArrayObject.D1 wmoArray = new ArrayObject.D1(String.class, nstns);
        for (int i = 0; i < stnList.size(); ++i) {
            Station stn = stnList.get(i);
            this.stationMap.put(stn.getName(), i);
            latArray.set(i, stn.getLatitude());
            lonArray.set(i, stn.getLongitude());
            if (this.useAlt) {
                altArray.set(i, stn.getAltitude());
            }
            idArray.set(i, stn.getName());
            descArray.set(i, stn.getDescription());
            if (!this.useWmoId) continue;
            wmoArray.set(i, stn.getWmoId());
        }
        try {
            this.ncfile.write("latitude", latArray);
            this.ncfile.write("longitude", lonArray);
            if (this.useAlt) {
                this.ncfile.write("altitude", altArray);
            }
            this.ncfile.writeStringData(idName, idArray);
            this.ncfile.writeStringData(descName, descArray);
            if (this.useWmoId) {
                this.ncfile.writeStringData(wmoName, wmoArray);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public void writeRecord(Station s, PointFeature sobs, StructureData sdata) throws IOException {
        this.writeRecord(s.getName(), sobs.getObservationTime(), sobs.getObservationTimeAsCalendarDate(), sdata);
    }

    public void writeRecord(String stnName, double timeCoordValue, CalendarDate obsDate, StructureData sdata) throws IOException {
        this.trackBB(null, obsDate);
        Integer parentIndex = this.stationMap.get(stnName);
        if (parentIndex == null) {
            throw new RuntimeException("Cant find station " + stnName);
        }
        ArrayStructureW sArray = new ArrayStructureW(sdata.getStructureMembers(), new int[]{1});
        sArray.setStructureData(sdata, 0);
        this.timeArray.set(0, timeCoordValue);
        this.parentArray.set(0, (int)parentIndex);
        this.origin[0] = this.recno++;
        try {
            this.ncfile.write("record", this.origin, sArray);
            this.ncfile.write("time", this.origin, this.timeArray);
            this.ncfile.write(stationIndexName, this.origin, this.parentArray);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    private LatLonRect getBoundingBox(List stnList) {
        Station s = (Station)stnList.get(0);
        LatLonPointImpl llpt = new LatLonPointImpl();
        llpt.set(s.getLatitude(), s.getLongitude());
        LatLonRect rect = new LatLonRect(llpt, 0.001, 0.001);
        for (int i = 1; i < stnList.size(); ++i) {
            s = (Station)stnList.get(i);
            llpt.set(s.getLatitude(), s.getLongitude());
            rect.extend(llpt);
        }
        return rect;
    }
}

