/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import ucar.nc2.util.net.EasyX509TrustManager;
import ucar.nc2.util.net.HTTPAuthProvider;
import ucar.nc2.util.net.HTTPException;
import ucar.nc2.util.net.HTTPSSLProvider;
import ucar.nc2.util.net.HTTPSSLScheme;

public class EasySSLProtocolSocketFactory
implements ProtocolSocketFactory {
    private SSLContext sslcontext = null;

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.getSSLContext(null, host, port).getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.getSSLContext(null, host, port).getSocketFactory().createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.createSocket(host, port, clientHost, clientPort, new HttpConnectionParams());
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        return this.getSSLContext(params, host, port).getSocketFactory().createSocket(host, port);
    }

    private SSLContext getSSLContext(HttpConnectionParams params, String host, int port) throws HTTPException {
        if (this.sslcontext == null) {
            this.sslcontext = this.createSSLContext(params, host, port);
        }
        return this.sslcontext;
    }

    private SSLContext createSSLContext(HttpConnectionParams params, String host, int port) throws HTTPException {
        SSLContext sslcontext = null;
        KeyManager[] keymanagers = null;
        KeyStore keystore = null;
        KeyStore truststore = null;
        TrustManager[] trustmanagers = null;
        String keypassword = null;
        String keypath = null;
        String trustpassword = null;
        String trustpath = null;
        try {
            HTTPSSLProvider sslprovider;
            HTTPAuthProvider provider = (HTTPAuthProvider)params.getParameter("http.authentication.credential-provider");
            if (provider == null) {
                return EasySSLProtocolSocketFactory.stdauthenticate();
            }
            Credentials creds = null;
            try {
                creds = provider.getCredentials(HTTPSSLScheme.Default, null, 0, false);
                if (creds == null) {
                    return EasySSLProtocolSocketFactory.stdauthenticate();
                }
            }
            catch (CredentialsNotAvailableException e) {
                return EasySSLProtocolSocketFactory.stdauthenticate();
            }
            HTTPSSLProvider hTTPSSLProvider = sslprovider = creds == null ? null : (HTTPSSLProvider)creds;
            if (sslprovider == null) {
                return EasySSLProtocolSocketFactory.stdauthenticate();
            }
            keypath = sslprovider.getKeystore();
            keypassword = sslprovider.getKeypassword();
            trustpath = sslprovider.getTruststore();
            trustpassword = sslprovider.getTrustpassword();
            keystore = EasySSLProtocolSocketFactory.buildstore(keypath, keypassword, "key");
            if (keystore != null) {
                KeyManagerFactory kmfactory = KeyManagerFactory.getInstance("SunX509");
                kmfactory.init(keystore, keypassword.toCharArray());
                keymanagers = kmfactory.getKeyManagers();
            }
            trustmanagers = (truststore = EasySSLProtocolSocketFactory.buildstore(trustpath, trustpassword, "trust")) != null ? new TrustManager[]{new EasyX509TrustManager(truststore)} : new TrustManager[]{new EasyX509TrustManager(null)};
            sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(keymanagers, trustmanagers, null);
            return sslcontext;
        }
        catch (KeyManagementException e) {
            throw new HTTPException("Key Management exception: " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new HTTPException("Unsupported algorithm exception: " + e.getMessage());
        }
        catch (KeyStoreException e) {
            throw new HTTPException("Keystore exception: " + e.getMessage());
        }
        catch (GeneralSecurityException e) {
            throw new HTTPException("Key management exception: " + e.getMessage());
        }
        catch (IOException e) {
            throw new HTTPException("I/O error reading keystore/truststore file: " + e.getMessage());
        }
    }

    private static SSLContext stdauthenticate() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        TrustManager[] trustmanagers = new TrustManager[]{new EasyX509TrustManager(null)};
        SSLContext sslcontext = SSLContext.getInstance("SSL");
        sslcontext.init(null, trustmanagers, null);
        return sslcontext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeyStore buildstore(String path, String password, String prefix) throws HTTPException {
        KeyStore store;
        block7: {
            store = null;
            try {
                if (path == null || password == null) break block7;
                File storefile = new File(path);
                if (!storefile.canRead()) {
                    throw new HTTPException("Cannot read specified " + prefix + "store:" + storefile.getAbsolutePath());
                }
                store = KeyStore.getInstance("JKS");
                FileInputStream is = null;
                try {
                    is = new FileInputStream(storefile);
                    store.load(is, password.toCharArray());
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
            }
            catch (Exception e) {
                throw new HTTPException(e);
            }
        }
        return store;
    }
}

