/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.io.IOException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.TypedDatasetImpl;
import ucar.nc2.dt.radial.RadialCoordSys;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.cache.FileCache;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonRect;

public abstract class RadialDatasetSweepAdapter
extends TypedDatasetImpl
implements RadialDatasetSweep {
    protected EarthLocation origin;
    protected HashMap csHash = new HashMap();
    protected DateUnit dateUnits;
    protected FileCache fileCache;

    public RadialDatasetSweepAdapter() {
    }

    public RadialDatasetSweepAdapter(NetcdfDataset ds) {
        super(ds);
        this.parseInfo.append("RadialDatasetAdapter look for RadialVariables\n");
        List<Variable> vars = ds.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            this.addRadialVariable(ds, vars.get(i));
        }
    }

    protected abstract void addRadialVariable(NetcdfDataset var1, Variable var2);

    protected abstract RadialDatasetSweep.RadialVariable makeRadialVariable(NetcdfDataset var1, VariableSimpleIF var2, Variable var3);

    protected abstract void setTimeUnits() throws Exception;

    @Override
    public String getDetailInfo() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append(" Radar ID = " + this.getRadarID() + "\n");
        sbuff.append(" Radar Name = " + this.getRadarName() + "\n");
        sbuff.append(" Data Format Name= " + this.getDataFormat() + "\n");
        sbuff.append(" Common Type = " + this.getCommonType() + "\n");
        sbuff.append(" Common Origin = " + this.getCommonOrigin() + "\n");
        DateUnit dt = this.getTimeUnits();
        if (dt != null) {
            sbuff.append(" Date Unit = " + dt.getUnitsString() + "\n");
        }
        sbuff.append(" isStationary = " + this.isStationary() + "\n");
        sbuff.append(" isVolume = " + this.isVolume() + "\n");
        sbuff.append("\n");
        sbuff.append(super.getDetailInfo());
        return sbuff.toString();
    }

    protected abstract void setEarthLocation();

    @Override
    public RadialDatasetSweep.Type getCommonType() {
        return null;
    }

    @Override
    public DateUnit getTimeUnits() {
        return this.dateUnits;
    }

    public EarthLocation getEarthLocation() {
        return this.origin;
    }

    @Override
    protected void setBoundingBox() {
        LatLonRect largestBB = null;
        for (Object o : this.csHash.values()) {
            RadialCoordSys sys = (RadialCoordSys)o;
            sys.setOrigin(this.origin);
            LatLonRect bb = sys.getBoundingBox();
            if (largestBB == null) {
                largestBB = bb;
                continue;
            }
            largestBB.extend(bb);
        }
        this.boundingBox = largestBB;
    }

    @Override
    public void calcBounds() throws IOException {
        this.setBoundingBox();
        try {
            this.setTimeUnits();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        this.setStartDate();
        this.setEndDate();
    }

    @Override
    public FeatureType getFeatureType() {
        return FeatureType.RADIAL;
    }

    @Override
    public DateRange getDateRange() {
        return new DateRange(this.getStartDate(), this.getEndDate());
    }

    @Override
    public CalendarDateRange getCalendarDateRange() {
        return CalendarDateRange.of(this.getStartDate(), this.getEndDate());
    }

    @Override
    public CalendarDate getCalendarDateStart() {
        return CalendarDate.of(this.getStartDate());
    }

    @Override
    public CalendarDate getCalendarDateEnd() {
        return CalendarDate.of(this.getEndDate());
    }

    @Override
    public void getDetailInfo(Formatter sf) {
        sf.format("%s", this.getDetailInfo());
    }

    @Override
    public String getImplementationName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.fileCache != null) {
            this.fileCache.release(this);
        } else {
            try {
                if (this.ncfile != null) {
                    this.ncfile.close();
                }
            }
            finally {
                this.ncfile = null;
            }
        }
    }

    @Override
    public boolean sync() throws IOException {
        return false;
    }

    @Override
    public void setFileCache(FileCache fileCache) {
        this.fileCache = fileCache;
    }

    public class MyRadialVariableAdapter
    implements VariableSimpleIF {
        private int rank = 1;
        private int[] shape = new int[]{1};
        private String name;
        private String desp;
        private List<Attribute> attributes;

        public MyRadialVariableAdapter(String vName, List<Attribute> atts) {
            this.name = vName;
            this.desp = "A radial variable holding a list of radial sweeps";
            this.attributes = atts;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(VariableSimpleIF o) {
            return this.getFullName().compareTo(o.getFullName());
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getFullName() {
            return this.name;
        }

        @Override
        public String getShortName() {
            return this.name;
        }

        @Override
        public DataType getDataType() {
            return DataType.FLOAT;
        }

        @Override
        public String getDescription() {
            return this.desp;
        }

        public String getInfo() {
            return this.desp;
        }

        @Override
        public String getUnitsString() {
            return "N/A";
        }

        @Override
        public int getRank() {
            return this.rank;
        }

        @Override
        public int[] getShape() {
            return this.shape;
        }

        @Override
        public List<Dimension> getDimensions() {
            return null;
        }

        @Override
        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        @Override
        public Attribute findAttributeIgnoreCase(String attName) {
            Iterator<Attribute> it = this.attributes.iterator();
            Attribute at = null;
            while (it.hasNext() && !attName.equalsIgnoreCase((at = it.next()).getName())) {
            }
            return at;
        }
    }
}

