/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.io.File;
import java.io.IOException;
import java.util.Formatter;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.filesystem.MFileOS;
import thredds.inventory.CollectionManager;
import thredds.inventory.MFile;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.grib1.Grib1CollectionBuilder;
import ucar.nc2.grib.grib1.Grib1Index;
import ucar.nc2.grib.grib2.Grib2CollectionBuilder;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.util.DiskCache;
import ucar.unidata.io.RandomAccessFile;

public abstract class GribIndex {
    public static final String IDX_EXT = ".gbx9";
    public static final boolean debug = false;
    private static final CollectionManager.ChangeChecker gribCC = new CollectionManager.ChangeChecker(){

        @Override
        public boolean hasChangedSince(MFile file, long when) {
            File idxFile = GribIndex.getIndexFile(file.getPath());
            if (!idxFile.exists()) {
                return true;
            }
            if (idxFile.lastModified() < file.getLastModified()) {
                return true;
            }
            return 0L < when && when < idxFile.lastModified();
        }

        @Override
        public boolean hasntChangedSince(MFile file, long when) {
            File idxFile = GribIndex.getIndexFile(file.getPath());
            if (!idxFile.exists()) {
                return true;
            }
            if (idxFile.lastModified() < file.getLastModified()) {
                return true;
            }
            return 0L < when && idxFile.lastModified() < when;
        }
    };

    public static File getIndexFile(String path) {
        return DiskCache.getFileStandardPolicy(path + IDX_EXT);
    }

    public static CollectionManager.ChangeChecker getChangeChecker() {
        return gribCC;
    }

    public static GribCollection makeGribCollectionFromSingleFile(boolean isGrib1, RandomAccessFile dataRaf, FeatureCollectionConfig.GribConfig config, CollectionManager.Force force, Formatter f) throws IOException {
        boolean readOk;
        GribIndex gribIndex = isGrib1 ? new Grib1Index() : new Grib2Index();
        String filename = dataRaf.getLocation();
        File dataFile = new File(filename);
        try {
            readOk = gribIndex.readIndex(filename, dataFile.lastModified(), force);
        }
        catch (IOException ioe) {
            readOk = false;
        }
        if (!readOk) {
            gribIndex.makeIndex(filename, f);
            f.format("  Index written: %s%n", filename + IDX_EXT);
        }
        MFileOS mfile = new MFileOS(dataFile);
        if (isGrib1) {
            return Grib1CollectionBuilder.readOrCreateIndexFromSingleFile(mfile, force, config, f);
        }
        return Grib2CollectionBuilder.readOrCreateIndexFromSingleFile(mfile, force, config, f);
    }

    public static GribIndex readOrCreateIndexFromSingleFile(boolean isGrib1, boolean createCollectionIndex, MFile mfile, FeatureCollectionConfig.GribConfig config, CollectionManager.Force force, Formatter f) throws IOException {
        GribIndex index;
        GribIndex gribIndex = index = isGrib1 ? new Grib1Index() : new Grib2Index();
        if (!index.readIndex(mfile.getPath(), mfile.getLastModified(), force)) {
            index.makeIndex(mfile.getPath(), f);
            f.format("  Index written: %s == %d records %n", mfile.getName() + IDX_EXT, index.getNRecords());
        }
        if (!createCollectionIndex) {
            return index;
        }
        GribCollection gc = isGrib1 ? Grib1CollectionBuilder.readOrCreateIndexFromSingleFile(mfile, force, config, f) : Grib2CollectionBuilder.readOrCreateIndexFromSingleFile(mfile, force, config, f);
        gc.close();
        return index;
    }

    public abstract boolean readIndex(String var1, long var2, CollectionManager.Force var4) throws IOException;

    public abstract boolean makeIndex(String var1, Formatter var2) throws IOException;

    public abstract int getNRecords();
}

