/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.bufr.ConstructNC;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageCompressedDataReader;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.iosp.bufr.MessageUncompressedDataReader;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.CompareNetcdf2;
import ucar.nc2.util.DebugFlags;
import ucar.unidata.io.RandomAccessFile;

public class BufrIosp
extends AbstractIOServiceProvider {
    private static final Logger log = LoggerFactory.getLogger(BufrIosp.class);
    public static final String obsRecord = "obs";
    static final String obsIndex = "obsRecordIndex";
    private static boolean debugCompress = false;
    private static boolean debugOpen = false;
    private Formatter parseInfo;
    private ConstructNC construct;
    private Message protoMessage;
    private final List<Message> msgs = new ArrayList<Message>();
    private int[] obsStart;
    private int nelems = -1;

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugOpen = debugFlag.isSet("Bufr/open");
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        return MessageScanner.isValidFile(raf);
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        long start = System.nanoTime();
        if (debugOpen) {
            this.parseInfo = new Formatter();
            this.parseInfo.format("\nOpen %s size = %d Kb \n", raf.getLocation(), raf.length() / 1000L);
        }
        this.raf = raf;
        MessageScanner scan = new MessageScanner(raf);
        int count = 0;
        while (scan.hasNext()) {
            Message m = scan.next();
            if (m == null || m.containsBufrTable()) continue;
            if (this.protoMessage == null) {
                this.protoMessage = m;
                this.protoMessage.getRootDataDescriptor();
                if (!this.protoMessage.isTablesComplete()) {
                    throw new IllegalStateException("BUFR file has incomplete tables");
                }
            } else if (!this.protoMessage.equals(m)) {
                log.warn("File " + ncfile.getLocation() + " has different BUFR message types msgno=" + count + "; skipping");
                continue;
            }
            this.msgs.add(m);
            ++count;
        }
        this.obsStart = new int[this.msgs.size()];
        int mi = 0;
        int countObs = 0;
        for (Message m : this.msgs) {
            this.obsStart[mi++] = countObs;
            countObs += m.getNumberDatasets();
        }
        if (debugOpen) {
            long took = (System.nanoTime() - start) / 1000000L;
            double rate = took > 0L ? (double)count / (double)took : 0.0;
            this.parseInfo.format("nmsgs= %d nobs = %d took %d msecs rate = %f msgs/msec\n", count, scan.getTotalObs(), took, rate);
        }
        this.construct = new ConstructNC(this.protoMessage, countObs, ncfile);
        ncfile.finish();
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, Message single) throws IOException {
        this.raf = raf;
        this.protoMessage = single;
        this.protoMessage.getRootDataDescriptor();
        if (!this.protoMessage.isTablesComplete()) {
            throw new IllegalStateException("BUFR file has incomplete tables");
        }
        this.msgs.add(single);
        this.obsStart = new int[this.msgs.size()];
        int mi = 0;
        int countObs = 0;
        for (Message m : this.msgs) {
            this.obsStart[mi++] = countObs;
            countObs += m.getNumberDatasets();
        }
        this.construct = new ConstructNC(this.protoMessage, countObs, ncfile);
        ncfile.finish();
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        Sequence s = this.construct.recordStructure;
        return new ArraySequence(s.makeStructureMembers(), new SeqIter(), this.nelems);
    }

    ArraySequence readAll() throws IOException {
        Sequence s = this.construct.recordStructure;
        return new ArraySequence(s.makeStructureMembers(), new SeqIter(), this.nelems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTime(ArrayStructure as) throws IOException {
        int n = (int)as.getSize();
        Array timeData = Array.factory(String.class, new int[]{n});
        IndexIterator ii = timeData.getIndexIterator();
        if (as instanceof ArrayStructureBB) {
            ArrayStructureBB asbb = (ArrayStructureBB)as;
            StructureMembers.Member m = asbb.findMember("time");
            StructureDataIterator iter = as.getStructureDataIterator();
            try {
                int recno = 0;
                while (iter.hasNext()) {
                    CalendarDate cd = this.construct.makeObsTimeValue(iter.next());
                    asbb.addObjectToHeap(recno, m, cd.toString());
                    ++recno;
                }
            }
            finally {
                iter.finish();
            }
        }
        StructureDataIterator iter = as.getStructureDataIterator();
        try {
            while (iter.hasNext()) {
                CalendarDate cd = this.construct.makeObsTimeValue(iter.next());
                ii.setObjectNext(cd.toString());
            }
        }
        finally {
            iter.finish();
        }
        StructureMembers.Member m = as.findMember("time");
        m.setDataArray(timeData);
    }

    @Override
    public StructureDataIterator getStructureIterator(Structure s, int bufferSize) throws IOException {
        return new SeqIter();
    }

    @Override
    public String getDetailInfo() {
        Formatter ff = new Formatter();
        try {
            this.protoMessage.dump(ff);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.parseInfo != null) {
            ff.format("%s", this.parseInfo.toString());
        }
        return ff.toString();
    }

    @Override
    public String getFileTypeId() {
        return "BUFR";
    }

    @Override
    public String getFileTypeDescription() {
        return "WMO Binary Universal Form";
    }

    public void readAll(boolean dump) throws IOException, InvalidRangeException {
        for (Message m : this.msgs) {
            ArrayStructure data;
            Object reader;
            if (!m.dds.isCompressed()) {
                reader = new MessageUncompressedDataReader();
                data = ((MessageUncompressedDataReader)reader).readEntireMessage(this.construct.recordStructure, this.protoMessage, m, this.raf, null);
            } else {
                reader = new MessageCompressedDataReader();
                data = ((MessageCompressedDataReader)reader).readEntireMessage(this.construct.recordStructure, this.protoMessage, m, this.raf, null);
            }
            if (!dump) continue;
            NCdumpW.printArray((Array)data, "test", new PrintWriter(System.out), null);
        }
    }

    public void compare(Structure obs) throws IOException, InvalidRangeException {
        int start = 0;
        for (Message m : this.msgs) {
            ArrayStructure data1;
            Object reader;
            if (!m.isTablesComplete()) continue;
            if (!m.dds.isCompressed()) {
                reader = new MessageUncompressedDataReader();
                data1 = ((MessageUncompressedDataReader)reader).readEntireMessage(this.construct.recordStructure, this.protoMessage, m, this.raf, null);
            } else {
                reader = new MessageCompressedDataReader();
                data1 = ((MessageCompressedDataReader)reader).readEntireMessage(this.construct.recordStructure, this.protoMessage, m, this.raf, null);
            }
            int n = m.getNumberDatasets();
            m.calcTotalBits(null);
            Array data2 = obs.read(new Section().appendRange(start, start + n - 1));
            CompareNetcdf2 cn = new CompareNetcdf2(new Formatter(System.out), true, true, true);
            cn.compareData("all", data1, data2, true);
            start += n;
        }
    }

    public static void doon(String filename) throws IOException, InvalidRangeException {
        System.out.printf("BufrIosp compare = %s%n", filename);
        NetcdfFile ncfile = NetcdfFile.open(filename);
        BufrIosp iosp = (BufrIosp)ncfile.getIosp();
        iosp.readAll(false);
    }

    public static void main(String[] arg) throws IOException, InvalidRangeException {
        BufrIosp.doon("Q:/cdmUnitTest/formats/bufr/eumetsat/MSG2-SEVI-MSGCLDS-0101-0101-20080405114500.000000000Z-909326.bfr");
    }

    private class SeqIter
    implements StructureDataIterator {
        StructureDataIterator currIter;
        Iterator<Message> messIter;
        int recnum = 0;
        int bufferSize = -1;
        boolean addTime;

        SeqIter() {
            this.addTime = ((BufrIosp)BufrIosp.this).construct.recordStructure.findVariable("time") != null;
            this.reset();
        }

        @Override
        public StructureDataIterator reset() {
            this.recnum = 0;
            this.messIter = BufrIosp.this.msgs.iterator();
            this.currIter = null;
            return this;
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.currIter == null) {
                this.currIter = this.readNextMessage();
                if (this.currIter == null) {
                    BufrIosp.this.nelems = this.recnum;
                    return false;
                }
            }
            if (!this.currIter.hasNext()) {
                this.currIter = this.readNextMessage();
                return this.hasNext();
            }
            return true;
        }

        @Override
        public StructureData next() throws IOException {
            ++this.recnum;
            return this.currIter.next();
        }

        private StructureDataIterator readNextMessage() throws IOException {
            ArrayStructure as;
            if (!this.messIter.hasNext()) {
                return null;
            }
            Message m = this.messIter.next();
            if (m.dds.isCompressed()) {
                MessageCompressedDataReader reader = new MessageCompressedDataReader();
                as = reader.readEntireMessage(((BufrIosp)BufrIosp.this).construct.recordStructure, BufrIosp.this.protoMessage, m, BufrIosp.this.raf, null);
            } else {
                MessageUncompressedDataReader reader = new MessageUncompressedDataReader();
                as = reader.readEntireMessage(((BufrIosp)BufrIosp.this).construct.recordStructure, BufrIosp.this.protoMessage, m, BufrIosp.this.raf, null);
            }
            if (this.addTime) {
                BufrIosp.this.addTime(as);
            }
            return as.getStructureDataIterator();
        }

        @Override
        public void setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        @Override
        public int getCurrentRecno() {
            return this.recnum - 1;
        }

        @Override
        public void finish() {
            if (this.currIter != null) {
                this.currIter.finish();
            }
            this.currIter = null;
        }
    }
}

