/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.elections;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.elections.Elections;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.elections.TimebasedProposalGenerator;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RankingProposer
extends Proposer {
    private final TimebasedProposalGenerator proposalGenerator = new TimebasedProposalGenerator();

    public RankingProposer(Elections elections, NameIdPair nameIdPair) {
        super(elections, nameIdPair);
    }

    @Override
    protected Protocol.Value choosePhase2Value(Set<TextProtocol.MessageExchange> exchanges) {
        long maxRanking = Long.MIN_VALUE;
        int maxPriority = Integer.MIN_VALUE;
        String maxTarget = null;
        Protocol.Value acceptorValue = null;
        for (TextProtocol.MessageExchange me : exchanges) {
            Protocol.Promise p;
            if (me.getResponseMessage().getOp() != this.elections.getProtocol().PROMISE || (p = (Protocol.Promise)me.getResponseMessage()).getSuggestionRanking() < maxRanking || p.getSuggestionRanking() == maxRanking && (p.getPriority() < maxPriority || p.getPriority() == maxPriority && maxTarget != null && me.target.toString().compareTo(maxTarget) <= 0)) continue;
            acceptorValue = p.getSuggestion();
            maxRanking = p.getSuggestionRanking();
            maxPriority = p.getPriority();
            maxTarget = me.target.toString();
        }
        if (acceptorValue == null) {
            throw EnvironmentFailureException.unexpectedState("No suggestion found in message exchange");
        }
        return acceptorValue;
    }

    @Override
    public synchronized Proposer.Proposal nextProposal() {
        return this.proposalGenerator.nextProposal();
    }
}

