/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.filesystem.MFileOS;
import thredds.inventory.MCollection;
import thredds.inventory.MController;
import thredds.inventory.MFile;

@ThreadSafe
public class ControllerOS
implements MController {
    private static Logger logger = LoggerFactory.getLogger(ControllerOS.class);

    @Override
    public Iterator<MFile> getInventoryAll(MCollection mc, boolean recheck) {
        File cd;
        String path = mc.getDirectoryName();
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        if (!(cd = new File(path)).exists()) {
            return null;
        }
        if (!cd.isDirectory()) {
            return null;
        }
        return new FilteredIterator(mc, new MFileIteratorAll(cd), false);
    }

    @Override
    public Iterator<MFile> getInventoryTop(MCollection mc, boolean recheck) {
        File cd;
        String path = mc.getDirectoryName();
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        if (!(cd = new File(path)).exists()) {
            return null;
        }
        if (!cd.isDirectory()) {
            return null;
        }
        return new FilteredIterator(mc, new MFileIterator(cd), false);
    }

    @Override
    public Iterator<MFile> getSubdirs(MCollection mc, boolean recheck) {
        File cd;
        String path = mc.getDirectoryName();
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        if (!(cd = new File(path)).exists()) {
            return null;
        }
        if (!cd.isDirectory()) {
            return null;
        }
        return new FilteredIterator(mc, new MFileIterator(cd), true);
    }

    @Override
    public void close() {
    }

    private class Traversal {
        File dir;
        List<File> fileList;
        Iterator<File> subdirIterator;
        boolean leavesAreDone = false;

        Traversal(File dir) {
            this.dir = dir;
            this.fileList = new ArrayList<File>();
            ArrayList<File> subdirList = new ArrayList<File>();
            for (File f : dir.listFiles()) {
                if (f.isDirectory()) {
                    subdirList.add(f);
                    continue;
                }
                this.fileList.add(f);
            }
            if (subdirList.size() > 0) {
                this.subdirIterator = subdirList.iterator();
            }
        }
    }

    private class MFileIteratorAll
    implements Iterator<MFile> {
        Queue<Traversal> traverse = new LinkedList<Traversal>();
        Traversal currTraversal;
        Iterator<MFile> currIter;

        MFileIteratorAll(File top) {
            this.currTraversal = new Traversal(top);
        }

        @Override
        public boolean hasNext() {
            if (this.currIter == null) {
                this.currIter = this.getNextIterator();
                if (this.currIter == null) {
                    return false;
                }
            }
            if (!this.currIter.hasNext()) {
                this.currIter = this.getNextIterator();
                return this.hasNext();
            }
            return true;
        }

        @Override
        public MFile next() {
            return this.currIter.next();
        }

        private Iterator<MFile> getNextIterator() {
            if (!this.currTraversal.leavesAreDone) {
                this.currTraversal.leavesAreDone = true;
                return new MFileIterator(this.currTraversal.fileList);
            }
            if (this.currTraversal.subdirIterator != null && this.currTraversal.subdirIterator.hasNext()) {
                File nextDir = this.currTraversal.subdirIterator.next();
                this.traverse.add(this.currTraversal);
                this.currTraversal = new Traversal(nextDir);
                return this.getNextIterator();
            }
            if (this.traverse.peek() == null) {
                return null;
            }
            this.currTraversal = this.traverse.remove();
            return this.getNextIterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class MFileIterator
    implements Iterator<MFile> {
        List<File> files;
        int count = 0;

        MFileIterator(File dir) {
            File[] f = dir.listFiles();
            if (f == null) {
                logger.warn("I/O error on " + dir.getPath());
                throw new IllegalStateException("dir.getPath() returned null on " + dir.getPath());
            }
            this.files = Arrays.asList(f);
        }

        MFileIterator(List<File> files) {
            this.files = files;
        }

        @Override
        public boolean hasNext() {
            return this.count < this.files.size();
        }

        @Override
        public MFile next() {
            File cfile = this.files.get(this.count++);
            return new MFileOS(cfile);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class FilteredIterator
    implements Iterator<MFile> {
        private Iterator<MFile> orgIter;
        private MCollection mc;
        private boolean wantDirs;
        private MFile next;

        FilteredIterator(MCollection mc, Iterator<MFile> iter, boolean wantDirs) {
            this.orgIter = iter;
            this.mc = mc;
            this.wantDirs = wantDirs;
        }

        @Override
        public boolean hasNext() {
            this.next = this.nextFilteredFile();
            return this.next != null;
        }

        @Override
        public MFile next() {
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private MFile nextFilteredFile() {
            if (this.orgIter == null) {
                return null;
            }
            if (!this.orgIter.hasNext()) {
                return null;
            }
            MFile pdata = this.orgIter.next();
            while (pdata.isDirectory() != this.wantDirs || !this.mc.accept(pdata)) {
                if (!this.orgIter.hasNext()) {
                    return null;
                }
                pdata = this.orgIter.next();
            }
            return pdata;
        }
    }
}

