/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.catalog.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import ucar.nc2.constants.FeatureType;

public class Indexer {
    private StringBuffer indexMessages;

    public void index(StringBuffer indexMessages, ArrayList datasets) {
        this.indexMessages = indexMessages;
        try {
            IndexWriter writer = new IndexWriter("index", (Analyzer)new StandardAnalyzer(), true);
            for (InvDataset ds : datasets) {
                indexMessages.append("Indexing dataset " + ds.getName() + " " + ds.getID() + "\n");
                Document doc = this.makeDocument(ds);
                if (null == doc) continue;
                writer.addDocument(doc);
            }
            writer.optimize();
            writer.close();
        }
        catch (IOException ioe) {
            indexMessages.append("Lucene ERROR = " + ioe.getMessage() + "\n");
        }
    }

    private Document makeDocument(InvDataset ds) {
        Document doc = new Document();
        ArrayList<FeatureType> uq = new ArrayList<FeatureType>();
        String subsetURL = ds.getSubsetUrl();
        if (subsetURL == null) {
            System.out.println("subsetURL null on " + ds);
            return null;
        }
        doc.add(Field.UnIndexed("subsetURL", ds.getSubsetUrl()));
        doc.add(Field.Text("name", ds.getName()));
        String summary = ds.getDocumentation("summary");
        if (null != summary) {
            doc.add(Field.Text("summary", summary));
            this.indexMessages.append("  indexed summary\n");
        }
        List<ThreddsMetadata.Vocab> keywords = ds.getKeywords();
        for (int i = 0; i < keywords.size(); ++i) {
            ThreddsMetadata.Vocab k = keywords.get(i);
            doc.add(Field.Text("keyword", k.getText()));
            this.indexMessages.append("  indexed keyword= " + k.getText() + "\n");
        }
        FeatureType dt = ds.getDataType();
        if (null != dt && !uq.contains((Object)dt)) {
            uq.add(dt);
        }
        this.findUniques(doc, ds, uq);
        for (int i = 0; i < uq.size(); ++i) {
            Object elem = uq.get(i);
            String className = elem.getClass().getName();
            int pos = className.lastIndexOf(".");
            className = className.substring(pos + 1);
            doc.add(Field.Text(className, elem.toString()));
            this.indexMessages.append("  indexed " + className + " == " + elem.toString() + "\n");
        }
        return doc;
    }

    private void findUniques(Document doc, InvDataset ds, ArrayList uq) {
        List<InvAccess> access = ds.getAccess();
        for (int i = 0; i < access.size(); ++i) {
            ServiceType st;
            InvAccess a = access.get(i);
            DataFormatType dft = ds.getDataFormatType();
            if (null != dft && !uq.contains(dft)) {
                uq.add(dft);
            }
            if (null == (st = a.getService().getServiceType()) || uq.contains(st)) continue;
            uq.add(st);
        }
        List<InvDataset> list = ds.getDatasets();
        for (int i = 0; i < list.size(); ++i) {
            InvDataset nested = list.get(i);
            if (nested instanceof InvCatalogRef || nested.isHarvest()) continue;
            this.findUniques(doc, nested, uq);
        }
    }
}

