/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.catalog.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.EventListenerList;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ServiceType;
import thredds.catalog.crawl.CatalogCrawler;
import thredds.ui.catalog.CatalogChooser;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.IO;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.ComboBox;

public class CatalogCopier
extends JPanel {
    private static final String FRAME_SIZE = "FrameSize";
    private EventListenerList listenerList = new EventListenerList();
    private CatalogChooser catalogChooser;
    private TextHistoryPane resultText;
    private JSplitPane splitV;
    private ComboBox filterCB;
    private FileManager fileManager;
    private PreferencesExt prefs;
    private Component parent;
    private int count;

    public CatalogCopier(PreferencesExt prefs, Component parent) {
        this.prefs = prefs;
        this.parent = parent;
        PreferencesExt node = prefs == null ? null : (PreferencesExt)prefs.node("catChooser");
        this.catalogChooser = new CatalogChooser(node, true, false, false);
        JPanel copyPanel = new JPanel(new BorderLayout());
        this.resultText = new TextHistoryPane(false);
        copyPanel.add((Component)this.resultText, "Center");
        this.filterCB = new ComboBox(prefs);
        JButton filterButt = new JButton("Filter");
        filterButt.setToolTipText("apply dataset filter");
        filterButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String filter = (String)CatalogCopier.this.filterCB.getSelectedItem();
                CatalogCopier.this.doFilter(filter);
            }
        });
        JButton copyButt = new JButton("Copy");
        copyButt.setToolTipText("copy datasets to local drive");
        copyButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String filter = (String)CatalogCopier.this.filterCB.getSelectedItem();
                CatalogCopier.this.doCopy(filter);
            }
        });
        JPanel topButtons = new JPanel(new FlowLayout(0, 5, 0));
        topButtons.add(filterButt);
        topButtons.add(copyButt);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel("Dataset path regexp filter:"), "West");
        topPanel.add((Component)this.filterCB, "Center");
        topPanel.add((Component)topButtons, "East");
        copyPanel.add((Component)topPanel, "North");
        this.splitV = new JSplitPane(0, false, this.catalogChooser, copyPanel);
        this.splitV.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitV, "Center");
        this.fileManager = new FileManager(null, null, null, (PreferencesExt)prefs.node("FileManager"));
        this.fileManager.getFileChooser().setFileSelectionMode(2);
        this.fileManager.getFileChooser().setDialogTitle("Choose Directory to write to");
    }

    private void doCopy(String regexp) {
        String dir = this.fileManager.chooseDirectory(null);
        if (dir == null) {
            return;
        }
        File copyDir = new File(dir);
        Pattern pattern = regexp == null ? null : Pattern.compile(regexp);
        InvDataset curr = this.catalogChooser.getSelectedDataset();
        CatalogCrawler crawler = new CatalogCrawler(1, false, (CatalogCrawler.Listener)new FilterListener(copyDir));
        this.resultText.clear();
        this.resultText.appendLine("Read catalog=" + curr + " with filter=" + regexp);
        crawler.crawlDirectDatasets((InvDatasetImpl)curr, null, null, pattern, false);
        this.resultText.gotoTop();
        this.filterCB.addItem(regexp);
    }

    private void doFilter(String regexp) {
        Pattern pattern = regexp == null ? null : Pattern.compile(regexp);
        InvDataset curr = this.catalogChooser.getSelectedDataset();
        CatalogCrawler crawler = new CatalogCrawler(1, false, (CatalogCrawler.Listener)new FilterListener(null));
        this.count = 0;
        this.resultText.clear();
        this.resultText.appendLine("Read catalog=" + curr + " with filter=" + regexp);
        crawler.crawlDirectDatasets((InvDatasetImpl)curr, null, null, pattern, false);
        this.resultText.appendLine("count = " + this.count);
        this.resultText.gotoTop();
        this.filterCB.addItem(regexp);
    }

    public void save() {
        this.catalogChooser.save();
        this.filterCB.save();
        this.prefs.putInt("splitPos", this.splitV.getDividerLocation());
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PropertyChangeListener.class) continue;
            ((PropertyChangeListener)listeners[i + 1]).propertyChange(event);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.add(PropertyChangeListener.class, l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.remove(PropertyChangeListener.class, l);
    }

    private class FilterListener
    implements CatalogCrawler.Listener {
        File copyDir;

        private FilterListener(File copyDir) {
            this.copyDir = copyDir;
        }

        @Override
        public void getDataset(InvDataset dd, Object context) {
            InvAccess inv = dd.getAccess(ServiceType.HTTPServer);
            if (inv == null) {
                inv = dd.getAccess(ServiceType.HTTP);
            }
            if (inv != null) {
                Pattern pattern = (Pattern)context;
                boolean ok = true;
                if (pattern != null) {
                    Matcher m = pattern.matcher(inv.getStandardUrlName());
                    ok = m.matches();
                }
                if (ok && this.copyDir != null) {
                    boolean copyOk = this.doOneCopy(inv.getStandardUrlName(), this.copyDir);
                    System.out.printf("%s copyOk=%s%n", inv.getStandardUrlName(), copyOk);
                    CatalogCopier.this.resultText.appendLine(inv.getStandardUrlName() + " copyOk=" + copyOk);
                } else {
                    if (ok) {
                        System.out.printf("%s match=%s%n", ok ? "ok " : "no ", inv.getStandardUrlName());
                    }
                    CatalogCopier.this.resultText.appendLine((ok ? "ok " : "no ") + inv.getStandardUrlName());
                }
                if (ok) {
                    CatalogCopier.this.count++;
                }
            }
        }

        @Override
        public boolean getCatalogRef(InvCatalogRef catRef, Object context) {
            System.out.printf("catRef=%s%n", catRef);
            return true;
        }

        private boolean doOneCopy(String url, File dir) {
            int pos = url.lastIndexOf("/");
            String filename = url.substring(pos + 1);
            File f = new File(dir, filename);
            try {
                IO.readURLtoFileWithExceptions(url, f);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

