/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.point.OneNestedPointCollectionImpl;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.geoloc.StationImpl;

public abstract class StationProfileFeatureImpl
extends OneNestedPointCollectionImpl
implements StationProfileFeature {
    protected DateUnit timeUnit;
    protected int timeSeriesNpts;
    protected Station s;
    protected PointFeatureCollectionIterator localIterator;

    public StationProfileFeatureImpl(String name, String desc, String wmoId, double lat, double lon, double alt, DateUnit timeUnit, int npts) {
        super(name, FeatureType.STATION_PROFILE);
        this.s = new StationImpl(name, desc, wmoId, lat, lon, alt);
        this.timeUnit = timeUnit;
        this.timeSeriesNpts = npts;
    }

    public StationProfileFeatureImpl(Station s, DateUnit timeUnit, int npts) {
        super(s.getName(), FeatureType.STATION_PROFILE);
        this.s = s;
        this.timeUnit = timeUnit;
        this.timeSeriesNpts = npts;
    }

    @Override
    public String getWmoId() {
        return this.s.getWmoId();
    }

    @Override
    public int size() {
        return this.timeSeriesNpts;
    }

    @Override
    public String getName() {
        return this.s.getName();
    }

    @Override
    public String getDescription() {
        return this.s.getDescription();
    }

    @Override
    public double getLatitude() {
        return this.s.getLatitude();
    }

    @Override
    public double getLongitude() {
        return this.s.getLongitude();
    }

    @Override
    public double getAltitude() {
        return this.s.getAltitude();
    }

    @Override
    public LatLonPoint getLatLon() {
        return this.s.getLatLon();
    }

    @Override
    public boolean isMissing() {
        return Double.isNaN(this.getLatitude()) || Double.isNaN(this.getLongitude());
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public ProfileFeature next() throws IOException {
        return (ProfileFeature)this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = this.getPointFeatureCollectionIterator(-1);
    }

    @Override
    public int compareTo(Station so) {
        return this.s.getName().compareTo(so.getName());
    }

    @Override
    public StationProfileFeature subset(DateRange dateRange) throws IOException {
        return null;
    }

    @Override
    public StationProfileFeature subset(LatLonRect dateRange) throws IOException {
        return this;
    }
}

