/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.bufr.BufrDataDescriptionSection;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.TableLookup;

public class DataDescriptorTreeConstructor {
    private static Logger log = LoggerFactory.getLogger(DataDescriptorTreeConstructor.class);
    private DataDescriptor root;
    private DataDescriptor changeWidth = null;
    private DataDescriptor changeScale = null;
    private DataDescriptor changeRefval = null;
    private DataDescriptor changeWtf = null;
    private DataPresentIndicator dpi = null;

    public DataDescriptor factory(TableLookup lookup, BufrDataDescriptionSection dds) {
        this.root = new DataDescriptor();
        List<DataDescriptor> keys = this.decode(dds.getDataDescriptors(), lookup);
        keys = this.preflatten(keys);
        List<DataDescriptor> tree = this.replicate(keys);
        this.root.subKeys = new ArrayList<DataDescriptor>();
        this.flatten(this.root.subKeys, tree);
        this.operate(this.root.subKeys);
        this.root.total_nbits = this.root.countBits();
        return this.root;
    }

    private List<DataDescriptor> decode(List<Short> keyDesc, TableLookup lookup) {
        if (keyDesc == null) {
            return null;
        }
        ArrayList<DataDescriptor> keys = new ArrayList<DataDescriptor>();
        for (short id : keyDesc) {
            DataDescriptor dd = new DataDescriptor(id, lookup);
            keys.add(dd);
            if (dd.f != 3) continue;
            List<Short> subDesc = lookup.getDescriptorsTableD(dd.fxy);
            if (subDesc == null) {
                dd.bad = true;
                continue;
            }
            dd.subKeys = this.decode(subDesc, lookup);
        }
        return keys;
    }

    private List<DataDescriptor> replicate(List<DataDescriptor> keys) {
        ArrayList<DataDescriptor> tree = new ArrayList<DataDescriptor>();
        Iterator<DataDescriptor> dkIter = keys.iterator();
        while (dkIter.hasNext()) {
            DataDescriptor dk = dkIter.next();
            if (dk.f == 1) {
                dk.subKeys = new ArrayList<DataDescriptor>();
                dk.replication = dk.y;
                if (dk.replication == 0) {
                    this.root.isVarLength = true;
                    DataDescriptor replication = dkIter.next();
                    if (replication.y == 0) {
                        dk.replicationCountSize = 1;
                    } else if (replication.y == 1) {
                        dk.replicationCountSize = 8;
                    } else if (replication.y == 2) {
                        dk.replicationCountSize = 16;
                    } else if (replication.y == 11) {
                        dk.repetitionCountSize = 8;
                    } else if (replication.y == 12) {
                        dk.repetitionCountSize = 16;
                    } else {
                        log.error("Unknown replication type= " + replication);
                    }
                }
                for (int j = 0; j < dk.x && dkIter.hasNext(); ++j) {
                    dk.subKeys.add(dkIter.next());
                }
                dk.subKeys = this.replicate(dk.subKeys);
            } else if (dk.f == 3 && dk.subKeys != null) {
                dk.subKeys = this.replicate(dk.subKeys);
            }
            tree.add(dk);
        }
        return tree;
    }

    private List<DataDescriptor> preflatten(List<DataDescriptor> tree) {
        ArrayList<DataDescriptor> result = new ArrayList<DataDescriptor>(tree.size());
        for (DataDescriptor key : tree) {
            boolean preflatten = false;
            if (key.f == 3 && key.subKeys != null) {
                List<DataDescriptor> subkeys = key.subKeys;
                for (int i = 0; i < subkeys.size(); ++i) {
                    DataDescriptor subkey = subkeys.get(i);
                    if (subkey.f != 1) continue;
                    int need = subkey.x;
                    int have = subkeys.size() - i - 1;
                    if (subkey.y == 0) {
                        --have;
                    }
                    if (need <= have) continue;
                    preflatten = true;
                }
            }
            if (preflatten) {
                result.addAll(key.subKeys);
                continue;
            }
            result.add(key);
        }
        return result;
    }

    private void flatten(List<DataDescriptor> result, List<DataDescriptor> tree) {
        for (DataDescriptor key : tree) {
            if (key.bad) {
                this.root.isBad = true;
                result.add(key);
                continue;
            }
            if (key.f == 3 && key.subKeys != null) {
                this.flatten(result, key.subKeys);
                continue;
            }
            if (key.f == 1) {
                ArrayList<DataDescriptor> subTree = new ArrayList<DataDescriptor>();
                this.flatten(subTree, key.subKeys);
                key.subKeys = subTree;
                result.add(key);
                continue;
            }
            result.add(key);
        }
    }

    private void operate(List<DataDescriptor> tree) {
        if (tree == null) {
            return;
        }
        boolean hasAssFields = false;
        DataDescriptor.AssociatedField assField = null;
        Iterator<DataDescriptor> iter = tree.iterator();
        while (iter.hasNext()) {
            DataDescriptor dd = iter.next();
            if (dd.f == 2) {
                if (dd.x == 1) {
                    this.changeWidth = dd.y == 0 ? null : dd;
                    iter.remove();
                    continue;
                }
                if (dd.x == 2) {
                    this.changeScale = dd.y == 0 ? null : dd;
                    iter.remove();
                    continue;
                }
                if (dd.x == 3) {
                    this.changeRefval = dd.y == 255 ? null : dd;
                    iter.remove();
                    continue;
                }
                if (dd.x == 4) {
                    assField = dd.y == 0 ? null : new DataDescriptor.AssociatedField(dd.y);
                    iter.remove();
                    hasAssFields = true;
                    continue;
                }
                if (dd.x == 5) {
                    dd.type = 1;
                    dd.bitWidth = dd.y * 8;
                    dd.name = "Note";
                    continue;
                }
                if (dd.x == 6) {
                    iter.remove();
                    if (dd.y == 0 || !iter.hasNext()) continue;
                    DataDescriptor next = iter.next();
                    next.bitWidth = dd.y;
                    continue;
                }
                if (dd.x == 7) {
                    this.changeWtf = dd.y == 0 ? null : dd;
                    iter.remove();
                    continue;
                }
                if (dd.x == 36) {
                    if (!iter.hasNext()) continue;
                    DataDescriptor dpi_dd = iter.next();
                    dd.dpi = this.dpi = new DataPresentIndicator(tree, dpi_dd);
                    dpi_dd.dpi = this.dpi;
                    continue;
                }
                if (dd.x == 37 && dd.y == 255) {
                    this.dpi = null;
                    continue;
                }
                if (dd.x != 24 || dd.y != 255) continue;
                dd.dpi = this.dpi;
                continue;
            }
            if (dd.subKeys != null) {
                this.operate(dd.subKeys);
                continue;
            }
            if (dd.f != 0) continue;
            if (dd.type != 3) {
                if (this.changeWidth != null) {
                    dd.bitWidth += this.changeWidth.y - 128;
                }
                if (this.changeScale != null) {
                    dd.scale += this.changeScale.y - 128;
                }
                if (this.changeRefval != null) {
                    dd.refVal += this.changeRefval.y - 128;
                }
                if (this.changeWtf != null && dd.type == 0) {
                    int y = this.changeWtf.y;
                    dd.scale += y;
                    dd.refVal = (int)((double)dd.refVal * Math.pow(10.0, y));
                    int wtf = (10 * y + 2) / 3;
                    dd.bitWidth += wtf;
                }
            }
            if (dd.f != 0 || assField == null) continue;
            ++assField.nfields;
            dd.assField = assField;
            assField.dataFldName = dd.name;
        }
        if (hasAssFields) {
            this.addAssFields(tree);
        }
    }

    private void addAssFields(List<DataDescriptor> tree) {
        if (tree == null) {
            return;
        }
        for (int index = 0; index < tree.size(); ++index) {
            DataDescriptor dd = tree.get(index);
            if (dd.assField == null) continue;
            DataDescriptor.AssociatedField assField = dd.assField;
            if (dd.f == 0 && dd.x == 31 && dd.y == 21) {
                dd.name = assField.dataFldName + "_associated_field_significance";
                dd.assField = null;
                continue;
            }
            DataDescriptor assDD = dd.makeAssociatedField(assField.nbits);
            tree.add(index, assDD);
            ++index;
        }
    }

    static class DataPresentIndicator {
        DataDescriptor dataPresent;
        List<DataDescriptor> linear = new ArrayList<DataDescriptor>();

        DataPresentIndicator(List<DataDescriptor> tree, DataDescriptor dpi_dd) {
            this.dataPresent = dpi_dd;
            this.linear = new ArrayList<DataDescriptor>();
            this.linearize(tree);
        }

        int getNfields() {
            return this.dataPresent.replication;
        }

        private void linearize(List<DataDescriptor> tree) {
            for (DataDescriptor dd : tree) {
                if (dd.f == 0) {
                    this.linear.add(dd);
                    continue;
                }
                if (dd.f != 1) continue;
                for (int i = 0; i < dd.replication; ++i) {
                    this.linearize(dd.getSubKeys());
                }
            }
        }
    }
}

