/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ft.point.remote.PointStream;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamIosp;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.IO;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class CdmremotePanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted messTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoTA;
    private TextHistoryPane infoPopup2;
    private TextHistoryPane infoPopup3;
    private IndependentWindow infoWindow2;
    private IndependentWindow infoWindow3;
    private NetcdfFile ncd;

    public CdmremotePanel(PreferencesExt prefs) {
        this.prefs = prefs;
        this.messTable = new BeanTableSorted(MessBean.class, (PreferencesExt)prefs.node("CdmMessage"), false);
        this.messTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MessBean bean = (MessBean)CdmremotePanel.this.messTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                CdmremotePanel.this.infoTA.setText(bean.getDesc());
            }
        });
        PopupMenu varPopup = new PopupMenu(this.messTable.getJTable(), "Options");
        varPopup.addAction("Show record -> variable data assignments", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessBean bean = (MessBean)CdmremotePanel.this.messTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                CdmremotePanel.this.infoTA.setText(bean.getDesc());
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoPopup2 = new TextHistoryPane();
        this.infoWindow2 = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup2);
        this.infoWindow2.setBounds((Rectangle)prefs.getBean("InfoWindowBounds2", new Rectangle(300, 300, 500, 300)));
        this.infoPopup3 = new TextHistoryPane();
        this.infoWindow3 = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup3);
        this.infoWindow3.setBounds((Rectangle)prefs.getBean("InfoWindowBounds3", new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.split2 = new JSplitPane(0, false, this.messTable, this.infoTA);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.add((Component)this.split2, "Center");
    }

    public void save() {
        this.messTable.saveState(false);
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
    }

    public void setNcStream(String stream) throws IOException {
        if (stream.startsWith("http:")) {
            this.setStream(stream);
        } else {
            this.setFile(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStream(String stream) throws IOException {
        if (this.ncd != null) {
            this.ncd.close();
        }
        long total = 0L;
        ArrayList<MessBean2> messages = new ArrayList<MessBean2>();
        InputStream is = null;
        try {
            System.out.printf("open %s%n", stream);
            is = IO.getInputStreamFromUrl(stream);
            block13: while (true) {
                Mess mess = new Mess();
                mess.magic = PointStream.readMagic(is);
                messages.add(new MessBean2(mess));
                if (mess.magic == PointStream.MessageType.Eos) {
                    break;
                }
                total += 4L;
                if (mess.magic == PointStream.MessageType.Start || mess.magic == PointStream.MessageType.End) continue;
                mess.vlen = NcStream.readVInt(is);
                byte[] m = new byte[mess.vlen];
                NcStream.readFully(is, m);
                total += (long)mess.vlen;
                switch (mess.magic) {
                    case Header: {
                        mess.obj = NcStreamProto.Header.parseFrom(m);
                        continue block13;
                    }
                    case Data: {
                        mess.obj = NcStreamProto.Data.parseFrom(m);
                        mess.dlen = NcStream.readVInt(is);
                        is.skip(mess.dlen);
                        total += (long)mess.dlen;
                        continue block13;
                    }
                    case Error: {
                        mess.obj = NcStreamProto.Error.parseFrom(m);
                        continue block13;
                    }
                    case StationList: {
                        mess.obj = PointStreamProto.StationList.parseFrom(m);
                        continue block13;
                    }
                    case PointFeatureCollection: {
                        mess.obj = PointStreamProto.PointFeatureCollection.parseFrom(m);
                        continue block13;
                    }
                    case PointFeature: {
                        mess.obj = PointStreamProto.PointFeature.parseFrom(m);
                        continue block13;
                    }
                }
                mess.obj = "unknown";
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.messTable.setBeans(messages);
        System.out.printf(" nmess = %d nbytes=%d%n", messages.size(), total);
    }

    public void closeOpenFiles() throws IOException {
        if (this.ncd != null) {
            this.ncd.close();
        }
        this.ncd = null;
    }

    public void setFile(String filename) throws IOException {
        ArrayList<MessBean> messages;
        block3: {
            this.closeOpenFiles();
            messages = new ArrayList<MessBean>();
            this.ncd = new MyNetcdfFile();
            NcStreamIosp iosp = new NcStreamIosp();
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(filename, "r");
                List<NcStreamIosp.NcsMess> ncm = iosp.open(raf, this.ncd);
                for (NcStreamIosp.NcsMess m : ncm) {
                    messages.add(new MessBean(m));
                }
            }
            catch (Exception e) {
                if (raf == null) break block3;
                raf.close();
            }
        }
        this.messTable.setBeans(messages);
        System.out.printf("mess = %d%n", messages.size());
    }

    public void showInfo(Formatter f) {
        if (this.ncd == null) {
            return;
        }
        f.format("%s", this.ncd.toString());
    }

    public class MessBean2
    extends MessBean {
        Mess mess;

        MessBean2() {
        }

        MessBean2(Mess m) {
            this.mess = m;
        }

        @Override
        public String getMagic() {
            return this.mess.magic.toString();
        }

        @Override
        public String getObjClass() {
            return this.mess.obj == null ? "" : this.mess.obj.getClass().toString();
        }

        @Override
        public String getDesc() {
            return this.mess.obj == null ? "" : this.mess.obj.toString();
        }

        @Override
        public int getSize() {
            return this.mess.vlen;
        }

        @Override
        public int getDSize() {
            return this.mess.dlen;
        }
    }

    public class MessBean {
        private NcStreamIosp.NcsMess m;

        MessBean() {
        }

        MessBean(NcStreamIosp.NcsMess m) {
            this.m = m;
        }

        public String getMagic() {
            return "";
        }

        public String getObjClass() {
            return this.m.what.getClass().toString();
        }

        public String getDesc() {
            return this.m.what.toString();
        }

        public int getSize() {
            return this.m.len;
        }

        public int getDSize() {
            return 0;
        }
    }

    class Mess {
        PointStream.MessageType magic;
        int vlen;
        int dlen;
        Object obj;

        Mess() {
        }
    }

    private static class MyNetcdfFile
    extends NetcdfFile {
        private MyNetcdfFile() {
        }
    }
}

