/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.catalog.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Authenticator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import thredds.catalog.CollectionType;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.InvDocumentation;
import thredds.catalog.ThreddsMetadata;
import thredds.ui.datatype.prefs.DateField;
import thredds.ui.datatype.prefs.DurationField;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.thredds.MetadataExtractor;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.RangeDateSelector;
import ucar.nc2.ui.widget.UrlAuthenticatorDialog;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.util.prefs.ui.Field;
import ucar.util.prefs.ui.PersistentBean;
import ucar.util.prefs.ui.PrefPanel;

public class DatasetEditor
extends JPanel {
    private static final String NAME = "name";
    private static final String ID = "ID";
    private static final String AUTHORITY = "authority";
    private static final String SERVICE_NAME = "serviceName";
    private static final String FORMAT_TYPE = "dataFormatType";
    private static final String DATA_TYPE = "dataType";
    private static final String COLLECTION_TYPE = "collectionType";
    private static final String GC_TYPE = "gcType";
    private static final String TC_TYPE = "tcType";
    private static final String LAT_START = "latStart";
    private static final String LAT_EXTENT = "latExtent";
    private static final String LAT_RESOLUTION = "latResolution";
    private static final String LAT_UNITS = "latUnits";
    private static final String LON_START = "lonStart";
    private static final String LON_EXTENT = "lonExtent";
    private static final String LON_RESOLUTION = "lonResolution";
    private static final String LON_UNITS = "lonUnits";
    private static final String HEIGHT_START = "heightStart";
    private static final String HEIGHT_EXTENT = "heightExtent";
    private static final String HEIGHT_RESOLUTION = "heightResolution";
    private static final String HEIGHT_UNITS = "heightUnits";
    private static final String ZPOSITIVE_UP = "ZPositiveUp";
    private static final String HARVEST = "harvest";
    private static final String SUMMARY = "summary";
    private static final String RIGHTS = "rights";
    private static final String HISTORY = "history";
    private static final String PROCESSING = "processing";
    private static final String VARIABLES = "variables";
    private static final String CREATORS = "creators";
    private static final String PUBLISHERS = "publishers";
    private static final String PROJECTS = "projects";
    private static final String KEYWORDS = "keywords";
    private static final String DATES = "dates";
    private static final String CONTRIBUTORS = "contributors";
    private static final String DOCUMENTATION = "documentationLinks";
    private static final ArrayList inherit_types = new ArrayList();
    private static final String LOCAL = "Local";
    private static final String INHERITABLE = "Local, Inheritable";
    private static final String INHERITED = "Inherited";
    private Field gc_type;
    private Field tc_type;
    private Field.BeanTable variablesFld;
    private Field.BeanTable creatorsFld;
    private Field.BeanTable publishersFld;
    private Field.BeanTable projectsFld;
    private Field.BeanTable keywordsFld;
    private Field.BeanTable datesFld;
    private Field.BeanTable contributorsFld;
    private Field.BeanTable docsFld;
    private ArrayList tables = new ArrayList();
    private RangeDateSelector dateRangeSelector;
    private JButton extractGCButton;
    private JButton extractVButton;
    private PrefPanel metadataPP;
    private PrefPanel dscanPP;
    private IndependentWindow dscanWindow;
    private JButton exampleButton;
    private InvDatasetImpl dataset;
    private InvDatasetImpl leafDataset;
    private static final String DSCAN_PATH = "path";
    private static final String DSCAN_DIR = "scanDir";
    private static final String DSCAN_ADDSIZE = "addDatasetSize";
    private Color actionColor = new Color(142, 0, 100);
    private Color normalColor = Color.black;
    private Color inheritedColor = Color.blue;
    private Color inheritableColor = Color.red;
    private static InvCatalogImpl cat;

    public DatasetEditor() {
        JTabbedPane tabs = new JTabbedPane();
        this.metadataPP = new PrefPanel("Edit Catalog Dataset", null, null);
        tabs.add("metadata", this.metadataPP);
        int row = 0;
        this.metadataPP.addHeading("Basic", row++);
        this.metadataPP.addTextField(NAME, "Name", "", 0, row++, "8,1");
        this.metadataPP.addTextField(ID, ID, "", 0, row, null);
        this.addPopups(this.metadataPP.addTextField(AUTHORITY, "Authority", "", 2, row, null));
        this.addPopups(this.metadataPP.addTextField(SERVICE_NAME, "Service", "", 4, row, null));
        this.addPopups(this.metadataPP.addEnumComboField(FORMAT_TYPE, "Data format", DataFormatType.getAllTypes(), true, 0, ++row, null));
        this.addPopups(this.metadataPP.addEnumComboField(DATA_TYPE, "Data type", Arrays.asList(FeatureType.values()), true, 2, row, null));
        this.metadataPP.addEnumComboField(COLLECTION_TYPE, "Collection type", CollectionType.getAllTypes(), true, 4, row++, null);
        this.metadataPP.addHeading("GeoSpatial Coverage", row++);
        this.gc_type = this.metadataPP.addEnumComboField(GC_TYPE, "type", inherit_types, false, 0, row, null);
        this.gc_type.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String mode = (String)DatasetEditor.this.gc_type.getValue();
                DatasetEditor.this.setGCmode(DatasetEditor.this.getMode(mode));
            }
        });
        this.extractGCButton = this.makeButton("Extract Geospatial");
        this.extractGCButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetEditor.this.extractGeospatial();
            }
        });
        this.metadataPP.addComponent(this.extractGCButton, 2, row, "left, center");
        this.metadataPP.addCheckBoxField(ZPOSITIVE_UP, "Z positive up", false, 4, row);
        this.metadataPP.addDoubleField(LAT_START, "Starting Latitude", 0.0, 5, 0, ++row, null);
        this.metadataPP.addDoubleField(LAT_EXTENT, "Size", 0.0, 5, 2, row, null);
        this.metadataPP.addDoubleField(LAT_RESOLUTION, "Resolution", 0.0, 5, 4, row, null);
        this.metadataPP.addTextField(LAT_UNITS, "Units", "", 6, row, null);
        this.metadataPP.addDoubleField(LON_START, "Starting Longitude", 0.0, 5, 0, row + 1, null);
        this.metadataPP.addDoubleField(LON_EXTENT, "Size", 0.0, 5, 2, row + 1, null);
        this.metadataPP.addDoubleField(LON_RESOLUTION, "Resolution", 0.0, 5, 4, row + 1, null);
        this.metadataPP.addTextField(LON_UNITS, "Units", "", 6, row + 1, null);
        this.metadataPP.addDoubleField(HEIGHT_START, "Starting Height", 0.0, 5, 0, row + 2, null);
        this.metadataPP.addDoubleField(HEIGHT_EXTENT, "Size", 0.0, 5, 2, row + 2, null);
        this.metadataPP.addDoubleField(HEIGHT_RESOLUTION, "Resolution", 0.0, 5, 4, row + 2, null);
        this.metadataPP.addTextField(HEIGHT_UNITS, "Units", "", 6, row + 2, null);
        row += 3;
        this.metadataPP.addHeading("Temporal Coverage", row++);
        this.tc_type = this.metadataPP.addEnumComboField(TC_TYPE, "type", inherit_types, false, 0, row++, null);
        this.tc_type.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String mode = (String)DatasetEditor.this.tc_type.getValue();
                DatasetEditor.this.setTCmode(DatasetEditor.this.getMode(mode));
            }
        });
        DateRange range = null;
        try {
            range = new DateRange();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dateRangeSelector = new RangeDateSelector("", range, false, false, null, false, false);
        DateField minDateField = this.dateRangeSelector.getMinDateField();
        DateField maxDateField = this.dateRangeSelector.getMaxDateField();
        DurationField durationField = this.dateRangeSelector.getDurationField();
        DurationField resolutionField = this.dateRangeSelector.getResolutionField();
        this.metadataPP.addField(minDateField, 0, row, null);
        this.metadataPP.addField(maxDateField, 2, row, null);
        this.metadataPP.addField(durationField, 4, row, null);
        this.metadataPP.addField(resolutionField, 6, row++, null);
        this.metadataPP.addHeading("Digital Library Info", row++);
        this.metadataPP.addCheckBoxField(HARVEST, "Harvest", false, 0, row++);
        this.addPopups(this.metadataPP.addTextAreaField(SUMMARY, "Summary", null, 7, 0, row, "3,1"));
        this.addPopups(this.metadataPP.addTextAreaField(RIGHTS, "Rights", null, 2, 0, row + 1, "3,1"));
        this.addPopups(this.metadataPP.addTextAreaField(HISTORY, "History", null, 7, 4, row, "3,1"));
        this.addPopups(this.metadataPP.addTextAreaField(PROCESSING, "Process", null, 2, 4, row + 1, "3,1"));
        row += 2;
        this.metadataPP.addEmptyRow(row++, 10);
        JTabbedPane tabPane = new JTabbedPane();
        this.metadataPP.addComponent(tabPane, 0, row++, "8,1");
        this.tables = new ArrayList();
        tabPane.addTab("Variables", this.makeVariablesPanel());
        this.tables.add(this.variablesFld);
        this.creatorsFld = new Field.BeanTable(CREATORS, "Creators", null, ThreddsMetadata.Source.class, null, null);
        tabPane.addTab("Creators", this.creatorsFld.getEditComponent());
        this.tables.add(this.creatorsFld);
        this.publishersFld = new Field.BeanTable(PUBLISHERS, "Publishers", null, ThreddsMetadata.Source.class, null, null);
        tabPane.addTab("Publishers", this.publishersFld.getEditComponent());
        this.tables.add(this.publishersFld);
        this.projectsFld = new Field.BeanTable(PROJECTS, "Projects", null, ThreddsMetadata.Vocab.class, null, null);
        tabPane.addTab("Projects", this.projectsFld.getEditComponent());
        this.tables.add(this.projectsFld);
        this.keywordsFld = new Field.BeanTable(KEYWORDS, "Keywords", null, ThreddsMetadata.Vocab.class, null, null);
        tabPane.addTab("Keywords", this.keywordsFld.getEditComponent());
        this.tables.add(this.keywordsFld);
        this.datesFld = new Field.BeanTable(DATES, "Dates", null, DateType.class, null, null);
        tabPane.addTab("Dates", this.datesFld.getEditComponent());
        this.tables.add(this.datesFld);
        this.contributorsFld = new Field.BeanTable(CONTRIBUTORS, "Contributors", null, ThreddsMetadata.Contributor.class, null, null);
        tabPane.addTab("Contributors", this.contributorsFld.getEditComponent());
        this.tables.add(this.contributorsFld);
        this.docsFld = new Field.BeanTable(DOCUMENTATION, "Documentation", null, InvDocumentation.class, null, null);
        tabPane.addTab("Documentation", this.docsFld.getEditComponent());
        this.tables.add(this.docsFld);
        for (int i = 0; i < this.tables.size(); ++i) {
            this.addPopups((Field.BeanTable)this.tables.get(i));
        }
        this.metadataPP.finish(false);
        this.makeDscanPanel();
        tabs.add("datasetScan", this.dscanPP);
        this.setLayout(new BorderLayout());
        this.add((Component)tabs, "Center");
    }

    private void makeDscanPanel() {
        this.dscanPP = new PrefPanel("dscan", null);
        int row = 0;
        this.dscanPP.addCheckBoxField(DSCAN_ADDSIZE, "Add File Size", false, 0, row++);
        this.dscanPP.addTextField(DSCAN_PATH, "Path", "", 0, row++, null);
        this.dscanPP.addTextField(DSCAN_DIR, "Directory Location", "", 0, row++, null);
        this.dscanPP.addEmptyRow(row++, 2);
        this.dscanPP.addHeading("Time Coverage", row++);
        this.exampleButton = this.makeButton("Example filename");
        this.exampleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvDatasetImpl leaf = DatasetEditor.this.findLeafDataset(DatasetEditor.this.dataset);
                DatasetEditor.this.exampleButton.setText(leaf == null ? "ERR" : leaf.getName());
            }
        });
        this.dscanPP.addComponent(this.exampleButton, 0, row++, null);
        this.dscanPP.finish(false);
        this.dscanWindow = new IndependentWindow("DatasetScan options", BAMutil.getImage("thredds"), this.dscanPP);
        this.dscanWindow.setBounds(new Rectangle(150, 50, 700, 300));
    }

    private JPanel makeVariablesPanel() {
        this.variablesFld = new Field.BeanTable(VARIABLES, "Variables", null, ThreddsMetadata.Variable.class, null, null);
        this.extractVButton = this.makeButton("Extract Variables");
        this.extractVButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetEditor.this.extractVariables();
            }
        });
        JPanel buttPanel = new JPanel(new FlowLayout(0, 5, 0));
        buttPanel.add(this.extractVButton);
        JPanel vPanel = new JPanel(new BorderLayout());
        vPanel.add((Component)buttPanel, "North");
        vPanel.add((Component)this.variablesFld.getEditComponent(), "Center");
        return vPanel;
    }

    private JButton makeButton(String name) {
        JButton b = new JButton(name);
        b.setForeground(this.actionColor);
        return b;
    }

    private void addPopups(Field fld) {
        fld.addPopupMenuAction("local", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetEditor.this.setMode((Field)e.getSource(), 0);
            }
        });
        fld.addPopupMenuAction("inheritable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetEditor.this.setMode((Field)e.getSource(), 1);
            }
        });
    }

    public InvDatasetImpl getDataset() {
        return this.dataset;
    }

    public boolean setDataset(InvDatasetImpl ds) {
        if (!this.accept()) {
            return false;
        }
        this.dataset = ds;
        this.leafDataset = null;
        this.exampleButton.setText("Example Dataset");
        PersistentBean persBean = new PersistentBean(ds);
        this.setEditValue(NAME, persBean, 0);
        this.setEditValue(ID, persBean, 0);
        this.setEditValueWithInheritence(AUTHORITY, persBean);
        this.setEditValueWithInheritence(SERVICE_NAME, persBean);
        this.setEditValueWithInheritence(FORMAT_TYPE, persBean);
        this.setEditValueWithInheritence(DATA_TYPE, persBean);
        this.setEditValue(COLLECTION_TYPE, persBean, 0);
        this.setEditValue(HARVEST, persBean, 0);
        int mode = 0;
        ThreddsMetadata.GeospatialCoverage gc = ds.getLocalMetadata().getGeospatialCoverage();
        if (gc == null || gc.isEmpty()) {
            gc = ds.getLocalMetadataInheritable().getGeospatialCoverage();
            mode = 1;
        }
        if (gc == null || gc.isEmpty()) {
            gc = ds.getGeospatialCoverage();
            mode = 2;
        }
        this.metadataPP.setFieldValue(GC_TYPE, inherit_types.get(mode));
        this.setGC(gc, mode);
        mode = 0;
        CalendarDateRange tc = ds.getLocalMetadata().getCalendarDateCoverage();
        if (tc == null) {
            tc = ds.getLocalMetadataInheritable().getCalendarDateCoverage();
            mode = 1;
        }
        if (tc == null) {
            tc = ds.getCalendarDateCoverage();
            mode = 2;
        }
        this.metadataPP.setFieldValue(TC_TYPE, inherit_types.get(mode));
        if (tc != null) {
            this.dateRangeSelector.setDateRange(tc.toDateRange());
        }
        this.setTCmode(mode);
        this.setEditValueWithInheritence(SUMMARY, persBean);
        this.setEditValueWithInheritence(RIGHTS, persBean);
        this.setEditValueWithInheritence(HISTORY, persBean);
        this.setEditValueWithInheritence(PROCESSING, persBean);
        this.setVariables(this.variablesFld);
        this.setBeanList(this.creatorsFld, CREATORS, persBean);
        this.setBeanList(this.publishersFld, PUBLISHERS, persBean);
        this.setBeanList(this.projectsFld, PROJECTS, persBean);
        this.setBeanList(this.keywordsFld, KEYWORDS, persBean);
        this.setBeanList(this.datesFld, DATES, persBean);
        this.setBeanList(this.contributorsFld, CONTRIBUTORS, persBean);
        this.setBeanList(this.docsFld, DOCUMENTATION, persBean);
        if (ds instanceof InvDatasetScan) {
            this.dscanPP.setEnabled(true);
            this.setEditValue(this.dscanPP, DSCAN_PATH, persBean, 0);
            this.setEditValue(this.dscanPP, DSCAN_DIR, persBean, 0);
            this.setEditValue(this.dscanPP, DSCAN_ADDSIZE, persBean, 0);
        } else {
            this.dscanPP.setEnabled(false);
        }
        return true;
    }

    private void setGC(ThreddsMetadata.GeospatialCoverage gc, int mode) {
        PersistentBean gcBean = gc == null ? null : new PersistentBean(gc);
        this.setEditValue(LAT_START, gcBean, mode);
        this.setEditValue(LAT_EXTENT, gcBean, mode);
        this.setEditValue(LAT_RESOLUTION, gcBean, mode);
        this.setEditValue(LAT_UNITS, gcBean, mode);
        this.setEditValue(LON_START, gcBean, mode);
        this.setEditValue(LON_EXTENT, gcBean, mode);
        this.setEditValue(LON_RESOLUTION, gcBean, mode);
        this.setEditValue(LON_UNITS, gcBean, mode);
        this.setEditValue(HEIGHT_START, gcBean, mode);
        this.setEditValue(HEIGHT_EXTENT, gcBean, mode);
        this.setEditValue(HEIGHT_RESOLUTION, gcBean, mode);
        this.setEditValue(HEIGHT_UNITS, gcBean, mode);
        this.setEditValue(ZPOSITIVE_UP, gcBean, mode);
        this.extractGCButton.setEnabled(mode != 2);
    }

    private void setGCmode(int mode) {
        this.setMode(this.metadataPP.getField(LAT_START), mode);
        this.setMode(this.metadataPP.getField(LAT_EXTENT), mode);
        this.setMode(this.metadataPP.getField(LAT_RESOLUTION), mode);
        this.setMode(this.metadataPP.getField(LAT_UNITS), mode);
        this.setMode(this.metadataPP.getField(LON_START), mode);
        this.setMode(this.metadataPP.getField(LON_EXTENT), mode);
        this.setMode(this.metadataPP.getField(LON_RESOLUTION), mode);
        this.setMode(this.metadataPP.getField(LON_UNITS), mode);
        this.setMode(this.metadataPP.getField(HEIGHT_START), mode);
        this.setMode(this.metadataPP.getField(HEIGHT_EXTENT), mode);
        this.setMode(this.metadataPP.getField(HEIGHT_RESOLUTION), mode);
        this.setMode(this.metadataPP.getField(HEIGHT_UNITS), mode);
        this.setMode(this.metadataPP.getField(ZPOSITIVE_UP), mode);
        this.extractGCButton.setEnabled(mode != 2);
    }

    private void setTCmode(int mode) {
        this.setMode(this.metadataPP.getField("start"), mode);
        this.setMode(this.metadataPP.getField("end"), mode);
        this.setMode(this.metadataPP.getField("duration"), mode);
        this.setMode(this.metadataPP.getField("resolution"), mode);
    }

    private void setVariables(Field.BeanTable beanTable) {
        List variableLists = this.dataset.getLocalMetadata().getVariables();
        if (variableLists != null && variableLists.size() > 0) {
            ThreddsMetadata.Variables vars = (ThreddsMetadata.Variables)variableLists.get(0);
            beanTable.setValue(vars.getVariableList());
            this.setMode(beanTable, 0);
            return;
        }
        variableLists = this.dataset.getLocalMetadataInheritable().getVariables();
        if (variableLists != null && variableLists.size() > 0) {
            ThreddsMetadata.Variables vars = (ThreddsMetadata.Variables)variableLists.get(0);
            beanTable.setValue(vars.getVariableList());
            this.setMode(beanTable, 1);
            return;
        }
        variableLists = this.dataset.getVariables();
        if (variableLists != null && variableLists.size() > 0) {
            ThreddsMetadata.Variables vars = (ThreddsMetadata.Variables)variableLists.get(0);
            beanTable.setValue(vars.getVariableList());
            this.setMode(beanTable, vars == null || vars.getVariableList().size() == 0 ? 1 : 2);
            return;
        }
        beanTable.setValue(new ArrayList());
    }

    private void setEditValue(String name, PersistentBean bean, int mode) {
        this.setEditValue(this.metadataPP, name, bean, mode);
    }

    private void setEditValue(PrefPanel pp, String name, PersistentBean bean, int mode) {
        Field fld = pp.getField(name);
        if (bean == null) {
            fld.setValue(null);
        } else {
            Object value = bean.getObject(name);
            fld.setValue(value);
        }
        this.setMode(fld, mode);
    }

    private void setEditValueWithInheritence(String name, PersistentBean bean) {
        Field fld = this.metadataPP.getField(name);
        if (bean == null) {
            fld.setValue(null);
            return;
        }
        Object value = bean.getObject("localMetadata." + name);
        if (value != null) {
            fld.setValue(value);
            this.setMode(fld, 0);
        } else {
            value = bean.getObject("localMetadataInheritable." + name);
            if (value != null) {
                fld.setValue(value);
                this.setMode(fld, 1);
            } else {
                value = bean.getObject(name);
                fld.setValue(value);
                this.setMode(fld, value == null ? 1 : 2);
            }
        }
    }

    private void setBeanList(Field.BeanTable beanTable, String name, PersistentBean bean) {
        List value = (List)bean.getObject("localMetadata." + name);
        if (value != null && value.size() > 0) {
            beanTable.setValue(value);
            this.setMode(beanTable, 0);
        } else {
            value = (List)bean.getObject("localMetadataInheritable." + name);
            if (value != null && value.size() > 0) {
                beanTable.setValue(value);
                this.setMode(beanTable, 1);
            } else {
                value = (List)bean.getObject(name);
                beanTable.setValue(value);
                this.setMode(beanTable, value == null || value.size() == 0 ? 1 : 2);
            }
        }
    }

    private int getMode(String want_mode) {
        for (int i = 0; i < inherit_types.size(); ++i) {
            String mode = (String)inherit_types.get(i);
            if (!mode.equals(want_mode)) continue;
            return i;
        }
        return -1;
    }

    private void setMode(Field fld, int mode) {
        if (mode == 1) {
            this.setColor(fld, this.inheritableColor);
        } else if (mode == 2) {
            this.setColor(fld, this.inheritedColor);
        } else {
            this.setColor(fld, this.normalColor);
        }
        fld.setEnabled(mode != 2);
    }

    private void setColor(Field fld, Color color) {
        fld.getDeepEditComponent().setForeground(color);
    }

    private boolean isInheritable(Field fld) {
        return fld.getDeepEditComponent().getForeground().equals(this.inheritableColor);
    }

    public boolean accept() {
        if (this.dataset == null) {
            return true;
        }
        boolean ok = this.metadataPP.accept();
        boolean ok2 = this.dscanPP.accept();
        if (ok && ok2) {
            this.store2Dataset();
        }
        return ok && ok2;
    }

    public void store2Dataset() {
        String tcType;
        PersistentBean persBean = new PersistentBean(this.dataset);
        this.setStoreValue(NAME, persBean, false);
        this.setStoreValue(ID, persBean, false);
        this.setStoreValue(AUTHORITY, persBean, true);
        this.setStoreValue(SERVICE_NAME, persBean, true);
        this.setStoreValue(FORMAT_TYPE, persBean, true);
        this.setStoreValue(DATA_TYPE, persBean, true);
        this.setStoreValue(COLLECTION_TYPE, persBean, false);
        this.setStoreValue(HARVEST, persBean, false);
        String gcType = (String)this.metadataPP.getFieldValue(GC_TYPE);
        if (!gcType.equals(INHERITED)) {
            ThreddsMetadata.GeospatialCoverage gc = new ThreddsMetadata.GeospatialCoverage();
            this.storeGC(new PersistentBean(gc));
            if (gcType.equals(LOCAL)) {
                this.dataset.getLocalMetadata().setGeospatialCoverage(gc);
                this.dataset.getLocalMetadataInheritable().setGeospatialCoverage(null);
            } else {
                this.dataset.getLocalMetadata().setGeospatialCoverage(null);
                this.dataset.getLocalMetadataInheritable().setGeospatialCoverage(gc);
            }
        }
        if (!(tcType = (String)this.metadataPP.getFieldValue(TC_TYPE)).equals(INHERITED)) {
            DateRange dateRange = this.dateRangeSelector.getDateRange();
            if (tcType.equals(LOCAL)) {
                this.dataset.getLocalMetadata().setTimeCoverage(dateRange);
                this.dataset.getLocalMetadataInheritable().setTimeCoverage((DateRange)null);
            } else {
                this.dataset.getLocalMetadata().setTimeCoverage((DateRange)null);
                this.dataset.getLocalMetadataInheritable().setTimeCoverage(dateRange);
            }
        }
        this.setStoreValue(SUMMARY, persBean, true);
        this.setStoreValue(RIGHTS, persBean, true);
        this.setStoreValue(HISTORY, persBean, true);
        this.setStoreValue(PROCESSING, persBean, true);
        this.storeBeanList(this.creatorsFld, CREATORS, persBean);
        this.storeBeanList(this.publishersFld, PUBLISHERS, persBean);
        this.storeBeanList(this.projectsFld, PROJECTS, persBean);
        this.storeBeanList(this.keywordsFld, KEYWORDS, persBean);
        this.storeBeanList(this.datesFld, DATES, persBean);
        this.storeBeanList(this.contributorsFld, CONTRIBUTORS, persBean);
        this.storeBeanList(this.docsFld, DOCUMENTATION, persBean);
        if (this.dataset instanceof InvDatasetScan) {
            this.setStoreValue(this.dscanPP, DSCAN_PATH, persBean, false);
            this.setStoreValue(this.dscanPP, DSCAN_DIR, persBean, false);
            this.setStoreValue(this.dscanPP, DSCAN_ADDSIZE, persBean, false);
        }
        this.dataset.finish();
    }

    private void storeGC(PersistentBean gcBean) {
        this.setStoreValue(LAT_START, gcBean, false);
        this.setStoreValue(LAT_EXTENT, gcBean, false);
        this.setStoreValue(LAT_RESOLUTION, gcBean, false);
        this.setStoreValue(LAT_UNITS, gcBean, false);
        this.setStoreValue(LON_START, gcBean, false);
        this.setStoreValue(LON_EXTENT, gcBean, false);
        this.setStoreValue(LON_RESOLUTION, gcBean, false);
        this.setStoreValue(LON_UNITS, gcBean, false);
        this.setStoreValue(HEIGHT_START, gcBean, false);
        this.setStoreValue(HEIGHT_EXTENT, gcBean, false);
        this.setStoreValue(HEIGHT_RESOLUTION, gcBean, false);
        this.setStoreValue(HEIGHT_UNITS, gcBean, false);
        this.setStoreValue(ZPOSITIVE_UP, gcBean, false);
    }

    private void setStoreValue(String name, PersistentBean bean, boolean inheritable) {
        this.setStoreValue(this.metadataPP, name, bean, inheritable);
    }

    private void setStoreValue(PrefPanel pp, String name, PersistentBean bean, boolean inheritable) {
        Object oldValue;
        if (bean == null) {
            return;
        }
        Field fld = pp.getField(name);
        Object newValue = fld.getValue();
        if (newValue == (oldValue = bean.getObject(name))) {
            return;
        }
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        if (!inheritable) {
            bean.putObject(name, newValue);
        } else if (this.isInheritable(fld)) {
            bean.putObject("localMetadataInheritable." + name, newValue);
        } else {
            bean.putObject("localMetadata." + name, newValue);
        }
    }

    private void storeBeanList(Field.BeanTable beanTable, String name, PersistentBean bean) {
        List oldValue;
        if (bean == null) {
            return;
        }
        List newValue = (List)beanTable.getValue();
        if (((Object)newValue).equals(oldValue = (List)bean.getObject(name))) {
            return;
        }
        if (this.isInheritable(beanTable)) {
            bean.putObject("localMetadataInheritable." + name, newValue);
        } else {
            bean.putObject("localMetadata." + name, newValue);
        }
    }

    public InvDatasetImpl getExtractedDataset() {
        if (this.leafDataset == null) {
            this.leafDataset = this.findLeafDataset(this.dataset);
        }
        return this.leafDataset;
    }

    private void extractGeospatial() {
        if (this.leafDataset == null) {
            this.leafDataset = this.findLeafDataset(this.dataset);
        }
        if (this.leafDataset != null) {
            ThreddsMetadata.GeospatialCoverage gc = null;
            try {
                gc = MetadataExtractor.extractGeospatial((InvDatasetImpl)this.leafDataset);
            }
            catch (IOException e) {
                return;
            }
            if (gc != null) {
                this.setGC(gc, 1);
            }
        }
    }

    private void extractVariables() {
        if (this.leafDataset == null) {
            this.leafDataset = this.findLeafDataset(this.dataset);
        }
        if (this.leafDataset == null) {
            return;
        }
        ThreddsMetadata.Variables vars = null;
        try {
            vars = MetadataExtractor.extractVariables((InvDatasetImpl)this.leafDataset);
        }
        catch (IOException e) {
            return;
        }
        if (vars != null) {
            ThreddsMetadata tm = this.dataset.getLocalMetadataInheritable();
            List varsList = tm.getVariables();
            boolean replaced = false;
            for (int i = 0; i < varsList.size(); ++i) {
                ThreddsMetadata.Variables vs = (ThreddsMetadata.Variables)varsList.get(i);
                if (!vs.getVocabulary().equals(vars.getVocabulary())) continue;
                varsList.set(i, vars);
                replaced = true;
                break;
            }
            if (!replaced) {
                tm.addVariables(vars);
            }
            this.variablesFld.setValue(vars.getVariableList());
            this.setMode(this.variablesFld, 1);
            return;
        }
    }

    private InvDatasetImpl findLeafDataset(InvDatasetImpl ds) {
        this.leafDataset = this.getLeafDataset(ds);
        return this.leafDataset;
    }

    private InvDatasetImpl getLeafDataset(InvDatasetImpl ds) {
        if (ds == null) {
            return null;
        }
        System.out.println("getLeafDataset " + ds.getFullName());
        List nestedList = ds.getDatasets();
        for (int i = 0; i < nestedList.size(); ++i) {
            InvDatasetImpl nestedDS = (InvDatasetImpl)nestedList.get(i);
            if (nestedDS.hasAccess() && !nestedDS.hasNestedDatasets()) {
                InvDatasetImpl result = this.chooseLeafDataset(nestedList);
                return result.hasAccess() ? result : nestedDS;
            }
            InvDatasetImpl leaf = this.getLeafDataset(nestedDS);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    private InvDatasetImpl chooseLeafDataset(List nestedList) {
        int size = nestedList.size();
        return (InvDatasetImpl)nestedList.get(size / 2);
    }

    public static void main(String[] args) {
        final DatasetEditor editor = new DatasetEditor();
        JFrame frame = new JFrame("Test DatasetEditor");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JButton save = new JButton("Accept");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                editor.accept();
                editor.store2Dataset();
                try {
                    cat.writeXML((OutputStream)System.out, true);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)editor, "Center");
        main.add((Component)save, "North");
        frame.getContentPane().add(main);
        frame.pack();
        frame.setLocation(150, 10);
        frame.setVisible(true);
        Authenticator.setDefault(new UrlAuthenticatorDialog(frame));
        String url = "http://motherlode.ucar.edu:8088/thredds/content/idd/models.xml";
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory((boolean)true);
        cat = catFactory.readXML(url);
        InvDatasetImpl ds = (InvDatasetImpl)cat.findDatasetByID("NCEP/NAM/V");
        editor.setDataset(ds);
    }

    static {
        inherit_types.add(LOCAL);
        inherit_types.add(INHERITABLE);
        inherit_types.add(INHERITED);
    }
}

