/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.grib.grib2.table.WmoCodeTable;
import ucar.nc2.ui.dialog.Grib1TableDialog;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.units.SimpleUnit;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class Grib2TablesViewer
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted gribTable;
    private BeanTableSorted entryTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private Grib1TableDialog dialog;

    public Grib2TablesViewer(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.gribTable = new BeanTableSorted(TableBean.class, (PreferencesExt)prefs.node("CodeTableBean"), false);
        this.gribTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TableBean csb = (TableBean)Grib2TablesViewer.this.gribTable.getSelectedBean();
                Grib2TablesViewer.this.setEntries(csb.table);
            }
        });
        PopupMenu varPopup = new PopupMenu(this.gribTable.getJTable(), "Options");
        varPopup.addAction("Compare two tables", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = Grib2TablesViewer.this.gribTable.getSelectedBeans();
                if (list.size() == 2) {
                    TableBean bean1 = (TableBean)list.get(0);
                    TableBean bean2 = (TableBean)list.get(1);
                    Grib2TablesViewer.this.compareTables(bean1.table, bean2.table);
                }
            }
        });
        this.entryTable = new BeanTableSorted(EntryBean.class, (PreferencesExt)prefs.node("EntryBean"), false);
        this.entryTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EntryBean csb = (EntryBean)Grib2TablesViewer.this.entryTable.getSelectedBean();
            }
        });
        AbstractButton dupButton = BAMutil.makeButtcon("Select", "Look for problems in this table", false);
        dupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2TablesViewer.this.lookForProblems();
            }
        });
        buttPanel.add(dupButton);
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 800, 600)));
        this.split = new JSplitPane(0, false, this.gribTable, this.entryTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
        AbstractButton infoButton = BAMutil.makeButtcon("Information", "Show Table Used", false);
        infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Grib2TablesViewer.this.dialog == null) {
                    Grib2TablesViewer.this.dialog = new Grib1TableDialog((Frame)null);
                    Grib2TablesViewer.this.dialog.pack();
                }
                Grib2TablesViewer.this.dialog.setVisible(true);
            }
        });
        buttPanel.add(infoButton);
        try {
            List tables = Grib2Customizer.getTableIds();
            ArrayList<TableBean> beans = new ArrayList<TableBean>(tables.size());
            for (Grib2Customizer.GribTableId t : tables) {
                beans.add(new TableBean(t));
            }
            Collections.sort(beans);
            this.gribTable.setBeans(beans);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        this.gribTable.saveState(false);
        this.entryTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public void setEntries(Grib2Customizer.GribTableId tableId) {
        Grib2Customizer gt = Grib2Customizer.factory((int)tableId.center, (int)tableId.subCenter, (int)tableId.masterVersion, (int)tableId.localVersion);
        List params = gt.getParameters();
        ArrayList<EntryBean> beans = new ArrayList<EntryBean>(params.size());
        for (Object p : params) {
            beans.add(new EntryBean((GribTables.Parameter)p));
        }
        this.entryTable.setBeans(beans);
    }

    public void lookForProblems() {
        int total = 0;
        int probs = 0;
        Formatter f = new Formatter();
        f.format("PROBLEMS with units%n", new Object[0]);
        for (Object t : this.entryTable.getBeans()) {
            GribTables.Parameter p = ((EntryBean)t).param;
            if (p.getUnit() == null || p.getUnit().length() == 0) continue;
            try {
                SimpleUnit su = SimpleUnit.factoryWithExceptions((String)p.getUnit());
                if (su.isUnknownUnit()) {
                    f.format("%s '%s' has UNKNOWN udunit%n", p.getId(), p.getUnit());
                    ++probs;
                }
            }
            catch (Exception ioe) {
                f.format("%s '%s' FAILS on udunit parse%n", p.getId(), p.getUnit());
                ++probs;
            }
            ++total;
        }
        f.format("%nUNITS: Total=%d problems=%d%n%n", total, probs);
        int extra = 0;
        int nameDiffers = 0;
        int caseDiffers = 0;
        int unitsDiffer = 0;
        f.format("Conflicts with WMO%n", new Object[0]);
        for (Object t : this.entryTable.getBeans()) {
            boolean caseDiffer;
            GribTables.Parameter p = ((EntryBean)t).param;
            if (Grib2Customizer.isLocal((GribTables.Parameter)p)) continue;
            WmoCodeTable.TableEntry wmo = WmoCodeTable.getParameterEntry((int)p.getDiscipline(), (int)p.getCategory(), (int)p.getNumber());
            if (wmo == null) {
                ++extra;
                f.format(" NEW %s%n", p);
                continue;
            }
            if (p.getName().equals(wmo.getName()) && p.getUnit().equals(wmo.getUnit())) continue;
            boolean nameDiffer = !p.getName().equals(wmo.getName());
            boolean bl = caseDiffer = nameDiffer && p.getName().equalsIgnoreCase(wmo.getName());
            if (nameDiffer) {
                ++nameDiffers;
            }
            if (caseDiffer) {
                ++caseDiffers;
            }
            if (!p.getUnit().equals(wmo.getUnit())) {
                ++unitsDiffer;
            }
            f.format("this=%10s %40s %15s%n", p.getId(), p.getName(), p.getUnit());
            f.format(" wmo=%10s %40s %15s%n%n", wmo.getId(), wmo.getName(), wmo.getUnit());
        }
        f.format("%nWMO differences: nameDiffers=%d caseDiffers=%d, unitsDiffer=%d, extra=%d%n%n", nameDiffers, caseDiffers, unitsDiffer, extra);
        this.infoTA.setText(f.toString());
        this.infoWindow.show();
    }

    public void compareTables(Grib2Customizer.GribTableId id1, Grib2Customizer.GribTableId id2) {
        Grib2Customizer t1 = Grib2Customizer.factory((int)id1.center, (int)id1.subCenter, (int)id1.masterVersion, (int)id1.localVersion);
        Grib2Customizer t2 = Grib2Customizer.factory((int)id2.center, (int)id2.subCenter, (int)id2.masterVersion, (int)id2.localVersion);
        Formatter f = new Formatter();
        f.format("Table 1 = %s%n", id1.name);
        f.format("Table 2 = %s%n", id2.name);
        int extra = 0;
        int conflict = 0;
        f.format("Table 1 : %n", new Object[0]);
        for (Object t : t1.getParameters()) {
            GribTables.Parameter p1 = (GribTables.Parameter)t;
            GribTables.Parameter p2 = t2.getParameter(p1.getDiscipline(), p1.getCategory(), p1.getNumber());
            if (p2 == null) {
                ++extra;
                f.format(" Missing %s in table 2%n", p1);
                continue;
            }
            if (p1.getName().equals(p2.getName()) && p1.getUnit().equals(p2.getUnit()) && (p1 == null || p1.getAbbrev().equals(p2.getAbbrev()))) continue;
            f.format("  t1=%10s %40s %15s  %15s%n", p1.getId(), p1.getName(), p1.getUnit(), p1.getAbbrev());
            f.format("  t2=%10s %40s %15s  %15s%n%n", p2.getId(), p2.getName(), p2.getUnit(), p2.getAbbrev());
            ++conflict;
        }
        f.format("%nConflicts=%d extra=%d%n%n", conflict, extra);
        extra = 0;
        f.format("Table 2 : %n", new Object[0]);
        for (Object t : t2.getParameters()) {
            GribTables.Parameter p2 = (GribTables.Parameter)t;
            GribTables.Parameter p1 = t2.getParameter(p2.getDiscipline(), p2.getCategory(), p2.getNumber());
            if (p1 != null) continue;
            ++extra;
            f.format(" Missing %s in table 1%n", p2);
        }
        f.format("%nextra=%d%n%n", extra);
        this.infoTA.setText(f.toString());
        this.infoWindow.show();
    }

    public class EntryBean {
        GribTables.Parameter param;

        public EntryBean() {
        }

        public EntryBean(GribTables.Parameter param) {
            this.param = param;
        }

        public String getName() {
            return this.param.getName();
        }

        public String getId() {
            return this.param.getDiscipline() + "-" + this.param.getCategory() + "-" + this.param.getNumber();
        }

        public String getUnit() {
            return this.param.getUnit();
        }

        public String getAbbrev() {
            return this.param.getAbbrev();
        }
    }

    public class TableBean
    implements Comparable<TableBean> {
        Grib2Customizer.GribTableId table;

        public TableBean() {
        }

        public TableBean(Grib2Customizer.GribTableId table) {
            this.table = table;
        }

        public String getName() {
            return this.table.name;
        }

        public int getCenter_id() {
            return this.table.center;
        }

        public int getSubcenter_id() {
            return this.table.subCenter;
        }

        public int getVersionNumber() {
            return this.table.masterVersion;
        }

        public int getLocalVersion() {
            return this.table.localVersion;
        }

        @Override
        public int compareTo(TableBean o) {
            int ret = this.getCenter_id() - o.getCenter_id();
            if (ret == 0) {
                ret = this.getSubcenter_id() - o.getSubcenter_id();
            }
            if (ret == 0) {
                ret = this.getVersionNumber() - o.getVersionNumber();
            }
            return ret;
        }
    }
}

