/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.ui.event.ActionSourceListener;
import ucar.nc2.ui.grid.VertScaleSlider;
import ucar.nc2.ui.widget.ScaledPanel;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;

public class VertPanel
extends JPanel {
    private ScaledPanel drawArea;
    private VertScaleSlider vslider;
    private JLabel leftScale;
    private JLabel midScale;
    private JLabel rightScale;
    private JLabel vertUnitsLabel;
    private double yleft = 0.0;
    private double ymid = 0.0;
    private double yright = 0.0;
    private boolean isLatLon = true;
    private Projection proj = null;
    private CoordinateAxis xaxis = null;
    private static boolean debugBounds = false;
    private static boolean debugLevels = false;

    public VertPanel() {
        this.setLayout(new BorderLayout());
        JPanel botScale = new JPanel(new BorderLayout());
        this.leftScale = new JLabel("leftScale");
        this.rightScale = new JLabel("rightScale");
        this.midScale = new JLabel("midScale", 0);
        botScale.add((Component)this.leftScale, "West");
        botScale.add((Component)this.midScale, "Center");
        botScale.add((Component)this.rightScale, "East");
        this.drawArea = new ScaledPanel();
        this.vslider = new VertScaleSlider();
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)this.vslider, "Center");
        this.vertUnitsLabel = new JLabel(" ");
        rightPanel.add((Component)this.vertUnitsLabel, "South");
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.drawArea, "Center");
        leftPanel.add((Component)botScale, "South");
        this.add((Component)leftPanel, "Center");
        this.add((Component)rightPanel, "East");
    }

    public ActionSourceListener getActionSourceListener() {
        return this.vslider.getActionSourceListener();
    }

    public ScaledPanel getDrawArea() {
        return this.drawArea;
    }

    public void setLevels(GridCoordSystem gcs, int current) {
        this.vslider.setLevels(gcs, current);
    }

    public void setCoordSys(GridCoordSystem geocs, int currentLevel) {
        double zupper;
        double zlower;
        CoordinateAxis1D zaxis = geocs.getVerticalAxis();
        if (zaxis == null) {
            return;
        }
        this.vslider.setLevels(geocs, currentLevel);
        this.vertUnitsLabel.setText("  " + zaxis.getUnitsString());
        CoordinateAxis yaxis = geocs.getYHorizAxis();
        if (yaxis == null || zaxis == null) {
            return;
        }
        double zmin = zaxis.getMinValue();
        double zmax = zaxis.getMaxValue();
        if (geocs.isZPositive()) {
            zlower = zmin;
            zupper = zmax;
        } else {
            zlower = zmax;
            zupper = zmin;
        }
        this.yleft = yaxis.getMinValue();
        this.yright = yaxis.getMaxValue();
        if (debugBounds) {
            System.out.println("VertPanel: ascending from " + zlower + " to " + zupper);
            System.out.println("VertPanel: from left " + this.yleft + " to right " + this.yright);
        }
        ScaledPanel.Bounds bounds = new ScaledPanel.Bounds(this.yleft, this.yright, zupper, zlower);
        this.drawArea.setWorldBounds(bounds);
        this.proj = geocs.getProjection();
        this.isLatLon = geocs.isLatLon();
        this.ymid = (this.yleft + this.yright) / 2.0;
        this.xaxis = geocs.getXHorizAxis();
        this.setSlice(0);
    }

    public void setSlice(int slice) {
        if (this.isLatLon) {
            this.leftScale.setText(LatLonPointImpl.latToString((double)this.yleft, (int)3));
            this.midScale.setText(LatLonPointImpl.latToString((double)this.ymid, (int)3));
            this.rightScale.setText(LatLonPointImpl.latToString((double)this.yright, (int)3));
            return;
        }
        double xval = 0.0;
        if (this.xaxis != null && this.xaxis instanceof CoordinateAxis1D) {
            xval = ((CoordinateAxis1D)this.xaxis).getCoordValue(slice);
            this.leftScale.setText(this.getYstr(xval, this.yleft));
            this.midScale.setText(this.getYstr(xval, this.ymid));
            this.rightScale.setText(this.getYstr(xval, this.yright));
        }
        this.repaint();
    }

    private String getYstr(double xvalue, double yvalue) {
        LatLonPointImpl lpt = ((ProjectionImpl)this.proj).projToLatLon(xvalue, yvalue);
        return LatLonPointImpl.latToString((double)lpt.getLatitude(), (int)3);
    }
}

