/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.iosp.bufr.tables.CodeFlagTables;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class BufrWmoCodesPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted codeTable;
    private BeanTableSorted entryTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane compareTA;
    private IndependentWindow infoWindow;
    private FileManager fileChooser;

    public BufrWmoCodesPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.codeTable = new BeanTableSorted(CodeTableBean.class, (PreferencesExt)prefs.node("CodeTableBean"), false);
        this.codeTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CodeTableBean csb = (CodeTableBean)BufrWmoCodesPanel.this.codeTable.getSelectedBean();
                BufrWmoCodesPanel.this.setEntries(csb.code);
            }
        });
        PopupMenu varPopup = new PopupMenu(this.codeTable.getJTable(), "Options");
        varPopup.addAction("Show table", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter out = new Formatter();
                CodeTableBean csb = (CodeTableBean)BufrWmoCodesPanel.this.codeTable.getSelectedBean();
                csb.showTable(out);
                BufrWmoCodesPanel.this.compareTA.setText(out.toString());
                BufrWmoCodesPanel.this.compareTA.gotoTop();
                BufrWmoCodesPanel.this.infoWindow.setVisible(true);
            }
        });
        this.entryTable = new BeanTableSorted(EntryBean.class, (PreferencesExt)prefs.node("EntryBean"), false);
        this.entryTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EntryBean csb = (EntryBean)BufrWmoCodesPanel.this.entryTable.getSelectedBean();
            }
        });
        Map tables = CodeFlagTables.getTables();
        ArrayList<CodeTableBean> beans = new ArrayList<CodeTableBean>(tables.size());
        ArrayList list = new ArrayList(tables.keySet());
        Collections.sort(list);
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            short key = (Short)i$.next();
            beans.add(new CodeTableBean((CodeFlagTables)tables.get(key)));
        }
        this.codeTable.setBeans(beans);
        this.compareTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.compareTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 800, 600)));
        this.split = new JSplitPane(0, false, this.codeTable, this.entryTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.codeTable.saveState(false);
        this.entryTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        if (this.fileChooser != null) {
            this.fileChooser.save();
        }
    }

    public void setEntries(CodeFlagTables codeTable) {
        Map map = codeTable.getMap();
        ArrayList<EntryBean> beans = new ArrayList<EntryBean>(map.size());
        ArrayList list = new ArrayList(map.keySet());
        Collections.sort(list);
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int key = (Integer)i$.next();
            beans.add(new EntryBean(key, (String)map.get(key)));
        }
        this.entryTable.setBeans(beans);
    }

    public class EntryBean {
        int code;
        String value;

        public EntryBean() {
        }

        public EntryBean(int code, String value) {
            this.code = code;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public int getCode() {
            return this.code;
        }
    }

    public class CodeTableBean {
        CodeFlagTables code;

        public CodeTableBean() {
        }

        public CodeTableBean(CodeFlagTables code) {
            this.code = code;
        }

        public String getName() {
            return this.code.getName();
        }

        public String getFxy() {
            return this.code.fxy();
        }

        public short getId() {
            return this.code.getId();
        }

        public int getSize() {
            return this.code.getMap().size();
        }

        void showTable(Formatter f) {
            f.format("Code Table %s (%s)%n", this.code.getName(), this.code.fxy());
            Map map = this.code.getMap();
            Iterator i$ = map.keySet().iterator();
            while (i$.hasNext()) {
                int key = (Integer)i$.next();
                f.format("  %3d: %s%n", key, map.get(key));
            }
        }
    }
}

