/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import thredds.inventory.CollectionManager;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class GribIndexPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted recordTable;
    private JSplitPane split;
    private JSplitPane split2;
    private JSplitPane split3;
    private TextHistoryPane infoPopup;
    private TextHistoryPane detailTA;
    private IndependentWindow infoWindow;
    private IndependentWindow detailWindow;
    Object gc = null;

    public GribIndexPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.recordTable = new BeanTableSorted(RecordBean.class, (PreferencesExt)prefs.node("Grib2RecordBean"), false);
        PopupMenu popup = new PopupMenu(this.recordTable.getJTable(), "Options");
        popup.addAction("Show Record", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordBean bean = (RecordBean)GribIndexPanel.this.recordTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    bean.show(f);
                    GribIndexPanel.this.infoPopup.setText(f.toString());
                    GribIndexPanel.this.infoPopup.gotoTop();
                    GribIndexPanel.this.infoWindow.show();
                }
            }
        });
        this.infoPopup = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.detailTA = new TextHistoryPane();
        this.detailWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.detailTA);
        this.detailWindow.setBounds((Rectangle)prefs.getBean("DetailWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.add((Component)this.recordTable, "Center");
    }

    public void save() {
        this.recordTable.saveState(false);
    }

    public void closeOpenFiles() throws IOException {
        this.gc = null;
    }

    public void setIndexFile(String indexFile) throws IOException {
        this.closeOpenFiles();
        RandomAccessFile raf = new RandomAccessFile(indexFile, "r");
        raf.seek(0L);
        byte[] b = new byte["Grib2Index".getBytes().length];
        raf.read(b);
        String magic = new String(b);
        if (!magic.equals("Grib2Index")) {
            throw new IOException("Not a grib index file =" + magic);
        }
        raf.close();
        this.readIndex2(indexFile);
    }

    public void readIndex2(String filename) throws IOException {
        Grib2Index g2idx = new Grib2Index();
        g2idx.readIndex(filename, 0L, CollectionManager.Force.nocheck);
        ArrayList<RecordBean> records = new ArrayList<RecordBean>();
        for (Grib2Record gr : g2idx.getRecords()) {
            records.add(new RecordBean(gr));
        }
        this.recordTable.setBeans(records);
    }

    public class RecordBean {
        Grib2Record gr;

        public RecordBean() {
        }

        public RecordBean(Grib2Record gr) {
            this.gr = gr;
        }

        public int getFile() {
            return this.gr.getFile();
        }

        public String getReferenceDate() {
            return this.gr.getReferenceDate().toString();
        }

        private void show(Formatter f) {
            this.gr.show(f);
        }
    }
}

